/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.delete;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.UnableToDeleteFileException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.delete.DefaultDeleteSpec;
import org.gradle.api.internal.file.delete.DeleteSpecInternal;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deleter.class);
    private final FileResolver fileResolver;
    private final FileSystem fileSystem;
    private final Clock clock;
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    static final int MAX_REPORTED_PATHS = 16;
    static final String HELP_FAILED_DELETE_CHILDREN = "Failed to delete some children. This might happen because a process has files open or has its working directory set in the target directory.";
    static final String HELP_NEW_CHILDREN = "New files were found. This might happen because a process is still writing to the target directory.";

    public Deleter(FileResolver fileResolver, FileSystem fileSystem, Clock clock) {
        this.fileResolver = fileResolver;
        this.fileSystem = fileSystem;
        this.clock = clock;
    }

    public boolean delete(Object ... paths) {
        final Object[] innerPaths = paths;
        return this.delete((Action<? super DeleteSpec>)new Action<DeleteSpec>(){

            public void execute(DeleteSpec deleteSpec) {
                deleteSpec.delete(innerPaths).setFollowSymlinks(false);
            }
        }).getDidWork();
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        boolean didWork = false;
        DefaultDeleteSpec deleteSpec = new DefaultDeleteSpec();
        action.execute((Object)deleteSpec);
        Object[] paths = deleteSpec.getPaths();
        for (File file : this.fileResolver.resolveFiles(paths)) {
            if (!file.exists()) continue;
            LOGGER.debug("Deleting {}", (Object)file);
            didWork = true;
            this.doDeleteInternal(file, deleteSpec);
        }
        return WorkResults.didWork((boolean)didWork);
    }

    private void doDeleteInternal(File file, DeleteSpecInternal deleteSpec) {
        long startTime = this.clock.getCurrentTime();
        ArrayList<String> failedPaths = new ArrayList<String>();
        this.deleteRecursively(startTime, file, file, deleteSpec, failedPaths);
        if (!failedPaths.isEmpty()) {
            this.throwWithHelpMessage(startTime, file, deleteSpec, failedPaths, false);
        }
    }

    private void deleteRecursively(long startTime, File baseDir, File file, DeleteSpecInternal deleteSpec, Collection<String> failedPaths) {
        if (file.isDirectory() && (deleteSpec.isFollowSymlinks() || !this.fileSystem.isSymlink(file))) {
            File[] contents = file.listFiles();
            if (contents == null) {
                return;
            }
            for (File item : contents) {
                this.deleteRecursively(startTime, baseDir, item, deleteSpec, failedPaths);
            }
        }
        if (!this.deleteFile(file)) {
            this.handleFailedDelete(file, failedPaths);
            if (failedPaths.size() == 16) {
                this.throwWithHelpMessage(startTime, baseDir, deleteSpec, failedPaths, true);
            }
        }
    }

    protected boolean deleteFile(File file) {
        return file.delete() && !file.exists();
    }

    private void handleFailedDelete(File file, Collection<String> failedPaths) {
        if (this.isRunGcOnFailedDelete()) {
            System.gc();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (!this.deleteFile(file)) {
            failedPaths.add(file.getAbsolutePath());
        }
    }

    private boolean isRunGcOnFailedDelete() {
        return OperatingSystem.current().isWindows();
    }

    private void throwWithHelpMessage(long startTime, File file, DeleteSpecInternal deleteSpec, Collection<String> failedPaths, boolean more) {
        throw new UnableToDeleteFileException(file, this.buildHelpMessageForFailedDelete(startTime, file, deleteSpec, failedPaths, more));
    }

    private String buildHelpMessageForFailedDelete(long startTime, File file, DeleteSpecInternal deleteSpec, Collection<String> failedPaths, boolean more) {
        boolean isSymlink = this.fileSystem.isSymlink(file);
        boolean isDirectory = file.isDirectory();
        StringBuilder help = new StringBuilder("Unable to delete ");
        if (isSymlink) {
            help.append("symlink to ");
        }
        if (isDirectory) {
            help.append("directory ");
        } else {
            help.append("file ");
        }
        help.append('\'').append(file).append('\'');
        if (isDirectory && (deleteSpec.isFollowSymlinks() || !isSymlink)) {
            Collection<String> newPaths;
            String absolutePath = file.getAbsolutePath();
            failedPaths.remove(absolutePath);
            if (!failedPaths.isEmpty()) {
                help.append("\n  ").append(HELP_FAILED_DELETE_CHILDREN);
                for (String failed : failedPaths) {
                    help.append("\n  - ").append(failed);
                }
                if (more) {
                    help.append("\n  - and more ...");
                }
            }
            if (!(newPaths = this.listNewPaths(startTime, file, failedPaths)).isEmpty()) {
                help.append("\n  ").append(HELP_NEW_CHILDREN);
                for (String newPath : newPaths) {
                    help.append("\n  - ").append(newPath);
                }
                if (newPaths.size() == 16) {
                    help.append("\n  - and more ...");
                }
            }
        }
        return help.toString();
    }

    private Collection<String> listNewPaths(long startTime, File directory, Collection<String> failedPaths) {
        ArrayList<String> paths = new ArrayList<String>(16);
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(directory);
        while (!stack.isEmpty() && paths.size() < 16) {
            File[] children;
            File current = (File)stack.pop();
            String absolutePath = current.getAbsolutePath();
            if (!current.equals(directory) && !failedPaths.contains(absolutePath) && current.lastModified() >= startTime) {
                paths.add(absolutePath);
            }
            if (!current.isDirectory() || (children = current.listFiles()) == null) continue;
            for (File child : children) {
                stack.push(child);
            }
        }
        return paths;
    }
}

