/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiRecordUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public enum AccessModifier {
    PUBLIC("public"),
    PROTECTED("protected"),
    PACKAGE_LOCAL("packageLocal"),
    PRIVATE("private");

    public static final List<AccessModifier> ALL_MODIFIERS;
    private static final List<AccessModifier> PUBLIC_PACKAGE;
    private static final List<AccessModifier> PUBLIC_PRIVATE;
    @NotNull
    @PsiModifier.ModifierConstant
    private final String myModifier;

    private AccessModifier(String modifier) {
        if (modifier == null) {
            AccessModifier.$$$reportNull$$$0(0);
        }
        this.myModifier = modifier;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    public String toPsiModifier() {
        String string2 = this.myModifier;
        if (string2 == null) {
            AccessModifier.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean hasModifier(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            AccessModifier.$$$reportNull$$$0(2);
        }
        return owner.hasModifierProperty(this.toPsiModifier());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromKeyword(@Nullable PsiKeyword keyword) {
        return keyword == null ? null : AccessModifier.fromPsiModifier(keyword.getText());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromPsiModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return PUBLIC;
            }
            case "protected": {
                return PROTECTED;
            }
            case "packageLocal": {
                return PACKAGE_LOCAL;
            }
            case "private": {
                return PRIVATE;
            }
        }
        return null;
    }

    public static AccessModifier fromModifierList(@NotNull PsiModifierList modifierList2) {
        if (modifierList2 == null) {
            AccessModifier.$$$reportNull$$$0(3);
        }
        if (modifierList2.hasModifierProperty("private")) {
            return PRIVATE;
        }
        if (modifierList2.hasModifierProperty("packageLocal")) {
            return PACKAGE_LOCAL;
        }
        if (modifierList2.hasModifierProperty("protected")) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    public boolean isWeaker(@NotNull AccessModifier other) {
        if (other == null) {
            AccessModifier.$$$reportNull$$$0(4);
        }
        return this.compareTo(other) < 0;
    }

    public String toString() {
        String psiModifier = this.toPsiModifier();
        return psiModifier.equals(AccessModifier.PACKAGE_LOCAL.myModifier) ? "package-private" : psiModifier;
    }

    @NotNull
    public static List<AccessModifier> getAvailableModifiers(PsiMember member2) {
        if (member2 == null) {
            List<AccessModifier> list2 = Collections.emptyList();
            if (list2 == null) {
                AccessModifier.$$$reportNull$$$0(5);
            }
            return list2;
        }
        PsiClass containingClass = member2.getContainingClass();
        if (member2 instanceof PsiField) {
            if (member2 instanceof PsiEnumConstant || containingClass == null || containingClass.isInterface()) {
                List<AccessModifier> list3 = Collections.emptyList();
                if (list3 == null) {
                    AccessModifier.$$$reportNull$$$0(6);
                }
                return list3;
            }
            List<AccessModifier> list4 = ALL_MODIFIERS;
            if (list4 == null) {
                AccessModifier.$$$reportNull$$$0(7);
            }
            return list4;
        }
        if (member2 instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member2;
            if (containingClass == null || containingClass.isEnum() && method.isConstructor()) {
                List<AccessModifier> list5 = Collections.emptyList();
                if (list5 == null) {
                    AccessModifier.$$$reportNull$$$0(8);
                }
                return list5;
            }
            if (JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                List<AccessModifier> list6 = Collections.singletonList(PUBLIC);
                if (list6 == null) {
                    AccessModifier.$$$reportNull$$$0(9);
                }
                return list6;
            }
            if (JavaPsiRecordUtil.isCompactConstructor(method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(method) || method instanceof LightRecordCanonicalConstructor) {
                PsiModifierList list7;
                if (PsiUtil.getLanguageLevel(member2) != LanguageLevel.JDK_14_PREVIEW && (list7 = containingClass.getModifierList()) != null) {
                    AccessModifier classModifier = AccessModifier.fromModifierList(list7);
                    List<AccessModifier> list8 = ContainerUtil.filter(ALL_MODIFIERS, m -> !classModifier.isWeaker((AccessModifier)((Object)m)));
                    if (list8 == null) {
                        AccessModifier.$$$reportNull$$$0(10);
                    }
                    return list8;
                }
                List<AccessModifier> list9 = Collections.singletonList(PUBLIC);
                if (list9 == null) {
                    AccessModifier.$$$reportNull$$$0(11);
                }
                return list9;
            }
            if (containingClass.isInterface()) {
                if (method.getBody() != null && PsiUtil.isLanguageLevel9OrHigher(member2)) {
                    List<AccessModifier> list10 = PUBLIC_PRIVATE;
                    if (list10 == null) {
                        AccessModifier.$$$reportNull$$$0(12);
                    }
                    return list10;
                }
                List<AccessModifier> list11 = Collections.singletonList(PUBLIC);
                if (list11 == null) {
                    AccessModifier.$$$reportNull$$$0(13);
                }
                return list11;
            }
            AccessModifier minAccess = AccessModifier.getMinAccess(method);
            if (minAccess != PRIVATE) {
                List<AccessModifier> list12 = ContainerUtil.filter(ALL_MODIFIERS, mod -> mod.compareTo(minAccess) <= 0);
                if (list12 == null) {
                    AccessModifier.$$$reportNull$$$0(14);
                }
                return list12;
            }
            List<AccessModifier> list13 = ALL_MODIFIERS;
            if (list13 == null) {
                AccessModifier.$$$reportNull$$$0(15);
            }
            return list13;
        }
        if (member2 instanceof PsiClass) {
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)member2)) {
                List<AccessModifier> list14 = Collections.emptyList();
                if (list14 == null) {
                    AccessModifier.$$$reportNull$$$0(16);
                }
                return list14;
            }
            if (containingClass == null) {
                List<AccessModifier> list15 = PUBLIC_PACKAGE;
                if (list15 == null) {
                    AccessModifier.$$$reportNull$$$0(17);
                }
                return list15;
            }
            List<AccessModifier> list16 = ALL_MODIFIERS;
            if (list16 == null) {
                AccessModifier.$$$reportNull$$$0(18);
            }
            return list16;
        }
        List<AccessModifier> list17 = Collections.emptyList();
        if (list17 == null) {
            AccessModifier.$$$reportNull$$$0(19);
        }
        return list17;
    }

    @NotNull
    private static AccessModifier getMinAccess(PsiMethod method) {
        HierarchicalMethodSignature superSignature;
        PsiMethod superMethod;
        AccessModifier current;
        if (method.isConstructor() || method.hasModifierProperty("static")) {
            AccessModifier accessModifier = PRIVATE;
            if (accessModifier == null) {
                AccessModifier.$$$reportNull$$$0(20);
            }
            return accessModifier;
        }
        HierarchicalMethodSignature signature2 = method.getHierarchicalMethodSignature();
        AccessModifier lowest = PRIVATE;
        Iterator<HierarchicalMethodSignature> iterator2 = signature2.getSuperSignatures().iterator();
        while (iterator2.hasNext() && (!(current = AccessModifier.fromModifierList((superMethod = (superSignature = iterator2.next()).getMethod()).getModifierList())).isWeaker(lowest) || method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod(superMethod, method) || !PsiUtil.isAccessible(method.getProject(), superMethod, method, null) || (lowest = current) != PUBLIC)) {
        }
        AccessModifier accessModifier = lowest;
        if (accessModifier == null) {
            AccessModifier.$$$reportNull$$$0(21);
        }
        return accessModifier;
    }

    static {
        ALL_MODIFIERS = ContainerUtil.immutableList(AccessModifier.values());
        PUBLIC_PACKAGE = ContainerUtil.immutableList(PUBLIC, PACKAGE_LOCAL);
        PUBLIC_PRIVATE = ContainerUtil.immutableList(PUBLIC, PRIVATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/AccessModifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/AccessModifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiModifier";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableModifiers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWeaker";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

