/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.internal.jni.AbstractFileEventFunctions;
import net.rubygrapefruit.platform.internal.jni.InotifyInstanceLimitTooLowException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxFileEventFunctions
extends AbstractFileEventFunctions<LinuxFileWatcher> {
    public LinuxFileEventFunctions() {
        if (!LinuxFileEventFunctions.isGlibc0()) {
            throw new NativeIntegrationUnavailableException("File events on Linux are only supported with glibc");
        }
    }

    private static native boolean isGlibc0();

    public WatcherBuilder newWatcher(BlockingQueue<FileWatchEvent> eventQueue) {
        return new WatcherBuilder(eventQueue);
    }

    private static native Object startWatcher0(AbstractFileEventFunctions.NativeFileWatcherCallback var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WatcherBuilder
    extends AbstractFileEventFunctions.AbstractWatcherBuilder<LinuxFileWatcher> {
        WatcherBuilder(BlockingQueue<FileWatchEvent> eventQueue) {
            super(eventQueue);
        }

        @Override
        protected Object startWatcher(AbstractFileEventFunctions.NativeFileWatcherCallback callback) throws InotifyInstanceLimitTooLowException {
            return LinuxFileEventFunctions.startWatcher0(callback);
        }

        @Override
        protected LinuxFileWatcher createWatcher(Object server, long startTimeout, TimeUnit startTimeoutUnit, AbstractFileEventFunctions.NativeFileWatcherCallback callback) throws InterruptedException {
            return new LinuxFileWatcher(server, startTimeout, startTimeoutUnit, callback);
        }
    }

    public static class LinuxFileWatcher
    extends AbstractFileEventFunctions.NativeFileWatcher {
        public LinuxFileWatcher(Object server, long startTimeout, TimeUnit startTimeoutUnit, AbstractFileEventFunctions.NativeFileWatcherCallback callback) throws InterruptedException {
            super(server, startTimeout, startTimeoutUnit, callback);
        }
    }
}

