/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.fingerprint;

import com.google.common.collect.ImmutableSortedMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.snapshot.ValueSnapshot;

public interface InputFingerprinter {
    public Result fingerprintInputProperties(ImmutableSortedMap<String, ValueSnapshot> var1, ImmutableSortedMap<String, ? extends FileCollectionFingerprint> var2, ImmutableSortedMap<String, ValueSnapshot> var3, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var4, Consumer<InputVisitor> var5) throws InputFingerprintingException, InputFileFingerprintingException;

    public FileCollectionFingerprinterRegistry getFingerprinterRegistry();

    public static class InputFileFingerprintingException
    extends RuntimeException {
        private final String propertyName;

        public InputFileFingerprintingException(String propertyName, Throwable cause) {
            super(String.format("Cannot fingerprint input file property '%s'.", propertyName), cause);
            this.propertyName = propertyName;
        }

        private InputFileFingerprintingException(String formattedMessage, Throwable cause, String propertyName) {
            super(formattedMessage, cause);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class InputFingerprintingException
    extends RuntimeException {
        private final String propertyName;

        public InputFingerprintingException(String propertyName, String message, Throwable cause) {
            super(String.format("Cannot fingerprint input property '%s': %s.", propertyName, message), cause);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static interface Result {
        public ImmutableSortedMap<String, ValueSnapshot> getValueSnapshots();

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFileFingerprints();
    }

    public static class FileValueSupplier
    implements ValueSupplier {
        private final Object value;
        private final Class<? extends FileNormalizer> normalizer;
        private final DirectorySensitivity directorySensitivity;
        private final LineEndingSensitivity lineEndingSensitivity;
        private final Supplier<FileCollection> files;

        public FileValueSupplier(@Nullable Object value, Class<? extends FileNormalizer> normalizer, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, Supplier<FileCollection> files) {
            this.value = value;
            this.normalizer = normalizer;
            this.directorySensitivity = directorySensitivity;
            this.lineEndingSensitivity = lineEndingSensitivity;
            this.files = files;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public Class<? extends FileNormalizer> getNormalizer() {
            return this.normalizer;
        }

        public DirectorySensitivity getDirectorySensitivity() {
            return this.directorySensitivity;
        }

        public LineEndingSensitivity getLineEndingNormalization() {
            return this.lineEndingSensitivity;
        }

        public FileCollection getFiles() {
            return this.files.get();
        }
    }

    public static interface ValueSupplier {
        @Nullable
        public Object getValue();
    }

    public static enum InputPropertyType {
        NON_INCREMENTAL(false, false),
        INCREMENTAL(true, false),
        PRIMARY(true, true);

        private final boolean incremental;
        private final boolean skipWhenEmpty;

        private InputPropertyType(boolean incremental, boolean skipWhenEmpty) {
            this.incremental = incremental;
            this.skipWhenEmpty = skipWhenEmpty;
        }

        public boolean isIncremental() {
            return this.incremental;
        }

        public boolean isSkipWhenEmpty() {
            return this.skipWhenEmpty;
        }
    }

    public static interface InputVisitor {
        default public void visitInputProperty(String propertyName, ValueSupplier value) {
        }

        default public void visitInputFileProperty(String propertyName, InputPropertyType type, FileValueSupplier value) {
        }
    }
}

