tell application "Daylite"
	activate
	eval "
		doc := (NSApplication sharedApplication) firstDayliteDocument.
		mwc := doc firstMainWindowController.

		(mwc ~= nil)ifTrue:
		[
			slv := mwc valueForKey:'sourceListView'.
			slv selectButtonWithIdentifier:'Calendar'.
			date := NSCalendarDate dateWithTimeIntervalSinceReferenceDate:#TIME_INTERVAL.
			mode := #VIEW_MODE.
			
			uinfo := NSMutableDictionary dictionary.
			uinfo setObject:(mwc window) forKey:'Window'.
			uinfo setObject:date forKey:'Date'.
			uinfo setObject:mode forKey:'ViewMode'.
			
			(NSNotificationCenter defaultCenter) postNotificationName:'MCCGoToDayNotification' object:mwc userInfo:uinfo.
			
			(mode = 2) ifTrue:
			[
				multi_day := ((mwc window) contentView) nestedSubviewOfClass:('MCCMultiDayView' asClass).
				header := multi_day valueForKey:'_headerView'.
				col_index := (header dateRange) indexOfDate:date.
				header setValue:col_index forKey:'_selectedColumn'.
				header setNeedsDisplay:true.
				
				multi_day selectColumnAtIndex:col_index.
			
			].
			

		].
	
	"
end tell