/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.HashMap;
import shared.FileUtils;
import shared.b;
import shared.m;
import shared.uncaughtexception;

public class ChunkHandler {
    public HashMap<Integer, ChunkFile> files = new HashMap();

    public ChunkFile startfile(String filename, int filesize, int transId) {
        ChunkFile file = this.files.get(transId);
        if (file == null) {
            file = new ChunkFile(filename, filesize);
            this.files.put(transId, file);
            return file;
        }
        throw new uncaughtexception("File already started?");
    }

    public ChunkFile addChunk(int transId, int filesize, int offset, byte[] chunk) {
        ChunkFile file = this.files.get(transId);
        if (file == null) {
            m.throwUncaughtException("File wasn't requested?");
        }
        file.addChunk(offset, chunk);
        return file;
    }

    public ChunkFile clearfile(int transId) {
        ChunkFile file = this.files.get(transId);
        this.files.remove(transId);
        return file;
    }

    public static class ChunkFile {
        String filename;
        byte[] data;
        boolean done;

        public ChunkFile(String filename2, int filesize) {
            this.filename = filename2;
            this.data = new byte[filesize];
            this.done = false;
        }

        public void addChunk(int offset, byte[] chunk) {
            b.CopyBytes(chunk, this.data, offset);
            if (this.data.length == offset + chunk.length) {
                this.done = true;
            }
        }

        public void saveToFile(String filename) {
            if (!this.done) {
                m.throwUncaughtException("File wasn't done yet!");
            }
            FileUtils.WriteFile(filename, this.data, true, true);
        }

        public byte[] getBytes() {
            return this.data;
        }
    }
}

