/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;

public class RealMatrixImpl
implements RealMatrix,
Serializable {
    private static final long serialVersionUID = 4237564493130426188L;
    private double[][] data = null;
    private double[][] lu = null;
    private int[] permutation = null;
    private int parity = 1;
    protected static double TOO_SMALL = 1.0E-11;

    public RealMatrixImpl() {
    }

    public RealMatrixImpl(int rowDimension, int columnDimension) {
        if (rowDimension <= 0 || columnDimension <= 0) {
            throw new IllegalArgumentException("row and column dimensions must be postive");
        }
        this.data = new double[rowDimension][columnDimension];
        this.lu = null;
    }

    public RealMatrixImpl(double[][] d) {
        this.copyIn(d);
        this.lu = null;
    }

    public RealMatrixImpl(double[] v) {
        int nRows = v.length;
        this.data = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    public RealMatrix copy() {
        return new RealMatrixImpl(this.copyOut());
    }

    public RealMatrix add(RealMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getColumnDimension() || this.getRowDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] + m2.getEntry(row, col);
            }
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix subtract(RealMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getColumnDimension() || this.getRowDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("matrix dimension mismatch");
        }
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] - m2.getEntry(row, col);
            }
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix scalarAdd(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] + d;
            }
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix scalarMultiply(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        double[][] outData = new double[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                outData[row][col] = this.data[row][col] * d;
            }
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix multiply(RealMatrix m2) throws IllegalArgumentException {
        if (this.getColumnDimension() != m2.getRowDimension()) {
            throw new IllegalArgumentException("Matrices are not multiplication compatible.");
        }
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        double[][] outData = new double[nRows][nCols];
        double sum = 0.0;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += this.data[row][i] * m2.getEntry(i, col);
                }
                outData[row][col] = sum;
            }
        }
        return new RealMatrixImpl(outData);
    }

    public RealMatrix preMultiply(RealMatrix m2) throws IllegalArgumentException {
        return m2.multiply(this);
    }

    public double[][] getData() {
        return this.copyOut();
    }

    public double[][] getDataRef() {
        return this.data;
    }

    public double getNorm() {
        double maxColSum = 0.0;
        for (int col = 0; col < this.getColumnDimension(); ++col) {
            double sum = 0.0;
            for (int row = 0; row < this.getRowDimension(); ++row) {
                sum += Math.abs(this.data[row][col]);
            }
            maxColSum = Math.max(maxColSum, sum);
        }
        return maxColSum;
    }

    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        if (startRow < 0 || startRow > endRow || endRow > this.data.length || startColumn < 0 || startColumn > endColumn || endColumn > this.data[0].length) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        RealMatrixImpl subMatrix = new RealMatrixImpl(endRow - startRow + 1, endColumn - startColumn + 1);
        double[][] subMatrixData = subMatrix.getDataRef();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                subMatrixData[i - startRow][j - startColumn] = this.data[i][j];
            }
        }
        return subMatrix;
    }

    public RealMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        if (selectedRows.length * selectedColumns.length == 0) {
            throw new MatrixIndexException("selected row and column index arrays must be non-empty");
        }
        RealMatrixImpl subMatrix = new RealMatrixImpl(selectedRows.length, selectedColumns.length);
        double[][] subMatrixData = subMatrix.getDataRef();
        try {
            for (int i = 0; i < selectedRows.length; ++i) {
                for (int j = 0; j < selectedColumns.length; ++j) {
                    subMatrixData[i][j] = this.data[selectedRows[i]][selectedColumns[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new MatrixIndexException("matrix dimension mismatch");
        }
        return subMatrix;
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (row < 0 || column < 0) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new IllegalArgumentException("Matrix must have at least one row.");
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new IllegalArgumentException("Matrix must have at least one column.");
        }
        for (int r = 1; r < nRows; ++r) {
            if (subMatrix[r].length == nCols) continue;
            throw new IllegalArgumentException("All input rows must have the same length.");
        }
        if (this.data == null) {
            if (row > 0 || column > 0) {
                throw new MatrixIndexException("matrix must be initialized to perfom this method");
            }
            this.data = new double[nRows][nCols];
            System.arraycopy(subMatrix, 0, this.data, 0, subMatrix.length);
        }
        if (nRows + row > this.getRowDimension() || nCols + column > this.getColumnDimension()) {
            throw new MatrixIndexException("invalid row or column index selection");
        }
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(subMatrix[i], 0, this.data[row + i], column, nCols);
        }
        this.lu = null;
    }

    public RealMatrix getRowMatrix(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[][] out = new double[1][ncols];
        System.arraycopy(this.data[row], 0, out[0], 0, ncols);
        return new RealMatrixImpl(out);
    }

    public RealMatrix getColumnMatrix(int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, column)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][1];
        for (int row = 0; row < nRows; ++row) {
            out[row][0] = this.data[row][column];
        }
        return new RealMatrixImpl(out);
    }

    public double[] getRow(int row) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, 0)) {
            throw new MatrixIndexException("illegal row argument");
        }
        int ncols = this.getColumnDimension();
        double[] out = new double[ncols];
        System.arraycopy(this.data[row], 0, out, 0, ncols);
        return out;
    }

    public double[] getColumn(int col) throws MatrixIndexException {
        if (!this.isValidCoordinate(0, col)) {
            throw new MatrixIndexException("illegal column argument");
        }
        int nRows = this.getRowDimension();
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            out[row] = this.data[row][col];
        }
        return out;
    }

    public double getEntry(int row, int column) throws MatrixIndexException {
        if (!this.isValidCoordinate(row, column)) {
            throw new MatrixIndexException("matrix entry does not exist");
        }
        return this.data[row][column];
    }

    public RealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        RealMatrixImpl out = new RealMatrixImpl(nCols, nRows);
        double[][] outData = out.getDataRef();
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                outData[col][row] = this.data[row][col];
            }
        }
        return out;
    }

    public RealMatrix inverse() throws InvalidMatrixException {
        return this.solve(MatrixUtils.createRealIdentityMatrix(this.getRowDimension()));
    }

    public double getDeterminant() throws InvalidMatrixException {
        if (!this.isSquare()) {
            throw new InvalidMatrixException("matrix is not square");
        }
        if (this.isSingular()) {
            return 0.0;
        }
        double det = this.parity;
        for (int i = 0; i < this.getRowDimension(); ++i) {
            det *= this.lu[i][i];
        }
        return det;
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    public boolean isSingular() {
        if (this.lu == null) {
            try {
                this.luDecompose();
                return false;
            }
            catch (InvalidMatrixException ex) {
                return true;
            }
        }
        return false;
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data[0].length;
    }

    public double getTrace() throws IllegalArgumentException {
        if (!this.isSquare()) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double trace = this.data[0][0];
        for (int i = 1; i < this.getRowDimension(); ++i) {
            trace += this.data[i][i];
        }
        return trace;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        if (v.length != this.getColumnDimension()) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        double[] out = new double[v.length];
        for (int row = 0; row < nRows; ++row) {
            double sum = 0.0;
            for (int i = 0; i < nCols; ++i) {
                sum += this.data[row][i] * v[i];
            }
            out[row] = sum;
        }
        return out;
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        if (v.length != nRows) {
            throw new IllegalArgumentException("vector has wrong length");
        }
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i = 0; i < nRows; ++i) {
                sum += this.data[i][col] * v[i];
            }
            out[col] = sum;
        }
        return out;
    }

    public double[] solve(double[] b2) throws IllegalArgumentException, InvalidMatrixException {
        int nRows = this.getRowDimension();
        if (b2.length != nRows) {
            throw new IllegalArgumentException("constant vector has wrong length");
        }
        RealMatrixImpl bMatrix = new RealMatrixImpl(b2);
        double[][] solution = ((RealMatrixImpl)this.solve(bMatrix)).getDataRef();
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            out[row] = solution[row][0];
        }
        return out;
    }

    public RealMatrix solve(RealMatrix b2) throws IllegalArgumentException, InvalidMatrixException {
        int j;
        int i;
        int col;
        if (b2.getRowDimension() != this.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect row dimension");
        }
        if (!this.isSquare()) {
            throw new InvalidMatrixException("coefficient matrix is not square");
        }
        if (this.isSingular()) {
            throw new InvalidMatrixException("Matrix is singular.");
        }
        int nCol = this.getColumnDimension();
        int nColB = b2.getColumnDimension();
        int nRowB = b2.getRowDimension();
        double[][] bp = new double[nRowB][nColB];
        for (int row = 0; row < nRowB; ++row) {
            for (int col2 = 0; col2 < nColB; ++col2) {
                bp[row][col2] = b2.getEntry(this.permutation[row], col2);
            }
        }
        for (col = 0; col < nCol; ++col) {
            for (i = col + 1; i < nCol; ++i) {
                for (j = 0; j < nColB; ++j) {
                    double[] dArray = bp[i];
                    int n = j;
                    dArray[n] = dArray[n] - bp[col][j] * this.lu[i][col];
                }
            }
        }
        for (col = nCol - 1; col >= 0; --col) {
            int j2 = 0;
            while (j2 < nColB) {
                double[] dArray = bp[col];
                int n = j2++;
                dArray[n] = dArray[n] / this.lu[col][col];
            }
            for (i = 0; i < col; ++i) {
                for (j = 0; j < nColB; ++j) {
                    double[] dArray = bp[i];
                    int n = j;
                    dArray[n] = dArray[n] - bp[col][j] * this.lu[i][col];
                }
            }
        }
        RealMatrixImpl outMat = new RealMatrixImpl(bp);
        return outMat;
    }

    public void luDecompose() throws InvalidMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new InvalidMatrixException("LU decomposition requires that the matrix be square.");
        }
        this.lu = this.getData();
        this.permutation = new int[nRows];
        for (int row = 0; row < nRows; ++row) {
            this.permutation[row] = row;
        }
        this.parity = 1;
        for (int col = 0; col < nCols; ++col) {
            int row;
            double sum = 0.0;
            for (int row2 = 0; row2 < col; ++row2) {
                sum = this.lu[row2][col];
                for (int i = 0; i < row2; ++i) {
                    sum -= this.lu[row2][i] * this.lu[i][col];
                }
                this.lu[row2][col] = sum;
            }
            int max = col;
            double largest = 0.0;
            for (row = col; row < nRows; ++row) {
                sum = this.lu[row][col];
                for (int i = 0; i < col; ++i) {
                    sum -= this.lu[row][i] * this.lu[i][col];
                }
                this.lu[row][col] = sum;
                if (!(Math.abs(sum) > largest)) continue;
                largest = Math.abs(sum);
                max = row;
            }
            if (Math.abs(this.lu[max][col]) < TOO_SMALL) {
                this.lu = null;
                throw new InvalidMatrixException("matrix is singular");
            }
            if (max != col) {
                double tmp = 0.0;
                for (int i = 0; i < nCols; ++i) {
                    tmp = this.lu[max][i];
                    this.lu[max][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                }
                int temp = this.permutation[max];
                this.permutation[max] = this.permutation[col];
                this.permutation[col] = temp;
                this.parity = -this.parity;
            }
            for (row = col + 1; row < nRows; ++row) {
                double[] dArray = this.lu[row];
                int n = col;
                dArray[n] = dArray[n] / this.lu[col][col];
            }
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("RealMatrixImpl{");
        if (this.data != null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    res.append(",");
                }
                res.append("{");
                for (int j = 0; j < this.data[0].length; ++j) {
                    if (j > 0) {
                        res.append(",");
                    }
                    res.append(this.data[i][j]);
                }
                res.append("}");
            }
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrixImpl)) {
            return false;
        }
        RealMatrix m2 = (RealMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m2.getColumnDimension() != nCols || m2.getRowDimension() != nRows) {
            return false;
        }
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                if (Double.doubleToLongBits(this.data[row][col]) == Double.doubleToLongBits(m2.getEntry(row, col))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
            }
        }
        return ret;
    }

    protected RealMatrix getIdentity(int dimension) {
        return MatrixUtils.createRealIdentityMatrix(dimension);
    }

    protected RealMatrix getLUMatrix() throws InvalidMatrixException {
        if (this.lu == null) {
            this.luDecompose();
        }
        return new RealMatrixImpl(this.lu);
    }

    protected int[] getPermutation() {
        int[] out = new int[this.permutation.length];
        System.arraycopy(this.permutation, 0, out, 0, this.permutation.length);
        return out;
    }

    private double[][] copyOut() {
        int nRows = this.getRowDimension();
        double[][] out = new double[nRows][this.getColumnDimension()];
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(double[][] in) {
        this.setSubMatrix(in, 0, 0);
    }

    private boolean isValidCoordinate(int row, int col) {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        return row >= 0 && row <= nRows - 1 && col >= 0 && col <= nCols - 1;
    }
}

