/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.util.Vector;
import shared.Bytes;
import shared.Format;
import shared.generic;
import shared.m;
import uru.Bytedeque;

public class textfile {
    protected Bytes[] lines = new Bytes[0];

    public void removeVariables(String varname) {
        Vector<Bytes> result = new Vector<Bytes>();
        Bytes start = new Bytes(varname + "=");
        for (int i = 0; i < this.lines.length; ++i) {
            if (this.lines[i].startsWith(start)) continue;
            result.add(this.lines[i]);
        }
        this.lines = (Bytes[])generic.convertVectorToArray(result, Bytes.class);
    }

    public textline[] getLines() {
        textline[] result = new textline[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            result[i] = new textline(this.lines, i);
        }
        return result;
    }

    public static textfile createFromBytes(byte[] bytes) {
        return textfile.createFromBytes(new Bytes(bytes));
    }

    public static textfile createFromBytes(Bytes bytes) {
        textfile result = new textfile();
        Bytes text = bytes;
        text = text.remove((byte)10);
        result.lines = text.split((byte)13);
        return result;
    }

    public void dump() {
        for (int i = 0; i < this.lines.length; ++i) {
            m.msg(this.lines[i].toString());
        }
    }

    public void appendLine(String line) {
        Bytes newline = Bytes.create(line);
        Bytes[] newlines = new Bytes[this.lines.length + 1];
        for (int i = 0; i < this.lines.length; ++i) {
            newlines[i] = this.lines[i];
        }
        newlines[this.lines.length] = newline;
        this.lines = newlines;
    }

    public Bytes saveToBytes() {
        Bytedeque result = new Bytedeque(Format.none);
        for (Bytes line : this.lines) {
            result.writeBytes(line);
            result.writeByte((byte)13);
            result.writeByte((byte)10);
        }
        return result.getBytes();
    }

    public byte[] saveToByteArray() {
        Bytedeque result = new Bytedeque(Format.none);
        for (Bytes line : this.lines) {
            result.writeBytes(line);
            result.writeByte((byte)13);
            result.writeByte((byte)10);
        }
        return result.getAllBytes();
    }

    public boolean hasVariable(String varname) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].startsWith(new Bytes(varname + "="))) continue;
            return true;
        }
        return false;
    }

    public String getVariable(String varname) {
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].startsWith(new Bytes(varname + "="))) continue;
            int pos = varname.length() + 1;
            String result = this.lines[i].substr(pos).toString();
            return result;
        }
        return null;
    }

    public void setVariable(String varname, String value) {
        Bytes start = new Bytes(varname + "=");
        for (int i = 0; i < this.lines.length; ++i) {
            if (!this.lines[i].startsWith(start)) continue;
            this.lines[i] = start.append(new Bytes(value));
            return;
        }
        m.err("textfile: setVariable: Variable not found.");
    }

    public static class textline {
        Bytes line;

        public textline(Bytes[] lines, int index) {
            this.line = lines[index];
        }

        public String getString() {
            return this.line.toString();
        }

        public void setString(String newvalue) {
            this.line.setWithString(newvalue);
        }
    }
}

