/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class MotifTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color unselectedTabBackground;
    protected Color unselectedTabForeground;
    protected Color unselectedTabShadow;
    protected Color unselectedTabHighlight;

    public static ComponentUI createUI(JComponent tabbedPane) {
        return new MotifTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.unselectedTabBackground = UIManager.getColor("TabbedPane.unselectedTabBackground");
        this.unselectedTabForeground = UIManager.getColor("TabbedPane.unselectedTabForeground");
        this.unselectedTabShadow = UIManager.getColor("TabbedPane.unselectedTabShadow");
        this.unselectedTabHighlight = UIManager.getColor("TabbedPane.unselectedTabHighlight");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.unselectedTabBackground = null;
        this.unselectedTabForeground = null;
        this.unselectedTabShadow = null;
        this.unselectedTabHighlight = null;
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + 1, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 2, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + w - 1, y + 1, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(isSelected ? this.tabPane.getBackgroundAt(tabIndex) : this.unselectedTabBackground);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 2);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 1, h - 2);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 2, h - 3);
                g.drawLine(x + 2, y + h - 3, x + w - 3, y + h - 3);
                g.drawLine(x + 3, y + h - 2, x + w - 4, y + h - 2);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 3, w - 2, h - 3);
                g.drawLine(x + 2, y + 2, x + w - 3, y + 2);
                g.drawLine(x + 3, y + 1, x + w - 4, y + 1);
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(isSelected ? this.lightHighlight : this.unselectedTabHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 2);
                g.drawLine(x + 2, y, x + 2, y + 1);
                g.drawLine(x + 3, y, x + w - 1, y);
                g.setColor(isSelected ? this.shadow : this.unselectedTabShadow);
                g.drawLine(x + 1, y + h - 3, x + 1, y + h - 2);
                g.drawLine(x + 2, y + h - 2, x + 2, y + h - 1);
                g.drawLine(x + 3, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(isSelected ? this.shadow : this.unselectedTabShadow);
                g.drawLine(x + w - 3, y, x + w - 3, y + 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + h - 2);
                g.drawLine(x + w - 3, y + h - 2, x + w - 3, y + h - 1);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 3, x + 1, y + h - 2);
                g.drawLine(x + 2, y + h - 2, x + 2, y + h - 1);
                g.setColor(isSelected ? this.shadow : this.unselectedTabShadow);
                g.drawLine(x + 3, y + h - 1, x + w - 4, y + h - 1);
                g.drawLine(x + w - 3, y + h - 2, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                break;
            }
            default: {
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 2);
                g.drawLine(x + 2, y, x + 2, y + 1);
                g.drawLine(x + 3, y, x + w - 4, y);
                g.setColor(isSelected ? this.shadow : this.unselectedTabShadow);
                g.drawLine(x + w - 3, y, x + w - 3, y + 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this.tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this.focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6;
                    h = tabRect.height - 7;
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6;
                    h = tabRect.height - 7;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 7;
                    h = tabRect.height - 6;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 7;
                    h = tabRect.height - 6;
                }
            }
            g.drawRect(x, y, w, h);
        }
    }

    @Override
    protected int getTabRunIndent(int tabPlacement, int run) {
        return run * 3;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        this.tabRunOverlay = tabPlacement == 2 || tabPlacement == 4 ? (int)Math.round((double)this.maxTabWidth * 0.1) : (int)Math.round((double)this.maxTabHeight * 0.22);
        switch (tabPlacement) {
            case 2: {
                if (this.tabRunOverlay <= this.tabInsets.right - 2) break;
                this.tabRunOverlay = this.tabInsets.right - 2;
                break;
            }
            case 4: {
                if (this.tabRunOverlay <= this.tabInsets.left - 2) break;
                this.tabRunOverlay = this.tabInsets.left - 2;
                break;
            }
            case 1: {
                if (this.tabRunOverlay <= this.tabInsets.bottom - 2) break;
                this.tabRunOverlay = this.tabInsets.bottom - 2;
                break;
            }
            case 3: {
                if (this.tabRunOverlay <= this.tabInsets.top - 2) break;
                this.tabRunOverlay = this.tabInsets.top - 2;
            }
        }
        return this.tabRunOverlay;
    }
}

