/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.ExpressionVisitor;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.value.Value;

public abstract class Expression {
    private boolean addedToFilter;

    public abstract Value getValue(Session var1);

    public abstract int getType();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract Expression optimize(Session var1);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract int getScale();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public abstract String getSQL();

    public abstract void updateAggregate(Session var1);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public final boolean isEverything(int n) {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.get(n);
        return this.isEverything(expressionVisitor);
    }

    public Expression getNotIfPossible(Session session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public Boolean getBooleanValue(Session session) {
        return this.getValue(session).getBoolean();
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias() {
        return StringUtils.unEnclose(this.getSQL());
    }

    public boolean isWildcard() {
        return false;
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (!this.addedToFilter && !bl && this.isEverything(3)) {
            tableFilter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }

    public String toString() {
        return this.getSQL();
    }
}

