//
//  Diagonals2Game.m
//  Gridlock
//
//  Created by Brian on 10/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "Diagonals2Game.h"


@implementation Diagonals2Game

-(void)reset {
  [super reset];
  [self createGridFromConfiguration];
}

-(BOOL)appendMovesForPlayer:(int)pnum fromPosition:(id)startpos intoSet:(NSMutableSet *)moves {
  int r = [startpos row];
  int c = [startpos column];
  int dr,dc;
  BOOL found = NO;
  for(dr=-1; dr<=+1; dr+=2) {
    for(dc=-1; dc<=+1; dc+=2) {
      BOOL done = NO;
      int n=0;
      while (!done) {
        ++n;
        if (![self isValidRow:r+n*dr column:c+n*dc]) done = YES;
        else {
          int val = [self valueAtRow:r+n*dr column:c+n*dc];
          if (val==0 || (val>0 && val!=pnum)) {
            if (!moves) return YES;
            found = YES;
            [moves addObject:[[DCHypergridPosition positionWithRow:r+n*dr column:c+n*dc] arrayWithSelf_]];
          }
          if (val!=0) done = YES;
        }
      }
    }
  }
  return found;
}

-(NSArray *)allValidMoveSequences {
  NSMutableSet *moves = [NSMutableSet set];
  int pnum = [self currentPlayerNumber];
  NSEnumerator *pe = [[self grid] enumeratorForPositionsWithValue:pnum];
  id pos;
  while (pos=[pe nextObject]) {
    [self appendMovesForPlayer:pnum fromPosition:pos intoSet:moves];
  }
  // pass if no moves available
  if ([moves count]==0) [moves addObject:[NSArray array]];
  return [moves allObjects];
}

-(BOOL)isGameOver {
  // game over when neither player can move
  int pnum;
  for(pnum=1; pnum<=[self numberOfPlayers]; pnum++) {
    NSEnumerator *pe = [[self grid] enumeratorForPositionsWithValue:pnum];
    id pos;
    while (pos=[pe nextObject]) {
      if ([self appendMovesForPlayer:pnum fromPosition:pos intoSet:nil]) return NO;
    }
  }
  return YES;
}

-(BOOL)prepareMoveSequence:(NSArray *)positions {
  [self resetFutureGrid];
  if ([positions count]==0) return YES;
  // array should have a single position, which becomes owned by this player if empty, and a wall if owned by opponent
  int currentVal = [self valueAtPosition:[positions lastObject]];
  int nextVal = (currentVal==0) ? [self currentPlayerNumber] : -1;
  [[self futureGrid] setValue:nextVal atPosition:[positions lastObject]];
  return YES;
}

-(BOOL)showScores {
  return YES;
}

@end
