/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryAttributes;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;

public class UDPDiscoveryManager {
    private static final Log log = LogManager.getLog(UDPDiscoveryManager.class);
    private static UDPDiscoveryManager INSTANCE = new UDPDiscoveryManager();
    private final ConcurrentMap<String, UDPDiscoveryService> services = new ConcurrentHashMap<String, UDPDiscoveryService>();

    private UDPDiscoveryManager() {
    }

    public static UDPDiscoveryManager getInstance() {
        return INSTANCE;
    }

    public UDPDiscoveryService getService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr) {
        String key = discoveryAddress + ":" + discoveryPort + ":" + servicePort;
        UDPDiscoveryService service = this.services.computeIfAbsent(key, k -> {
            log.info("Creating service for address:port:servicePort [{0}]", key);
            UDPDiscoveryAttributes attributes = new UDPDiscoveryAttributes();
            attributes.setUdpDiscoveryAddr(discoveryAddress);
            attributes.setUdpDiscoveryPort(discoveryPort);
            attributes.setServicePort(servicePort);
            UDPDiscoveryService newService = new UDPDiscoveryService(attributes);
            cacheMgr.registerShutdownObserver(newService);
            if (cacheMgr instanceof IProvideScheduler) {
                newService.setScheduledExecutorService(((IProvideScheduler)((Object)cacheMgr)).getScheduledExecutorService());
            }
            newService.startup();
            return newService;
        });
        log.debug("Returning service [{0}] for key [{1}]", service, key);
        return service;
    }
}

