/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class AutoCompletionManager
implements DataSetListener {
    protected boolean dirty;
    protected DataSet ds;
    protected MultiMap<String, String> tagCache;
    static final MultiMap<String, String> PRESET_TAG_CACHE = new MultiMap();
    static final Set<UserInputTag> USER_INPUT_TAG_CACHE = new LinkedHashSet<UserInputTag>();
    protected Set<String> roleCache;
    static final Set<String> PRESET_ROLE_CACHE = new HashSet<String>();
    private static final Map<DataSet, AutoCompletionManager> INSTANCES = new HashMap<DataSet, AutoCompletionManager>();

    public AutoCompletionManager(DataSet ds) {
        this.ds = Objects.requireNonNull(ds);
        this.dirty = true;
    }

    protected MultiMap<String, String> getTagCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.tagCache;
    }

    protected Set<String> getRoleCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.roleCache;
    }

    protected void rebuild() {
        this.tagCache = new MultiMap();
        this.roleCache = new HashSet<String>();
        this.cachePrimitives(this.ds.allNonDeletedCompletePrimitives());
    }

    protected void cachePrimitives(Collection<? extends OsmPrimitive> primitives) {
        for (OsmPrimitive osmPrimitive : primitives) {
            this.cachePrimitiveTags(osmPrimitive);
            if (!(osmPrimitive instanceof Relation)) continue;
            this.cacheRelationMemberRoles((Relation)osmPrimitive);
        }
    }

    protected void cachePrimitiveTags(OsmPrimitive primitive) {
        primitive.visitKeys((p, key, value) -> this.tagCache.put(key, value));
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember m : relation.getMembers()) {
            if (!m.hasRole()) continue;
            this.roleCache.add(m.getRole());
        }
    }

    public static void rememberUserInput(String key, String value, boolean defaultKey) {
        UserInputTag tag = new UserInputTag(key, value, defaultKey);
        USER_INPUT_TAG_CACHE.remove(tag);
        USER_INPUT_TAG_CACHE.add(tag);
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.getTagCache().keySet());
    }

    protected Collection<String> getUserInputKeys() {
        List keys = USER_INPUT_TAG_CACHE.stream().filter(tag -> !((UserInputTag)tag).defaultKey).map(tag -> ((UserInputTag)tag).key).collect(Collectors.toList());
        Collections.reverse(keys);
        return new LinkedHashSet<String>(keys);
    }

    protected List<String> getDataValues(String key) {
        return new ArrayList<String>(this.getTagCache().getValues(key));
    }

    protected static Collection<String> getUserInputValues(String key) {
        List values = USER_INPUT_TAG_CACHE.stream().filter(tag -> Objects.equals(key, ((UserInputTag)tag).key)).map(tag -> ((UserInputTag)tag).value).collect(Collectors.toList());
        Collections.reverse(values);
        return new LinkedHashSet<String>(values);
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.getRoleCache());
    }

    public void populateWithMemberRoles(AutoCompletionList list) {
        list.add(TaggingPresets.getPresetRoles(), AutoCompletionPriority.IS_IN_STANDARD);
        list.add(this.getRoleCache(), AutoCompletionPriority.IS_IN_DATASET);
    }

    public void populateWithMemberRoles(AutoCompletionList list, Relation r) {
        Collection<TaggingPreset> presets;
        CheckParameterUtil.ensureParameterNotNull(list, "list");
        Collection<TaggingPreset> collection = presets = r != null ? TaggingPresets.getMatchingPresets(null, r.getKeys(), false) : null;
        if (r != null && presets != null && !presets.isEmpty()) {
            for (TaggingPreset tp : presets) {
                if (tp.roles == null) continue;
                list.add(Utils.transform(tp.roles.roles, x -> x.key), AutoCompletionPriority.IS_IN_STANDARD);
            }
            list.add(r.getMemberRoles(), AutoCompletionPriority.IS_IN_DATASET);
        } else {
            this.populateWithMemberRoles(list);
        }
    }

    public void populateWithKeys(AutoCompletionList list) {
        list.add(TaggingPresets.getPresetKeys(), AutoCompletionPriority.IS_IN_STANDARD);
        list.add(new AutoCompletionItem("source", AutoCompletionPriority.IS_IN_STANDARD));
        list.add(this.getDataKeys(), AutoCompletionPriority.IS_IN_DATASET);
        list.addUserInput(this.getUserInputKeys());
    }

    public void populateWithTagValues(AutoCompletionList list, String key) {
        this.populateWithTagValues(list, Arrays.asList(key));
    }

    public void populateWithTagValues(AutoCompletionList list, List<String> keys) {
        for (String key : keys) {
            list.add(TaggingPresets.getPresetValues(key), AutoCompletionPriority.IS_IN_STANDARD);
            list.add(this.getDataValues(key), AutoCompletionPriority.IS_IN_DATASET);
            list.addUserInput(AutoCompletionManager.getUserInputValues(key));
        }
    }

    private static List<AutoCompletionItem> setToList(AutoCompletionSet set, Comparator<AutoCompletionItem> comparator) {
        ArrayList<AutoCompletionItem> list = new ArrayList<AutoCompletionItem>(set);
        list.sort(comparator);
        return list;
    }

    public AutoCompletionSet getTagKeys() {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithKeys(list);
        return list.getSet();
    }

    public List<AutoCompletionItem> getTagKeys(Comparator<AutoCompletionItem> comparator) {
        return AutoCompletionManager.setToList(this.getTagKeys(), comparator);
    }

    public AutoCompletionSet getTagValues(String key) {
        return this.getTagValues(Arrays.asList(key));
    }

    public List<AutoCompletionItem> getTagValues(String key, Comparator<AutoCompletionItem> comparator) {
        return AutoCompletionManager.setToList(this.getTagValues(key), comparator);
    }

    public AutoCompletionSet getTagValues(List<String> keys) {
        AutoCompletionList list = new AutoCompletionList();
        this.populateWithTagValues(list, keys);
        return list.getSet();
    }

    public List<AutoCompletionItem> getTagValues(List<String> keys, Comparator<AutoCompletionItem> comparator) {
        return AutoCompletionManager.setToList(this.getTagValues(keys), comparator);
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        if (this.dirty) {
            return;
        }
        this.cachePrimitives(event.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.dirty = true;
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        if (this.dirty) {
            return;
        }
        TagMap newKeys = event.getPrimitive().getKeys();
        Map<String, String> oldKeys = event.getOriginalKeys();
        if (!newKeys.keySet().containsAll(oldKeys.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> oldEntry : oldKeys.entrySet()) {
                if (oldEntry.getValue().equals(newKeys.get(oldEntry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.cachePrimitives(Collections.singleton(event.getPrimitive()));
        }
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.dirty = true;
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.dirty = true;
    }

    private AutoCompletionManager registerListeners() {
        this.ds.addDataSetListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(new LayerManager.LayerChangeListener(){

            @Override
            public void layerRemoving(LayerManager.LayerRemoveEvent e) {
                if (e.getRemovedLayer() instanceof OsmDataLayer && ((OsmDataLayer)e.getRemovedLayer()).data == AutoCompletionManager.this.ds) {
                    INSTANCES.remove(AutoCompletionManager.this.ds);
                    AutoCompletionManager.this.ds.removeDataSetListener(AutoCompletionManager.this);
                    MainApplication.getLayerManager().removeLayerChangeListener(this);
                    AutoCompletionManager.this.dirty = true;
                    AutoCompletionManager.this.tagCache = null;
                    AutoCompletionManager.this.roleCache = null;
                    AutoCompletionManager.this.ds = null;
                }
            }

            @Override
            public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            }

            @Override
            public void layerAdded(LayerManager.LayerAddEvent e) {
            }
        });
        return this;
    }

    public static AutoCompletionManager of(DataSet dataSet) {
        return INSTANCES.computeIfAbsent(dataSet, ds -> new AutoCompletionManager((DataSet)ds).registerListeners());
    }

    public static class UserInputTag {
        private final String key;
        private final String value;
        private final boolean defaultKey;

        public UserInputTag(String key, String value, boolean defaultKey) {
            this.key = key;
            this.value = value;
            this.defaultKey = defaultKey;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.defaultKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UserInputTag other = (UserInputTag)obj;
            return this.defaultKey == other.defaultKey && Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }
    }
}

