/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerAsserts;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerRule;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleIndex;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    private MapCSSStyleIndex indexData;
    private final Map<MapCSSRule, MapCSSTagCheckerAndRule> ruleToCheckMap = new HashMap<MapCSSRule, MapCSSTagCheckerAndRule>();
    private static final Map<IPrimitive, Area> mpAreaCache = new HashMap<IPrimitive, Area>();
    private static final Set<IPrimitive> toMatchForSurrounding = new HashSet<IPrimitive>();
    static final boolean ALL_TESTS = true;
    static final boolean ONLY_SELECTED_TESTS = false;
    private static final CachingProperty<Boolean> PREF_OTHER = new BooleanProperty("validator.other", false).cached();
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final MultiMap<String, MapCSSTagCheckerRule> checks = new MultiMap();
    private final Map<String, String> urlTitles = new HashMap<String, String>();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    static MapCSSStyleIndex createMapCSSTagCheckerIndex(MultiMap<String, MapCSSTagCheckerRule> checks, boolean includeOtherSeverity, boolean allTests) {
        MapCSSStyleIndex index = new MapCSSStyleIndex();
        Stream<MapCSSRule> ruleStream = checks.values().stream().flatMap(Collection::stream).filter(c -> includeOtherSeverity || Severity.OTHER != c.getSeverity() || !c.setClassExpressions.isEmpty()).filter(c -> {
            if (allTests) return true;
            if (!c.rule.selectors.stream().anyMatch(Selector.ChildOrParentSelector.class::isInstance)) return false;
            return true;
        }).map(c -> c.rule);
        index.buildIndex(ruleStream);
        return index;
    }

    public synchronized Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity) {
        ArrayList<TestError> res = new ArrayList<TestError>();
        if (this.indexData == null) {
            this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(this.checks, includeOtherSeverity, true);
        }
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        env.mpAreaCache = mpAreaCache;
        env.toMatchForSurrounding = toMatchForSurrounding;
        Iterator<MapCSSRule> candidates = this.indexData.getRuleCandidates(p);
        while (candidates.hasNext()) {
            MapCSSRule r = candidates.next();
            for (Selector selector : r.selectors) {
                MapCSSTagCheckerAndRule test;
                MapCSSTagCheckerRule check;
                env.clearSelectorMatchingInformation();
                if (!selector.matches(env) || (check = (test = this.ruleToCheckMap.computeIfAbsent(r, rule -> this.checks.entrySet().stream().map(e -> ((Set)e.getValue()).stream().filter(c -> c.rule.declaration == rule.declaration).findFirst().map(c -> new MapCSSTagCheckerAndRule((MapCSSTagCheckerRule)c, this.getTitle((String)e.getKey()))).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null))) == null ? null : test.tagCheck) == null) continue;
                r.declaration.execute(env);
                if (check.errors.isEmpty()) continue;
                for (TestError e : check.getErrorsForPrimitive(p, selector, env, test)) {
                    MapCSSTagChecker.addIfNotSimilar(e, res);
                }
            }
        }
        return res;
    }

    private String getTitle(String url) {
        return this.urlTitles.getOrDefault(url, I18n.tr("unknown", new Object[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addIfNotSimilar(TestError toAdd, List<TestError> errors) {
        if (toAdd.getPrimitives().size() >= 2) {
            if (errors.stream().anyMatch(toAdd::isSimilar)) {
                return;
            }
        }
        boolean bl = false;
        boolean isDup = bl;
        if (isDup) return;
        errors.add(toAdd);
    }

    static Collection<TestError> getErrorsForPrimitive(OsmPrimitive p, boolean includeOtherSeverity, Collection<Set<MapCSSTagCheckerRule>> checksCol) {
        ArrayList<TestError> r = new ArrayList<TestError>();
        Environment env = new Environment(p, new MultiCascade(), "default", null);
        env.mpAreaCache = mpAreaCache;
        env.toMatchForSurrounding = toMatchForSurrounding;
        for (Set<MapCSSTagCheckerRule> schecks : checksCol) {
            for (MapCSSTagCheckerRule check : schecks) {
                Selector selector;
                boolean ignoreError;
                boolean bl = ignoreError = Severity.OTHER == check.getSeverity() && !includeOtherSeverity;
                if (ignoreError && check.setClassExpressions.isEmpty() || (selector = check.whichSelectorMatchesEnvironment(env)) == null) continue;
                check.rule.declaration.execute(env);
                if (ignoreError || check.errors.isEmpty()) continue;
                r.addAll(check.getErrorsForPrimitive(p, selector, env, new MapCSSTagCheckerAndRule(check.rule)));
            }
        }
        return r;
    }

    @Override
    public void check(OsmPrimitive p) {
        for (TestError e : this.getErrorsForPrimitive(p, PREF_OTHER.get())) {
            MapCSSTagChecker.addIfNotSimilar(e, this.errors);
        }
    }

    public synchronized ParseResult addMapCSS(String url) throws ParseException, IOException {
        boolean checkAssertions = Config.getPref().getBoolean("validator.check_assert_local_rules", false) && Utils.isLocalUrl(url);
        return this.addMapCSS(url, checkAssertions ? Logging::warn : null);
    }

    public synchronized ParseResult addMapCSS(String url, Consumer<String> assertionConsumer) throws ParseException, IOException {
        ParseResult result;
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        try (CachedFile cache = new CachedFile(url);
             InputStream zip = cache.findZipEntryInputStream("validator.mapcss", "");
             InputStream s = zip != null ? zip : cache.getInputStream();
             BufferedReader reader = new BufferedReader(UTFInputStreamReader.create(s));){
            if (zip != null) {
                I18n.addTexts(cache.getFile());
            }
            result = MapCSSTagCheckerRule.readMapCSS(reader, assertionConsumer);
            this.checks.remove(url);
            this.checks.putAll(url, result.parseChecks);
            this.urlTitles.put(url, MapCSSTagChecker.findURLTitle(url));
            this.indexData = null;
        }
        return result;
    }

    private static String findURLTitle(String url) {
        for (SourceEntry source : new ValidatorPrefHelper().get()) {
            if (!url.equals(source.url) || Utils.isEmpty(source.title)) continue;
            return source.title;
        }
        if (url.endsWith(".mapcss")) {
            url = new File(url).getName();
        }
        if (url.length() > 33) {
            url = "..." + url.substring(url.length() - 30);
        }
        return url;
    }

    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        this.urlTitles.clear();
        this.indexData = null;
        for (SourceEntry source : new ValidatorPrefHelper().get()) {
            if (!source.active) continue;
            String i = source.url;
            try {
                if (!i.startsWith("resource:")) {
                    Logging.info(I18n.tr("Adding {0} to tag checker", i));
                } else if (Logging.isDebugEnabled()) {
                    Logging.debug(I18n.tr("Adding {0} to tag checker", i));
                }
                this.addMapCSS(i);
                if (!Config.getPref().getBoolean("validator.auto_reload_local_rules", true) || !source.isLocal()) continue;
                FileWatcher.getDefaultInstance().registerSource(source);
            }
            catch (IOException | IllegalArgumentException | IllegalStateException ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.log(Logging.LEVEL_WARN, ex);
            }
            catch (ParseException | TokenMgrError ex) {
                Logging.warn(I18n.tr("Failed to add {0} to tag checker", i));
                Logging.warn(ex);
            }
        }
        MapCSSTagCheckerAsserts.clear();
    }

    public static void reloadRule(SourceEntry rule) {
        MapCSSTagChecker tagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
        if (tagChecker != null) {
            try {
                tagChecker.addMapCSS(rule.url);
            }
            catch (IOException | ParseException | TokenMgrError e) {
                Logging.warn(e);
            }
        }
    }

    @Override
    public synchronized void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        super.setShowElements(true);
    }

    @Override
    public synchronized void endTest() {
        this.indexData = null;
        mpAreaCache.clear();
        this.ruleToCheckMap.clear();
        toMatchForSurrounding.clear();
        super.endTest();
    }

    @Override
    public void visit(Collection<OsmPrimitive> selection) {
        this.visit(selection, null);
    }

    void visit(Collection<OsmPrimitive> selection, Predicate<String> urlPredicate) {
        if (urlPredicate == null && this.progressMonitor != null) {
            this.progressMonitor.setTicksCount(selection.size() * this.checks.size());
        }
        mpAreaCache.clear();
        toMatchForSurrounding.clear();
        HashSet<OsmPrimitive> surrounding = new HashSet<OsmPrimitive>();
        for (Map.Entry<String, Set<MapCSSTagCheckerRule>> entry : this.checks.entrySet()) {
            if (this.isCanceled()) break;
            if (urlPredicate != null && !urlPredicate.test(entry.getKey())) continue;
            this.visit(entry.getKey(), entry.getValue(), selection, surrounding);
        }
    }

    private void visit(String url, Set<MapCSSTagCheckerRule> checksForUrl, Collection<OsmPrimitive> selection, Set<OsmPrimitive> surrounding) {
        MultiMap<String, MapCSSTagCheckerRule> currentCheck = new MultiMap<String, MapCSSTagCheckerRule>();
        currentCheck.putAll(url, checksForUrl);
        this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(currentCheck, this.includeOtherSeverityChecks(), true);
        HashSet<OsmPrimitive> tested = new HashSet<OsmPrimitive>();
        String title = this.getTitle(url);
        if (this.progressMonitor != null) {
            this.progressMonitor.setExtraText(I18n.tr(" {0}", title));
        }
        long cnt = 0L;
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (OsmPrimitive p : selection) {
            if (this.isCanceled()) break;
            if (this.isPrimitiveUsable(p)) {
                this.check(p);
                if (this.partialSelection) {
                    tested.add(p);
                }
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.worked(1);
            if (++cnt % 10000L != 0L || stopwatch.elapsed() < 500L) continue;
            this.progressMonitor.setExtraText(I18n.tr(" {0}: {1} of {2} elements done", title, cnt, selection.size()));
        }
        if (this.partialSelection && !tested.isEmpty()) {
            this.testPartial(currentCheck, tested, surrounding);
        }
    }

    private void testPartial(MultiMap<String, MapCSSTagCheckerRule> currentCheck, Set<OsmPrimitive> tested, Set<OsmPrimitive> surrounding) {
        boolean includeOtherSeverity = this.includeOtherSeverityChecks();
        this.indexData = MapCSSTagChecker.createMapCSSTagCheckerIndex(currentCheck, includeOtherSeverity, false);
        if (this.indexData.isEmpty()) {
            return;
        }
        if (surrounding.isEmpty()) {
            for (OsmPrimitive p : tested) {
                if (p.getDataSet() == null) continue;
                surrounding.addAll(p.getDataSet().searchWays(p.getBBox()));
                surrounding.addAll(p.getDataSet().searchRelations(p.getBBox()));
            }
        }
        toMatchForSurrounding.clear();
        toMatchForSurrounding.addAll(tested);
        for (OsmPrimitive p : surrounding) {
            if (tested.contains(p)) continue;
            Collection<TestError> additionalErrors = this.getErrorsForPrimitive(p, includeOtherSeverity);
            for (TestError e : additionalErrors) {
                if (!e.getPrimitives().stream().anyMatch(tested::contains)) continue;
                MapCSSTagChecker.addIfNotSimilar(e, this.errors);
            }
        }
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final MapCSSRule rule;
        private final MapCSSTagCheckerRule tagCheck;
        private final String source;

        MapCSSTagCheckerAndRule(MapCSSRule rule) {
            this.rule = rule;
            this.tagCheck = null;
            this.source = "";
        }

        MapCSSTagCheckerAndRule(MapCSSTagCheckerRule tagCheck, String source) {
            this.rule = tagCheck.rule;
            this.tagCheck = tagCheck;
            this.source = source;
        }

        public String toString() {
            return "MapCSSTagCheckerAndRule [rule=" + this.rule + ']';
        }

        @Override
        public String getSource() {
            return this.source;
        }
    }

    public static class ParseResult {
        public final List<MapCSSTagCheckerRule> parseChecks;
        public final Collection<Throwable> parseErrors;

        public ParseResult(List<MapCSSTagCheckerRule> parseChecks, Collection<Throwable> parseErrors) {
            this.parseChecks = parseChecks;
            this.parseErrors = parseErrors;
        }
    }
}

