/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.CommandListMutableTreeNode;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class CommandStackDialog
extends ToggleDialog
implements UndoRedoHandler.CommandQueuePreciseListener {
    private final DefaultTreeModel undoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final DefaultTreeModel redoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree undoTree = new JTree(this.undoTreeModel);
    private final JTree redoTree = new JTree(this.redoTreeModel);
    private DefaultMutableTreeNode undoRoot;
    private DefaultMutableTreeNode redoRoot;
    private final transient UndoRedoSelectionListener undoSelectionListener;
    private final transient UndoRedoSelectionListener redoSelectionListener;
    private final JScrollPane scrollPane;
    private final JSeparator separator = new JSeparator();
    private final Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private UndoRedoType lastOperation = UndoRedoType.UNDO;
    private final SelectAction selectAction = new SelectAction();
    private final SelectAndZoomAction selectAndZoomAction = new SelectAndZoomAction();
    private final transient Set<IEnabledStateUpdating> showNotifyListener = new LinkedHashSet<IEnabledStateUpdating>();

    public CommandStackDialog() {
        super(I18n.tr("Command Stack", new Object[0]), "commandstack", I18n.tr("Open a list of all commands (undo buffer).", new Object[0]), Shortcut.registerShortcut("subwindow:commandstack", I18n.tr("Windows: {0}", I18n.tr("Command Stack", new Object[0])), 79, 5007), 100);
        this.undoTree.addMouseListener(new MouseEventHandler());
        this.undoTree.setRootVisible(false);
        this.undoTree.getSelectionModel().setSelectionMode(1);
        this.undoTree.setShowsRootHandles(true);
        this.undoTree.expandRow(0);
        this.undoTree.setCellRenderer(new CommandCellRenderer());
        this.undoSelectionListener = new UndoRedoSelectionListener(this.undoTree);
        this.undoTree.getSelectionModel().addTreeSelectionListener(this.undoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.undoTree, 0);
        this.redoTree.addMouseListener(new MouseEventHandler());
        this.redoTree.setRootVisible(false);
        this.redoTree.getSelectionModel().setSelectionMode(1);
        this.redoTree.setShowsRootHandles(true);
        this.redoTree.expandRow(0);
        this.redoTree.setCellRenderer(new CommandCellRenderer());
        this.redoSelectionListener = new UndoRedoSelectionListener(this.redoTree);
        this.redoTree.getSelectionModel().addTreeSelectionListener(this.redoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.redoTree, 0);
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        treesPanel.add((Component)this.undoTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        treesPanel.add((Component)this.separator, GBC.eol().fill(2));
        treesPanel.add((Component)this.redoTree, GBC.eol().fill(2));
        treesPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        treesPanel.setBackground(this.redoTree.getBackground());
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.undoTree);
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.redoTree);
        UndoRedoAction undoAction = new UndoRedoAction(UndoRedoType.UNDO);
        this.wireUpdateEnabledStateUpdater(undoAction, this.undoTree);
        UndoRedoAction redoAction = new UndoRedoAction(UndoRedoType.REDO);
        this.wireUpdateEnabledStateUpdater(redoAction, this.redoTree);
        this.scrollPane = (JScrollPane)this.createLayout(treesPanel, true, Arrays.asList(new SideButton(this.selectAction), new SideButton(undoAction), new SideButton(redoAction)));
        InputMapUtils.addEnterAction(this.undoTree, this.selectAndZoomAction);
        InputMapUtils.addEnterAction(this.redoTree, this.selectAndZoomAction);
    }

    private void updateTitle() {
        int undo = this.undoTreeModel.getChildCount(this.undoTreeModel.getRoot());
        int redo = this.redoTreeModel.getChildCount(this.redoTreeModel.getRoot());
        if (undo > 0 || redo > 0) {
            this.setTitle(I18n.tr("Command Stack: Undo: {0} / Redo: {1}", undo, redo));
        } else {
            this.setTitle(I18n.tr("Command Stack", new Object[0]));
        }
    }

    protected void wireUpdateEnabledStateUpdater(final IEnabledStateUpdating updater, JTree tree) {
        this.addShowNotifyListener(updater);
        tree.addTreeSelectionListener(e -> updater.updateEnabledState());
        tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                updater.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.treeNodesChanged(e);
            }
        });
    }

    @Override
    public void showNotify() {
        this.buildTrees();
        for (IEnabledStateUpdating listener : this.showNotifyListener) {
            listener.updateEnabledState();
        }
        UndoRedoHandler.getInstance().addCommandQueuePreciseListener(this);
    }

    private void addShowNotifyListener(IEnabledStateUpdating listener) {
        this.showNotifyListener.add(listener);
    }

    @Override
    public void hideNotify() {
        this.undoRoot = new DefaultMutableTreeNode();
        this.redoRoot = new DefaultMutableTreeNode();
        this.undoTreeModel.setRoot(this.undoRoot);
        this.redoTreeModel.setRoot(this.redoRoot);
        UndoRedoHandler.getInstance().removeCommandQueuePreciseListener(this);
    }

    private void buildTrees() {
        this.setTitle(I18n.tr("Command Stack", new Object[0]));
        this.buildUndoTree();
        this.buildRedoTree();
        this.ensureTreesConsistency();
    }

    private void buildUndoTree() {
        List<Command> undoCommands = UndoRedoHandler.getInstance().getUndoCommands();
        this.undoRoot = new DefaultMutableTreeNode();
        for (Command undoCommand : undoCommands) {
            this.undoRoot.add(this.getNodeForCommand(undoCommand));
        }
        this.undoTreeModel.setRoot(this.undoRoot);
    }

    private void buildRedoTree() {
        List<Command> redoCommands = UndoRedoHandler.getInstance().getRedoCommands();
        this.redoRoot = new DefaultMutableTreeNode();
        for (Command redoCommand : redoCommands) {
            this.redoRoot.add(this.getNodeForCommand(redoCommand));
        }
        this.redoTreeModel.setRoot(this.redoRoot);
    }

    private void ensureTreesConsistency() {
        List<Command> undoCommands = UndoRedoHandler.getInstance().getUndoCommands();
        List<Command> redoCommands = UndoRedoHandler.getInstance().getRedoCommands();
        if (this.redoTreeModel.getChildCount(this.redoRoot) > 0) {
            this.redoTree.scrollRowToVisible(0);
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
        this.separator.setVisible(!undoCommands.isEmpty() || !redoCommands.isEmpty());
        this.spacer.setVisible(undoCommands.isEmpty() && !redoCommands.isEmpty());
        switch (this.lastOperation) {
            case UNDO: {
                if (!undoCommands.isEmpty()) break;
                this.lastOperation = UndoRedoType.REDO;
                break;
            }
            case REDO: {
                if (!redoCommands.isEmpty()) break;
                this.lastOperation = UndoRedoType.UNDO;
            }
        }
        switch (this.lastOperation) {
            case UNDO: {
                this.undoTree.setSelectionRow(this.undoTree.getRowCount() - 1);
                break;
            }
            case REDO: {
                this.redoTree.setSelectionRow(0);
            }
        }
        this.undoTree.scrollRowToVisible(this.undoTreeModel.getChildCount(this.undoRoot) - 1);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    protected CommandListMutableTreeNode getNodeForCommand(PseudoCommand c) {
        CommandListMutableTreeNode node = new CommandListMutableTreeNode(c);
        if (c.getChildren() != null) {
            ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>(c.getChildren());
            for (PseudoCommand child : children) {
                node.add(this.getNodeForCommand(child));
            }
        }
        return node;
    }

    protected static Collection<? extends OsmPrimitive> getAffectedPrimitives(PseudoCommand c) {
        OsmDataLayer currentLayer = MainApplication.getLayerManager().getEditLayer();
        return new SubclassFilteredCollection(c.getParticipatingPrimitives(), o -> {
            OsmPrimitive p = currentLayer.data.getPrimitiveById((PrimitiveId)o);
            return p != null && p.isUsable();
        });
    }

    protected boolean redoTreeIsEmpty() {
        return this.redoTree.getRowCount() == 0;
    }

    @Override
    public void cleaned(UndoRedoHandler.CommandQueueCleanedEvent e) {
        if (this.isVisible()) {
            this.buildTrees();
        }
    }

    @Override
    public void commandAdded(UndoRedoHandler.CommandAddedEvent e) {
        if (this.isVisible()) {
            this.undoRoot.add(this.getNodeForCommand(e.getCommand()));
            this.undoTreeModel.nodeStructureChanged(this.undoRoot);
            if (!this.redoTreeIsEmpty()) {
                this.buildRedoTree();
            }
            this.ensureTreesConsistency();
        }
    }

    @Override
    public void commandUndone(UndoRedoHandler.CommandUndoneEvent e) {
        if (this.isVisible()) {
            this.swapNode(this.undoTreeModel, this.undoRoot, this.undoRoot.getChildCount() - 1, this.redoTreeModel, this.redoRoot, 0);
        }
    }

    @Override
    public void commandRedone(UndoRedoHandler.CommandRedoneEvent e) {
        if (this.isVisible()) {
            this.swapNode(this.redoTreeModel, this.redoRoot, 0, this.undoTreeModel, this.undoRoot, this.undoRoot.getChildCount());
        }
    }

    private void swapNode(DefaultTreeModel srcModel, DefaultMutableTreeNode srcRoot, int srcIndex, DefaultTreeModel dstModel, DefaultMutableTreeNode dstRoot, int dstIndex) {
        MutableTreeNode node = (MutableTreeNode)srcRoot.getChildAt(srcIndex);
        srcRoot.remove(node);
        srcModel.nodeStructureChanged(srcRoot);
        dstRoot.insert(node, dstIndex);
        dstModel.nodeStructureChanged(dstRoot);
        this.ensureTreesConsistency();
    }

    public PseudoCommand getSelectedCommand() {
        TreePath path;
        if (!this.undoTree.isSelectionEmpty()) {
            path = this.undoTree.getSelectionPath();
        } else if (!this.redoTree.isSelectionEmpty()) {
            path = this.redoTree.getSelectionPath();
        } else {
            return null;
        }
        return path != null ? ((CommandListMutableTreeNode)path.getLastPathComponent()).getCommand() : null;
    }

    public class SelectAction
    extends JosmAction
    implements IEnabledStateUpdating {
        public SelectAction() {
            this(I18n.tr("Select", new Object[0]), "dialogs/select", I18n.tr("Selects the objects that take part in this command (unless currently deleted)", new Object[0]), Shortcut.registerShortcut("command:stack:select", I18n.tr("Command Stack: Select", new Object[0]), 0, 5000), false, null, false);
        }

        protected SelectAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
            super(name, iconName, tooltip, shortcut, registerInToolbar, toolbarId, installAdapters);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PseudoCommand command = CommandStackDialog.this.getSelectedCommand();
            if (command == null) {
                return;
            }
            DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
            if (dataSet == null) {
                return;
            }
            dataSet.setSelected(CommandStackDialog.getAffectedPrimitives(command));
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!CommandStackDialog.this.undoTree.isSelectionEmpty() || !CommandStackDialog.this.redoTree.isSelectionEmpty());
        }
    }

    public class SelectAndZoomAction
    extends SelectAction {
        public SelectAndZoomAction() {
            super(I18n.tr("Select and zoom", new Object[0]), "dialogs/autoscale/selection", I18n.tr("Selects the objects that take part in this command (unless currently deleted), then and zooms to it", new Object[0]), Shortcut.registerShortcut("command:stack:select_and_zoom", I18n.tr("Command Stack: Select and zoom", new Object[0]), 0, 5000), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            AutoScaleAction.autoScale(AutoScaleAction.AutoScaleMode.SELECTION);
        }
    }

    protected static enum UndoRedoType {
        UNDO,
        REDO;

    }

    private class UndoRedoSelectionListener
    implements TreeSelectionListener {
        private final JTree source;

        UndoRedoSelectionListener(JTree source) {
            this.source = source;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.source == CommandStackDialog.this.undoTree) {
                CommandStackDialog.this.redoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
                CommandStackDialog.this.redoTree.clearSelection();
                CommandStackDialog.this.redoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
            }
            if (this.source == CommandStackDialog.this.redoTree) {
                CommandStackDialog.this.undoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
                CommandStackDialog.this.undoTree.clearSelection();
                CommandStackDialog.this.undoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
            }
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(new CommandStackPopup());
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (MouseEventHandler.isDoubleClick(evt)) {
                CommandStackDialog.this.selectAndZoomAction.actionPerformed(null);
            }
        }
    }

    private static class CommandCellRenderer
    extends DefaultTreeCellRenderer {
        private CommandCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode v = (DefaultMutableTreeNode)value;
            if (v.getUserObject() instanceof JLabel) {
                JLabel l = (JLabel)v.getUserObject();
                this.setIcon(l.getIcon());
                this.setText(l.getText());
            }
            return this;
        }
    }

    protected class UndoRedoAction
    extends JosmAction
    implements IEnabledStateUpdating {
        private final UndoRedoType type;
        private final JTree tree;

        public UndoRedoAction(UndoRedoType type) {
            super(UndoRedoType.UNDO == type ? I18n.tr("Undo", new Object[0]) : I18n.tr("Redo", new Object[0]), UndoRedoType.UNDO == type ? "undo" : "redo", UndoRedoType.UNDO == type ? I18n.tr("Undo the selected and all later commands", new Object[0]) : I18n.tr("Redo the selected and all earlier commands", new Object[0]), UndoRedoType.UNDO == type ? Shortcut.registerShortcut("command:stack:undo", I18n.tr("Command Stack: Undo", new Object[0]), 0, 5000) : Shortcut.registerShortcut("command:stack:redo", I18n.tr("Command Stack: Redo", new Object[0]), 0, 5000), false, false);
            this.type = type;
            this.tree = UndoRedoType.UNDO == type ? CommandStackDialog.this.undoTree : CommandStackDialog.this.redoTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandStackDialog.this.lastOperation = this.type;
            TreePath path = this.tree.getSelectionPath();
            if (path.getPathCount() != 2) {
                throw new IllegalStateException();
            }
            int idx = ((CommandListMutableTreeNode)path.getLastPathComponent()).getIndex();
            switch (this.type) {
                case UNDO: {
                    int numUndo = ((DefaultMutableTreeNode)CommandStackDialog.this.undoTreeModel.getRoot()).getChildCount() - idx;
                    UndoRedoHandler.getInstance().undo(numUndo);
                    break;
                }
                case REDO: {
                    int numRedo = idx + 1;
                    UndoRedoHandler.getInstance().redo(numRedo);
                }
            }
            MainApplication.getMap().repaint();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!this.tree.isSelectionEmpty() && this.tree.getSelectionPath().getPathCount() == 2);
        }
    }

    private class CommandStackPopup
    extends JPopupMenu {
        CommandStackPopup() {
            this.add(CommandStackDialog.this.selectAction);
            this.add(CommandStackDialog.this.selectAndZoomAction);
        }
    }
}

