/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.basic;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oauth.signpost.http.HttpRequest;

public class HttpURLConnectionRequestAdapter
implements HttpRequest {
    protected HttpURLConnection connection;

    public HttpURLConnectionRequestAdapter(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public String getRequestUrl() {
        return this.connection.getURL().toExternalForm();
    }

    @Override
    public void setRequestUrl(String url) {
    }

    @Override
    public void setHeader(String name, String value) {
        this.connection.setRequestProperty(name, value);
    }

    @Override
    public String getHeader(String name) {
        return this.connection.getRequestProperty(name);
    }

    @Override
    public Map<String, String> getAllHeaders() {
        Map<String, List<String>> origHeaders = this.connection.getRequestProperties();
        HashMap<String, String> headers = new HashMap<String, String>(origHeaders.size());
        for (String name : origHeaders.keySet()) {
            List<String> values = origHeaders.get(name);
            if (values.isEmpty()) continue;
            headers.put(name, values.get(0));
        }
        return headers;
    }

    @Override
    public InputStream getMessagePayload() throws IOException {
        return null;
    }

    @Override
    public String getContentType() {
        return this.connection.getRequestProperty("Content-Type");
    }

    @Override
    public HttpURLConnection unwrap() {
        return this.connection;
    }
}

