/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Bidi;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class Utils {
    public static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+", 256);
    private static final long MILLIS_OF_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final long MILLIS_OF_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long MILLIS_OF_HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long MILLIS_OF_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final int[][] EMPTY_INT_INT_ARRAY = new int[0][];
    public static final String URL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=%";
    private static final Pattern REMOVE_DIACRITICS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern PATTERN_LENGTH = Pattern.compile("^(-?\\d+(?:\\.\\d+)?)(cm|mi|mm|m|ft|km|nmi|in|'|\")?$");
    private static final Pattern PATTERN_LENGTH2 = Pattern.compile("^(-?)(\\d+(?:\\.\\d+)?)(ft|')(\\d+(?:\\.\\d+)?)(in|\")?$");
    private static final String DEFAULT_STRIP = "\ufeff\u200b";
    private static final String[] SIZE_UNITS = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    private static final double TO_DEGREES = 57.29577951308232;
    private static final double TO_RADIANS = Math.PI / 180;
    private static final double EPSILON = 1.0E-11;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Utils() {
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static <S, T extends S> SubclassFilteredCollection<S, T> filteredCollection(Collection<S> collection, Class<T> clazz) {
        CheckParameterUtil.ensureParameterNotNull(clazz, "clazz");
        return new SubclassFilteredCollection(collection, clazz::isInstance);
    }

    public static <T> int indexOf(Iterable<? extends T> collection, Predicate<? super T> predicate) {
        int i = 0;
        for (T item : collection) {
            if (predicate.test(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void ensure(boolean condition, String message, Object ... data) {
        if (!condition) {
            throw new AssertionError((Object)MessageFormat.format(message, data));
        }
    }

    public static int mod(int a, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be <= 0 but is " + n);
        }
        int res = a % n;
        if (res < 0) {
            res += n;
        }
        return res;
    }

    @Deprecated(since="15718", forRemoval=true)
    public static String join(String sep, Collection<?> values) {
        CheckParameterUtil.ensureParameterNotNull(sep, "sep");
        if (values == null) {
            return null;
        }
        return values.stream().map(v -> v != null ? v.toString() : "").collect(Collectors.joining(sep));
    }

    public static String joinAsHtmlUnorderedList(Iterable<?> values) {
        return StreamUtils.toStream(values).map(Object::toString).collect(StreamUtils.toHtmlList());
    }

    public static <T> T[] copyArray(T[] array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static char[] copyArray(char ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static int[] copyArray(int ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static byte[] copyArray(byte ... array) {
        if (array != null) {
            return Arrays.copyOf(array, array.length);
        }
        return array;
    }

    public static Path copyFile(File in, File out) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        return Files.copy(in.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectory(File in, File out) throws IOException {
        File[] files;
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        CheckParameterUtil.ensureParameterNotNull(out, "out");
        if (!out.exists() && !out.mkdirs()) {
            Logging.warn("Unable to create directory " + out.getPath());
        }
        if ((files = in.listFiles()) != null) {
            for (File f : files) {
                File target = new File(out, f.getName());
                if (f.isDirectory()) {
                    Utils.copyDirectory(f, target);
                    continue;
                }
                Utils.copyFile(f, target);
            }
        }
    }

    public static boolean deleteDirectory(File path) {
        File[] files;
        if (path.exists() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Utils.deleteDirectory(file);
                    continue;
                }
                Utils.deleteFile(file);
            }
        }
        return path.delete();
    }

    public static boolean deleteFileIfExists(File file) {
        return !file.exists() || Utils.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        return Utils.deleteFile(file, I18n.marktr("Unable to delete file {0}"));
    }

    public static boolean deleteFile(File file, String warnMsg) {
        boolean result = file.delete();
        if (!result) {
            Logging.warn(I18n.tr(warnMsg, file.getPath()));
        }
        return result;
    }

    public static boolean mkDirs(File dir) {
        return Utils.mkDirs(dir, I18n.marktr("Unable to create directory {0}"));
    }

    public static boolean mkDirs(File dir, String warnMsg) {
        boolean result = dir.mkdirs();
        if (!result) {
            Logging.warn(I18n.tr(warnMsg, dir.getPath()));
        }
        return result;
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            Logging.warn(e);
        }
    }

    public static void close(ZipFile zip) {
        Utils.close((Closeable)zip);
    }

    public static URL fileToURL(File f) {
        if (f != null) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                Logging.error("Unable to convert filename " + f.getAbsolutePath() + " to URL");
            }
        }
        return null;
    }

    public static URI urlToURI(String url) throws URISyntaxException, MalformedURLException {
        return Utils.urlToURI(new URL(url));
    }

    public static URI urlToURI(URL url) throws URISyntaxException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            Logging.trace(e);
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    public static boolean equalsEpsilon(double a, double b) {
        return Math.abs(a - b) <= 1.0E-11;
    }

    public static String md5Hex(String data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JosmRuntimeException(e);
        }
        byte[] byteData = data.getBytes(StandardCharsets.UTF_8);
        byte[] byteDigest = md.digest(byteData);
        return Utils.toHexString(byteDigest);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len == 0) {
            return "";
        }
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (byte v : bytes) {
            hexChars[j++] = HEX_ARRAY[(v & 0xF0) >> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static <T> List<T> topologicalSort(MultiMap<T, T> dependencies) {
        MultiMap deps = new MultiMap();
        for (T key2 : dependencies.keySet()) {
            deps.putVoid(key2);
            for (T val : dependencies.get(key2)) {
                deps.putVoid(val);
                deps.put(key2, val);
            }
        }
        int size = deps.size();
        ArrayList sorted = new ArrayList();
        for (int i = 0; i < size; ++i) {
            Object parentless = deps.keySet().stream().filter(key -> deps.get(key).isEmpty()).findFirst().orElse(null);
            if (parentless == null) {
                throw new JosmRuntimeException("parentless");
            }
            sorted.add(parentless);
            deps.remove(parentless);
            for (Object key3 : deps.keySet()) {
                deps.remove(key3, parentless);
            }
        }
        if (sorted.size() != size) {
            throw new JosmRuntimeException("Wrong size");
        }
        return sorted;
    }

    public static String escapeReservedCharactersHTML(String s) {
        return s == null ? "" : s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static <A, B> Collection<B> transform(final Collection<? extends A> c, final Function<A, B> f) {
        return new AbstractCollection<B>(){

            @Override
            public int size() {
                return c.size();
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> it;
                    {
                        this.it = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public B next() {
                        return f.apply(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <A, B> List<B> transform(final List<? extends A> l, final Function<A, B> f) {
        return new AbstractList<B>(){

            @Override
            public int size() {
                return l.size();
            }

            @Override
            public B get(int index) {
                return f.apply(l.get(index));
            }
        };
    }

    public static <T> List<T> toUnmodifiableList(Collection<T> collection) {
        if (Utils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        if (collection.size() == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Arrays.asList(collection.toArray());
    }

    public static <K, V> Map<K, V> toUnmodifiableMap(Map<K, V> map) {
        if (Utils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(MultiMap<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Deprecated(since="19080", forRemoval=true)
    public static boolean isBlank(String string) {
        return Utils.isStripEmpty(string);
    }

    public static String firstNotEmptyString(String defaultString, String ... candidates) {
        return Arrays.stream(candidates).filter(Predicate.not(Utils::isStripEmpty)).findFirst().orElse(defaultString);
    }

    public static boolean isStripEmpty(String str) {
        if (str != null && !str.isBlank()) {
            for (int i = 0; i < str.length(); ++i) {
                if (Utils.isStrippedChar(str.charAt(i), null)) continue;
                return false;
            }
        }
        return true;
    }

    public static String strip(String str) {
        return Utils.strip(str, DEFAULT_STRIP);
    }

    public static String strip(String str, String skipChars) {
        if (Utils.isEmpty(str)) {
            return str;
        }
        int start = 0;
        int end = str.length();
        boolean leadingSkipChar = true;
        while (leadingSkipChar && start < end) {
            leadingSkipChar = Utils.isStrippedChar(str.charAt(start), skipChars);
            if (!leadingSkipChar) continue;
            ++start;
        }
        boolean trailingSkipChar = true;
        while (trailingSkipChar && end > start) {
            trailingSkipChar = Utils.isStrippedChar(str.charAt(end - 1), skipChars);
            if (!trailingSkipChar) continue;
            --end;
        }
        return str.substring(start, end);
    }

    private static boolean isStrippedChar(char c, String skipChars) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || DEFAULT_STRIP.indexOf(c) >= 0 || skipChars != null && skipChars.indexOf(c) >= 0;
    }

    public static String removeWhiteSpaces(String s) {
        if (Utils.isEmpty(s)) {
            return s;
        }
        return Utils.strip(s).replaceAll("\\s+", " ");
    }

    public static String execOutput(List<String> command) throws IOException, ExecutionException, InterruptedException {
        return Utils.execOutput(command, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execOutput(List<String> command, long timeout, TimeUnit unit) throws IOException, ExecutionException, InterruptedException {
        if (Logging.isDebugEnabled()) {
            Logging.debug(String.join((CharSequence)" ", command));
        }
        Path out = Files.createTempFile("josm_exec_" + command.get(0) + "_", ".txt", new FileAttribute[0]);
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).redirectOutput(out.toFile()).start();
            if (!p.waitFor(timeout, unit) || p.exitValue() != 0) {
                throw new ExecutionException(command.toString(), null);
            }
            String string = String.join((CharSequence)"\n", Files.readAllLines(out)).trim();
            return string;
        }
        finally {
            try {
                Files.delete(out);
            }
            catch (IOException e) {
                Logging.warn(e);
            }
        }
    }

    public static File getJosmTempDir() {
        String tmpDir = Utils.getSystemProperty("java.io.tmpdir");
        if (tmpDir == null) {
            return null;
        }
        File josmTmpDir = new File(tmpDir, "JOSM");
        if (!josmTmpDir.exists() && !josmTmpDir.mkdirs()) {
            Logging.warn("Unable to create temp directory " + String.valueOf(josmTmpDir));
        }
        return josmTmpDir;
    }

    public static String getDurationString(long elapsedTime) {
        if (elapsedTime < 0L) {
            throw new IllegalArgumentException("elapsedTime must be >= 0");
        }
        if (elapsedTime < MILLIS_OF_SECOND) {
            return String.format("%d %s", elapsedTime, I18n.tr("ms", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_MINUTE) {
            return String.format("%.1f %s", (double)elapsedTime / (double)MILLIS_OF_SECOND, I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_HOUR) {
            long min = elapsedTime / MILLIS_OF_MINUTE;
            return String.format("%d %s %d %s", min, I18n.tr("min", new Object[0]), (elapsedTime - min * MILLIS_OF_MINUTE) / MILLIS_OF_SECOND, I18n.tr("s", new Object[0]));
        }
        if (elapsedTime < MILLIS_OF_DAY) {
            long hour = elapsedTime / MILLIS_OF_HOUR;
            return String.format("%d %s %d %s", hour, I18n.tr("h", new Object[0]), (elapsedTime - hour * MILLIS_OF_HOUR) / MILLIS_OF_MINUTE, I18n.tr("min", new Object[0]));
        }
        long days = elapsedTime / MILLIS_OF_DAY;
        return String.format("%d %s %d %s", days, I18n.trn("day", "days", days, new Object[0]), (elapsedTime - days * MILLIS_OF_DAY) / MILLIS_OF_HOUR, I18n.tr("h", new Object[0]));
    }

    public static String getSizeString(long bytes, Locale locale) {
        double value;
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes must be >= 0");
        }
        int unitIndex = 0;
        for (value = (double)bytes; value >= 1024.0 && unitIndex < SIZE_UNITS.length; value /= 1024.0, ++unitIndex) {
        }
        if (value > 100.0 || unitIndex == 0) {
            return String.format(locale, "%.0f %s", value, SIZE_UNITS[unitIndex]);
        }
        if (value > 10.0) {
            return String.format(locale, "%.1f %s", value, SIZE_UNITS[unitIndex]);
        }
        return String.format(locale, "%.2f %s", value, SIZE_UNITS[unitIndex]);
    }

    public static String getPositionListString(List<Integer> positionList) {
        Collections.sort(positionList);
        StringBuilder sb = new StringBuilder(32);
        sb.append(positionList.get(0));
        int cnt = 0;
        int last = positionList.get(0);
        for (int i = 1; i < positionList.size(); ++i) {
            int cur = positionList.get(i);
            if (cur == last + 1) {
                ++cnt;
            } else if (cnt == 0) {
                sb.append(',').append(cur);
            } else {
                sb.append('-').append(last).append(',').append(cur);
                cnt = 0;
            }
            last = cur;
        }
        if (cnt >= 1) {
            sb.append('-').append(last);
        }
        return sb.toString();
    }

    public static List<String> getMatches(Matcher m) {
        if (m.matches()) {
            return IntStream.rangeClosed(0, m.groupCount()).mapToObj(m::group).collect(Collectors.toList());
        }
        return null;
    }

    public static <T> T cast(Object o, Class<T> klass) {
        if (klass.isInstance(o)) {
            return klass.cast(o);
        }
        return null;
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        if (result != null) {
            Throwable cause = result.getCause();
            while (cause != null && !cause.equals(result)) {
                result = cause;
                cause = result.getCause();
            }
        }
        return result;
    }

    public static <T> T[] addInArrayCopy(T[] array, T item) {
        T[] biggerCopy = Arrays.copyOf(array, array.length + 1);
        biggerCopy[array.length] = item;
        return biggerCopy;
    }

    public static String shortenString(String s, int maxLength) {
        String ellipses = "...";
        CheckParameterUtil.ensureThat(maxLength >= "...".length(), "maxLength is shorter than " + "...".length());
        if (s != null && s.length() > maxLength) {
            return s.substring(0, maxLength - "...".length()) + "...";
        }
        return s;
    }

    public static String restrictStringLines(String s, int maxLines) {
        if (s == null) {
            return null;
        }
        return String.join((CharSequence)"\n", Utils.limit(Arrays.asList(s.split("\\n", -1)), maxLines, "..."));
    }

    public static <T> Collection<T> limit(Collection<T> elements, int maxElements, T overflowIndicator) {
        if (elements == null) {
            return null;
        }
        if (elements.size() > maxElements) {
            ArrayList<T> r = new ArrayList<T>(maxElements);
            Iterator<T> it = elements.iterator();
            while (r.size() < maxElements - 1) {
                r.add(it.next());
            }
            r.add(overflowIndicator);
            return r;
        }
        return elements;
    }

    public static String fixURLQuery(String url) {
        if (url == null || url.indexOf(63) == -1) {
            return url;
        }
        String query = url.substring(url.indexOf(63) + 1);
        StringBuilder sb = new StringBuilder(url.substring(0, url.indexOf(63) + 1));
        for (int i = 0; i < query.length(); ++i) {
            String c = query.substring(i, i + 1);
            if (URL_CHARS.contains(c)) {
                sb.append(c);
                continue;
            }
            sb.append(Utils.encodeUrl(c));
        }
        return sb.toString();
    }

    public static String encodeUrl(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    public static String decodeUrl(String s) {
        return URLDecoder.decode(s, StandardCharsets.UTF_8);
    }

    public static boolean isLocalUrl(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://") && !url.startsWith("resource://");
    }

    public static boolean isValidUrl(String url) {
        if (url != null) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException e) {
                Logging.trace(e);
            }
        }
        return false;
    }

    public static ThreadFactory newThreadFactory(final String nameFormat, final int threadPriority) {
        return new ThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, String.format(Locale.ENGLISH, nameFormat, this.count.getAndIncrement()));
                thread.setPriority(threadPriority);
                return thread;
            }
        };
    }

    public static int getLevenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char si = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char tj = t.charAt(j - 1);
                int cost = si == tj ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static boolean isSimilar(String string1, String string2) {
        int distance = Utils.getLevenshteinDistance(string1, string2);
        if (distance > 2 && string1.length() == string2.length()) {
            return Utils.deAccent(string1).equalsIgnoreCase(Utils.deAccent(string2));
        }
        return distance > 0 && distance <= 2;
    }

    public static double getStandardDeviation(double[] values) {
        return Utils.getStandardDeviation(values, Double.NaN);
    }

    public static double getStandardDeviation(double[] values, double mean) {
        if (values.length < 2) {
            return -1.0;
        }
        double standardDeviation = 0.0;
        if (Double.isNaN(mean)) {
            mean = Arrays.stream(values).average().orElse(0.0);
        }
        for (double length : values) {
            standardDeviation += Math.pow(length - mean, 2.0);
        }
        return Math.sqrt(standardDeviation / (double)values.length);
    }

    public static int[][] groupIntegers(int ... integers) {
        if (integers.length == 0) {
            return EMPTY_INT_INT_ARRAY;
        }
        ArrayList<int[]> groups = new ArrayList<int[]>();
        int[] current = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        groups.add(current);
        for (int row : integers) {
            if (current[0] == Integer.MIN_VALUE) {
                current[0] = row;
                current[1] = row;
                continue;
            }
            if (current[1] == row - 1) {
                current[1] = row;
                continue;
            }
            current = new int[]{row, row};
            groups.add(current);
        }
        return (int[][])groups.toArray((T[])EMPTY_INT_INT_ARRAY);
    }

    public static ForkJoinPool newForkJoinPool(String pref, final String nameFormat, final int threadPriority) {
        int noThreads = Config.getPref().getInt(pref, Runtime.getRuntime().availableProcessors());
        return new ForkJoinPool(noThreads, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicLong count = new AtomicLong(0L);

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                JosmForkJoinWorkerThread thread = new JosmForkJoinWorkerThread(pool);
                thread.setName(String.format(Locale.ENGLISH, nameFormat, this.count.getAndIncrement()));
                thread.setPriority(threadPriority);
                return thread;
            }
        }, null, true);
    }

    public static Executor newDirectExecutor() {
        return Runnable::run;
    }

    public static String getSystemEnv(String name) {
        try {
            return System.getenv(name);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get system env", e);
            return null;
        }
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get system property", e);
            return null;
        }
    }

    public static String updateSystemProperty(String key, String value) {
        if (value != null) {
            try {
                String old = System.setProperty(key, value);
                if (Logging.isDebugEnabled() && !value.equals(old)) {
                    if (!key.toLowerCase(Locale.ENGLISH).contains("password")) {
                        Logging.debug("System property '" + key + "' set to '" + value + "'. Old value was '" + old + "'");
                    } else {
                        Logging.debug("System property '" + key + "' changed.");
                    }
                }
                return old;
            }
            catch (SecurityException e) {
                System.err.println("Unable to update system property: " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean hasExtension(String filename, String ... extensions) {
        String name = filename.toLowerCase(Locale.ENGLISH).replace("?format=raw", "");
        return Arrays.stream(extensions).anyMatch(ext -> name.endsWith("." + ext.toLowerCase(Locale.ENGLISH)));
    }

    public static boolean hasExtension(File file, String ... extensions) {
        return Utils.hasExtension(file.getName(), extensions);
    }

    @Deprecated(since="19050", forRemoval=true)
    public static byte[] readBytesFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            return new byte[0];
        }
        return stream.readAllBytes();
    }

    public static int hashMapInitialCapacity(int nEntries, double loadFactor) {
        return (int)Math.ceil((double)nEntries / loadFactor);
    }

    public static int hashMapInitialCapacity(int nEntries) {
        return Utils.hashMapInitialCapacity(nEntries, 0.75);
    }

    public static List<GlyphVector> getGlyphVectorsBidi(String string, Font font, FontRenderContext frc) {
        ArrayList<GlyphVector> gvs = new ArrayList<GlyphVector>();
        Bidi bidi = new Bidi(string, -2);
        byte[] levels = new byte[bidi.getRunCount()];
        Object[] dirStrings = new DirectionString[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
            String substr = string.substring(bidi.getRunStart(i), bidi.getRunLimit(i));
            int dir = levels[i] % 2 == 0 ? 0 : 1;
            dirStrings[i] = new DirectionString(dir, substr);
        }
        Bidi.reorderVisually(levels, 0, dirStrings, 0, levels.length);
        for (Object dirString : dirStrings) {
            char[] chars = ((DirectionString)dirString).str.toCharArray();
            gvs.add(font.layoutGlyphVector(frc, chars, 0, chars.length, ((DirectionString)dirString).direction));
        }
        return gvs;
    }

    public static String deAccent(String str) {
        return REMOVE_DIACRITICS.matcher(Normalizer.normalize(str, Normalizer.Form.NFD)).replaceAll("");
    }

    public static double clamp(double val, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter min ({0}) cannot be greater than max ({1})", min, max));
        }
        if (val < min) {
            return min;
        }
        return Math.min(val, max);
    }

    public static int clamp(int val, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter min ({0}) cannot be greater than max ({1})", min, max));
        }
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double toDegrees(double angleRad) {
        return angleRad * 57.29577951308232;
    }

    public static double toRadians(double angleDeg) {
        return angleDeg * (Math.PI / 180);
    }

    public static int getJavaVersion() {
        String version = Objects.requireNonNull(Utils.getSystemProperty("java.version"));
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : version.length())));
    }

    public static int getJavaUpdate() {
        int secondDotPos;
        String version = Objects.requireNonNull(Utils.getSystemProperty("java.version"));
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int undePos = version.indexOf(95);
        int dashPos = version.indexOf(45);
        if (undePos > -1) {
            return Integer.parseInt(version.substring(undePos + 1, dashPos > -1 ? dashPos : version.length()));
        }
        int firstDotPos = version.indexOf(46);
        if (firstDotPos == (secondDotPos = version.indexOf(46, firstDotPos + 1))) {
            return 0;
        }
        return firstDotPos > -1 ? Integer.parseInt(version.substring(firstDotPos + 1, secondDotPos > -1 ? secondDotPos : version.length())) : 0;
    }

    public static int getJavaBuild() {
        String version = Objects.requireNonNull(Utils.getSystemProperty("java.runtime.version"));
        int bPos = version.indexOf(98);
        int pPos = version.indexOf(43);
        try {
            return Integer.parseInt(version.substring(bPos > -1 ? bPos + 1 : pPos + 1));
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return 0;
        }
    }

    public static Date getJavaExpirationDate() {
        try {
            Object value;
            Class<?> c = Class.forName("com.sun.deploy.config.BuiltInProperties");
            try {
                value = c.getDeclaredField("JRE_EXPIRATION_DATE").get(null);
            }
            catch (NoSuchFieldException e) {
                Logging.trace(e);
                value = c.getDeclaredMethod("getProperty", String.class).invoke(null, "JRE_EXPIRATION_DATE");
            }
            if (value instanceof String) {
                return DateFormat.getDateInstance(3, Locale.US).parse((String)value);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | ParseException e) {
            Logging.debug(e);
        }
        return null;
    }

    public static String getJavaLatestVersion() {
        try {
            String[] versions = HttpClient.create(new URL(Config.getPref().get("java.baseline.version.url", Config.getUrls().getJOSMWebsite() + "/remote/oracle-java-update-baseline.version"))).connect().fetchContent().split("\n", -1);
            if (Utils.getJavaVersion() <= 21) {
                for (String version : versions) {
                    if (!version.startsWith("21")) continue;
                    return version;
                }
            }
            return versions[0];
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static boolean isClassFound(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isRunningWebStart() {
        return Utils.isClassFound("javax.jnlp.ServiceManager");
    }

    @Deprecated(since="19101", forRemoval=true)
    public static boolean isRunningJavaWebStart() {
        return Utils.isRunningWebStart() && Utils.isClassFound("com.sun.javaws.Main");
    }

    public static boolean isRunningOpenWebStart() {
        return Utils.isRunningWebStart() && Utils.isClassFound("net.adoptopenjdk.icedteaweb.client.commandline.CommandLine");
    }

    public static <T, U> Function<T, Stream<U>> castToStream(Class<U> klass) {
        return x -> klass.isInstance(x) ? Stream.of(klass.cast(x)) : null;
    }

    public static <T> void instanceOfThen(Object o, Class<T> klass, Consumer<? super T> consumer) {
        if (klass.isInstance(o)) {
            consumer.accept(klass.cast(o));
        }
    }

    public static <T> Optional<T> instanceOfAndCast(Object o, Class<T> klass) {
        if (klass.isInstance(o)) {
            return Optional.of(klass.cast(o));
        }
        return Optional.empty();
    }

    public static InputStream openStream(URL url) throws IOException {
        switch (url.getProtocol()) {
            case "http": 
            case "https": {
                return HttpClient.create(url).connect().getContent();
            }
            case "jar": {
                try {
                    return url.openStream();
                }
                catch (FileNotFoundException | InvalidPathException e) {
                    URL betterUrl = Utils.betterJarUrl(url);
                    if (betterUrl != null) {
                        try {
                            return betterUrl.openStream();
                        }
                        catch (IOException | RuntimeException ex) {
                            Logging.warn(ex);
                        }
                    }
                    throw e;
                }
            }
        }
        return url.openStream();
    }

    public static URL betterJarUrl(URL jarUrl) throws IOException {
        return Utils.betterJarUrl(jarUrl, null);
    }

    public static URL betterJarUrl(URL jarUrl, URL defaultUrl) throws IOException {
        String urlPath = jarUrl.getPath().replace("%20", " ");
        if (urlPath.startsWith("file:/") && urlPath.split("!", -1).length > 2) {
            int index = urlPath.lastIndexOf("!/");
            Path jarFile = Paths.get(urlPath.substring("file:/".length(), index), new String[0]);
            Path filename = jarFile.getFileName();
            FileTime jarTime = Files.readAttributes(jarFile, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
            Path jarCopy = Paths.get(Utils.getSystemProperty("java.io.tmpdir"), new String[0]).resolve(filename);
            if (!jarCopy.toFile().exists() || Files.readAttributes(jarCopy, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().compareTo(jarTime) < 0) {
                Files.copy(jarFile, jarCopy, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            return new URL(jarUrl.getProtocol() + ":" + jarCopy.toUri().toURL().toExternalForm() + urlPath.substring(index));
        }
        return defaultUrl;
    }

    public static InputStream getResourceAsStream(Class<?> klass, String path) {
        return Utils.getResourceAsStream(klass.getClassLoader(), path);
    }

    public static InputStream getResourceAsStream(ClassLoader cl, String path) {
        try {
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            return cl.getResourceAsStream(path);
        }
        catch (InvalidPathException e) {
            Logging.error("Cannot open {0}: {1}", path, e.getMessage());
            Logging.trace(e);
            try {
                URL betterUrl = Utils.betterJarUrl(cl.getResource(path));
                if (betterUrl != null) {
                    return betterUrl.openStream();
                }
            }
            catch (IOException ex) {
                Logging.error(ex);
            }
            return null;
        }
    }

    public static String stripHtml(String rawString) {
        rawString = rawString.replaceAll("<[^>]+>", " ");
        rawString = rawString.replaceAll("(?U)\\b\\s{2,}\\b", " ");
        return rawString.trim();
    }

    public static String intern(String string) {
        return string == null ? null : string.intern();
    }

    public static Double unitToMeter(String s) throws IllegalArgumentException {
        Matcher m = PATTERN_LENGTH.matcher(s = s.replace(" ", "").replace(",", "."));
        if (m.matches()) {
            return Double.parseDouble(m.group(1)) * Utils.unitToMeterConversion(m.group(2));
        }
        m = PATTERN_LENGTH2.matcher(s);
        if (m.matches()) {
            return (Double.parseDouble(m.group(2)) * 0.3048 + Double.parseDouble(m.group(4)) * 0.0254) * (m.group(1).isEmpty() ? 1.0 : -1.0);
        }
        throw new IllegalArgumentException("Invalid length value: " + s);
    }

    private static double unitToMeterConversion(String unit) throws IllegalArgumentException {
        if (unit == null) {
            return 1.0;
        }
        switch (unit) {
            case "cm": {
                return 0.01;
            }
            case "mm": {
                return 0.001;
            }
            case "m": {
                return 1.0;
            }
            case "km": {
                return 1000.0;
            }
            case "nmi": {
                return 1852.0;
            }
            case "mi": {
                return 1609.344;
            }
            case "ft": 
            case "'": {
                return 0.3048;
            }
            case "in": 
            case "\"": {
                return 0.0254;
            }
        }
        throw new IllegalArgumentException("Invalid length unit: " + unit);
    }

    private static class DirectionString {
        public final int direction;
        public final String str;

        DirectionString(int direction, String str) {
            this.direction = direction;
            this.str = str;
        }
    }

    static final class JosmForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        JosmForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

