/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.audio.AudioUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class ImportAudioAction
extends AbstractAction {
    private final transient GpxLayer layer;

    public ImportAudioAction(GpxLayer layer) {
        super(I18n.tr("Import Audio", new Object[0]));
        new ImageProvider("importaudio").getResource().attachImageIcon(this, true);
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ImportAudio"));
    }

    private static void warnCantImportIntoServerLayer(GpxLayer layer) {
        String msg = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", Utils.escapeReservedCharactersHTML(layer.getName()));
        HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportAudio#CantImportIntoGpxLayerFromServer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.layer.data.fromServer) {
            ImportAudioAction.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, true, null, new AudioFileFilter(), 0, "markers.lastaudiodirectory");
        if (fc != null) {
            File[] sel = fc.getSelectedFiles();
            String names = Arrays.stream(sel).sorted(Comparator.comparingLong(File::lastModified)).map(File::getName).collect(Collectors.joining(", ", " (", ")"));
            MarkerLayer ml = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", this.layer.getName()) + names, this.layer.getAssociatedFile(), this.layer);
            double firstStartTime = (double)sel[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(sel[0]);
            Markers m = new Markers();
            for (File file : sel) {
                this.importAudio(file, ml, firstStartTime, m);
            }
            MainApplication.getLayerManager().addLayer(ml);
            MainApplication.getMap().repaint();
        }
    }

    private void importAudio(File audioFile, MarkerLayer ml, double firstStartTime, Markers markers) {
        URL url = Utils.fileToURL(audioFile);
        boolean hasTracks = !Utils.isEmpty(this.layer.data.tracks);
        boolean hasWaypoints = !Utils.isEmpty(this.layer.data.waypoints);
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        boolean timedMarkersOmitted = false;
        boolean untimedMarkersOmitted = false;
        double snapDistance = Config.getPref().getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPointFromTimeStamp = null;
        double firstTime = -1.0;
        if (hasTracks) {
            for (IGpxTrack iGpxTrack : this.layer.data.tracks) {
                for (IGpxTrackSegment seg : iGpxTrack.getSegments()) {
                    Iterator<WayPoint> iterator = seg.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        WayPoint w = iterator.next();
                        firstTime = w.getTime();
                    }
                    if (!(firstTime >= 0.0)) continue;
                    break;
                }
                if (!(firstTime >= 0.0)) continue;
                break;
            }
        }
        if (firstTime < 0.0) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("No GPX track available in layer to associate audio with.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        if (hasWaypoints && Config.getPref().getBoolean("marker.audiofromexplicitwaypoints", true)) {
            for (WayPoint wayPoint : this.layer.data.waypoints) {
                if (wayPoint.getTime() > firstTime) {
                    waypoints.add(wayPoint);
                    continue;
                }
                if (!(wayPoint.getTime() > 0.0)) continue;
                timedMarkersOmitted = true;
            }
        }
        if (hasWaypoints && Config.getPref().getBoolean("marker.audiofromuntimedwaypoints", true)) {
            for (WayPoint wayPoint : this.layer.data.waypoints) {
                if (waypoints.contains(wayPoint)) continue;
                WayPoint wNear = this.layer.data.nearestPointOnTrack(wayPoint.getEastNorth(ProjectionRegistry.getProjection()), snapDistance);
                if (wNear != null) {
                    WayPoint wc = new WayPoint(wayPoint.getCoor());
                    wc.setTimeInMillis(wNear.getTimeInMillis());
                    if (wayPoint.attr.containsKey("name")) {
                        wc.put("name", wayPoint.getString("name"));
                    }
                    waypoints.add(wc);
                    continue;
                }
                untimedMarkersOmitted = true;
            }
        }
        if (this.layer.data.tracks != null && Config.getPref().getBoolean("marker.audiofromnamedtrackpoints", false) && !this.layer.data.tracks.isEmpty()) {
            for (IGpxTrack iGpxTrack : this.layer.data.tracks) {
                for (IGpxTrackSegment seg : iGpxTrack.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (!w.attr.containsKey("name") && !w.attr.containsKey("desc")) continue;
                        waypoints.add(w);
                    }
                }
            }
        }
        if (hasTracks && Config.getPref().getBoolean("marker.audiofromwavtimestamps", false)) {
            double lastModified = (double)audioFile.lastModified() / 1000.0;
            double duration = AudioUtil.getCalibratedDuration(audioFile);
            double startTime = lastModified - duration;
            startTime = firstStartTime + (startTime - firstStartTime) / Config.getPref().getDouble("audio.calibration", 1.0);
            WayPoint w1 = null;
            WayPoint w2 = null;
            block7: for (IGpxTrack track : this.layer.data.tracks) {
                for (IGpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (startTime < w.getTime()) {
                            w2 = w;
                            break;
                        }
                        w1 = w;
                    }
                    if (w2 == null) continue;
                    continue block7;
                }
            }
            if (w1 == null || w2 == null) {
                timedMarkersOmitted = true;
            } else {
                wayPointFromTimeStamp = new WayPoint(w1.getCoor().interpolate(w2.getCoor(), (startTime - w1.getTime()) / (w2.getTime() - w1.getTime())));
                wayPointFromTimeStamp.setTimeInMillis((long)(startTime * 1000.0));
                String name = audioFile.getName();
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                wayPointFromTimeStamp.put("name", name);
                waypoints.add(wayPointFromTimeStamp);
            }
        }
        if ((Config.getPref().getBoolean("marker.audiofromstart") || waypoints.isEmpty()) && hasTracks) {
            boolean gotOne = false;
            for (IGpxTrack track : this.layer.data.tracks) {
                for (IGpxTrackSegment seg : track.getSegments()) {
                    Iterator<WayPoint> iterator = seg.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        WayPoint w = iterator.next();
                        WayPoint wStart = new WayPoint(w.getCoor());
                        wStart.put("name", "start");
                        wStart.setTimeInMillis(w.getTimeInMillis());
                        waypoints.add(wStart);
                        gotOne = true;
                    }
                    if (!gotOne) continue;
                    break;
                }
                if (!gotOne) continue;
                break;
            }
        }
        waypoints.sort(Comparator.naturalOrder());
        firstTime = -1.0;
        for (WayPoint wayPoint : waypoints) {
            if (firstTime < 0.0) {
                firstTime = wayPoint.getTime();
            }
            double offset = wayPoint.getTime() - firstTime;
            AudioMarker am = new AudioMarker(wayPoint.getCoor(), (TemplateEngineDataProvider)wayPoint, url, ml, wayPoint.getTime(), offset);
            if (wayPoint == wayPointFromTimeStamp) {
                am.timeFromAudio = true;
            }
            ml.data.add(am);
        }
        if (timedMarkersOmitted && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start.", new Object[0]));
            markers.timedMarkersOmitted = timedMarkersOmitted;
        }
        if (untimedMarkersOmitted && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted.", new Object[0]));
            markers.untimedMarkersOmitted = untimedMarkersOmitted;
        }
    }

    public static final class AudioFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.isDirectory() || Utils.hasExtension(f, "wav", "mp3", "aac", "aif", "aiff");
        }

        @Override
        public String getDescription() {
            return I18n.tr("Audio files (*.wav, *.mp3, *.aac, *.aif, *.aiff)", new Object[0]);
        }
    }

    private static final class Markers {
        public boolean timedMarkersOmitted;
        public boolean untimedMarkersOmitted;

        private Markers() {
        }
    }
}

