/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class TaggingPresetSelector
extends SearchTextResultListPanel<TaggingPreset>
implements DataSelectionListener,
TaggingPresetListener {
    private static final int CLASSIFICATION_IN_FAVORITES = 300;
    private static final int CLASSIFICATION_NAME_MATCH = 300;
    private static final int CLASSIFICATION_GROUP_MATCH = 200;
    private static final int CLASSIFICATION_TAGS_MATCH = 100;
    private static final BooleanProperty SEARCH_IN_TAGS = new BooleanProperty("taggingpreset.dialog.search-in-tags", true);
    private static final BooleanProperty ONLY_APPLICABLE = new BooleanProperty("taggingpreset.dialog.only-applicable-to-selection", true);
    private final JCheckBox ckOnlyApplicable;
    private final JCheckBox ckSearchInTags;
    private final Set<TaggingPresetType> typesInSelection = EnumSet.noneOf(TaggingPresetType.class);
    private boolean typesInSelectionDirty = true;
    private final transient PresetClassifications classifications = new PresetClassifications();

    public TaggingPresetSelector(boolean displayOnlyApplicable, boolean displaySearchInTags) {
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.classifications.loadPresets(TaggingPresets.getTaggingPresets());
        TaggingPresets.addListener(this);
        JPanel pnChecks = new JPanel();
        pnChecks.setLayout(new BoxLayout(pnChecks, 1));
        if (displayOnlyApplicable) {
            this.ckOnlyApplicable = new JCheckBox();
            this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection", new Object[0]));
            pnChecks.add(this.ckOnlyApplicable);
            this.ckOnlyApplicable.addItemListener(e -> this.filterItems());
        } else {
            this.ckOnlyApplicable = null;
        }
        if (displaySearchInTags) {
            this.ckSearchInTags = new JCheckBox();
            this.ckSearchInTags.setText(I18n.tr("Search in tags", new Object[0]));
            this.ckSearchInTags.setSelected(SEARCH_IN_TAGS.get());
            this.ckSearchInTags.addItemListener(e -> this.filterItems());
            pnChecks.add(this.ckSearchInTags);
        } else {
            this.ckSearchInTags = null;
        }
        this.add((Component)pnChecks, "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.filterItems();
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(I18n.tr("Add toolbar button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TaggingPreset preset = TaggingPresetSelector.this.getSelectedPreset();
                if (preset != null) {
                    MainApplication.getToolbar().addCustomButton(preset.getToolbarString(), -1, false);
                }
            }
        });
        this.lsResult.addMouseListener(new PopupMenuLauncher(popupMenu));
    }

    @Override
    protected synchronized void filterItems() {
        String text = this.edSearchText.getText().toLowerCase(Locale.ENGLISH);
        boolean onlyApplicable = this.ckOnlyApplicable != null && this.ckOnlyApplicable.isSelected();
        boolean inTags = this.ckSearchInTags != null && this.ckSearchInTags.isSelected();
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        Collection<Object> selected = ds == null ? Collections.emptyList() : ds.getSelected();
        List<PresetClassification> result = this.classifications.getMatchingPresets(text, onlyApplicable, inTags, this.getTypesInSelection(), selected);
        TaggingPreset oldPreset = this.getSelectedPreset();
        this.lsResultModel.setItems(Utils.transform(result, x -> x.preset));
        TaggingPreset newPreset = this.getSelectedPreset();
        if (!Objects.equals(oldPreset, newPreset)) {
            int[] indices = this.lsResult.getSelectedIndices();
            for (ListSelectionListener listener : this.listSelectionListeners) {
                listener.valueChanged(new ListSelectionEvent(this.lsResult, this.lsResult.getSelectedIndex(), indices.length > 0 ? indices[indices.length - 1] : -1, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TaggingPresetType> getTypesInSelection() {
        if (this.typesInSelectionDirty) {
            Set<TaggingPresetType> set = this.typesInSelection;
            synchronized (set) {
                this.typesInSelectionDirty = false;
                this.typesInSelection.clear();
                if (OsmDataManager.getInstance().getEditDataSet() == null) {
                    return this.typesInSelection;
                }
                for (OsmPrimitive primitive : OsmDataManager.getInstance().getEditDataSet().getSelected()) {
                    this.typesInSelection.add(TaggingPresetType.forPrimitive(primitive));
                }
            }
        }
        return this.typesInSelection;
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.typesInSelectionDirty = true;
    }

    @Override
    public synchronized void init() {
        if (this.ckOnlyApplicable != null) {
            this.ckOnlyApplicable.setEnabled(!this.getTypesInSelection().isEmpty());
            this.ckOnlyApplicable.setSelected(!this.getTypesInSelection().isEmpty() && ONLY_APPLICABLE.get() != false);
        }
        super.init();
    }

    public void init(Collection<TaggingPreset> presets) {
        this.classifications.clear();
        this.classifications.loadPresets(presets);
        this.init();
    }

    public void savePreferences() {
        if (this.ckSearchInTags != null) {
            SEARCH_IN_TAGS.put(this.ckSearchInTags.isSelected());
        }
        if (this.ckOnlyApplicable != null && this.ckOnlyApplicable.isEnabled()) {
            ONLY_APPLICABLE.put(this.ckOnlyApplicable.isSelected());
        }
    }

    public synchronized TaggingPreset getSelectedPreset() {
        if (this.lsResultModel.isEmpty()) {
            return null;
        }
        int idx = this.lsResult.getSelectedIndex();
        if (idx < 0 || idx >= this.lsResultModel.getSize()) {
            idx = 0;
        }
        return (TaggingPreset)this.lsResultModel.getElementAt(idx);
    }

    public synchronized TaggingPreset getSelectedPresetAndUpdateClassification() {
        TaggingPreset preset = this.getSelectedPreset();
        for (PresetClassification pc : this.classifications) {
            if (pc.preset == preset) {
                pc.favoriteIndex = 300;
                continue;
            }
            if (pc.favoriteIndex <= 0) continue;
            --pc.favoriteIndex;
        }
        return preset;
    }

    public synchronized void setSelectedPreset(TaggingPreset p) {
        this.lsResult.setSelectedValue(p, true);
    }

    @Override
    public void taggingPresetsModified() {
        this.classifications.clear();
        this.classifications.loadPresets(TaggingPresets.getTaggingPresets());
    }

    public static class PresetClassifications
    implements Iterable<PresetClassification> {
        private final List<PresetClassification> classifications = new ArrayList<PresetClassification>();

        public List<PresetClassification> getMatchingPresets(String searchText, boolean onlyApplicable, boolean inTags, Set<TaggingPresetType> presetTypes, Collection<? extends OsmPrimitive> selectedPrimitives) {
            String[] nameWords;
            String[] groupWords;
            if (searchText.contains("/")) {
                groupWords = searchText.substring(0, searchText.lastIndexOf(47)).split("[\\s/]");
                nameWords = searchText.substring(searchText.indexOf(47) + 1).split("\\s");
            } else {
                groupWords = null;
                nameWords = searchText.split("\\s");
            }
            return this.getMatchingPresets(groupWords, nameWords, onlyApplicable, inTags, presetTypes, selectedPrimitives);
        }

        public List<PresetClassification> getMatchingPresets(String[] groupWords, String[] nameWords, boolean onlyApplicable, boolean inTags, Set<TaggingPresetType> presetTypes, Collection<? extends OsmPrimitive> selectedPrimitives) {
            ArrayList<PresetClassification> result = new ArrayList<PresetClassification>();
            for (PresetClassification presetClassification : this.classifications) {
                TaggingPreset preset = presetClassification.preset;
                presetClassification.classification = 0;
                if (onlyApplicable) {
                    boolean suitable = preset.typeMatches(presetTypes);
                    if (!suitable && preset.types.contains((Object)TaggingPresetType.RELATION) && preset.roles != null && !preset.roles.roles.isEmpty()) {
                        suitable = preset.roles.roles.stream().anyMatch(object -> object.memberExpression != null && selectedPrimitives.stream().anyMatch(object.memberExpression));
                    }
                    if (!suitable) continue;
                }
                if (groupWords != null && presetClassification.isMatchingGroup(groupWords) == 0) continue;
                int matchName = presetClassification.isMatchingName(nameWords);
                if (matchName == 0) {
                    int tagsMatch;
                    int groupMatch;
                    if (groupWords == null && (groupMatch = presetClassification.isMatchingGroup(nameWords)) > 0) {
                        presetClassification.classification = 200 + groupMatch;
                    }
                    if (presetClassification.classification == 0 && inTags && (tagsMatch = presetClassification.isMatchingTags(nameWords)) > 0) {
                        presetClassification.classification = 100 + tagsMatch;
                    }
                } else {
                    presetClassification.classification = 300 + matchName;
                }
                if (presetClassification.classification <= 0) continue;
                presetClassification.classification += presetClassification.favoriteIndex;
                result.add(presetClassification);
            }
            Collections.sort(result);
            return result;
        }

        public void clear() {
            this.classifications.clear();
        }

        public void loadPresets(Collection<TaggingPreset> presets) {
            for (TaggingPreset preset : presets) {
                if (preset instanceof TaggingPresetSeparator || preset instanceof TaggingPresetMenu) continue;
                this.classifications.add(new PresetClassification(preset));
            }
        }

        @Override
        public Iterator<PresetClassification> iterator() {
            return this.classifications.iterator();
        }
    }

    public static class PresetClassification
    implements Comparable<PresetClassification> {
        public final TaggingPreset preset;
        public int classification;
        public int favoriteIndex;
        private final Collection<String> groups;
        private final Collection<String> names;
        private final Collection<String> tags;

        PresetClassification(TaggingPreset preset) {
            this.preset = preset;
            HashSet<String> groupSet = new HashSet<String>();
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> tagSet = new HashSet<String>();
            TaggingPresetMenu group = preset.group;
            while (group != null) {
                PresetClassification.addLocaleNames(groupSet, group);
                group = group.group;
            }
            PresetClassification.addLocaleNames(nameSet, preset);
            for (TaggingPresetItem item : preset.data) {
                if (item instanceof KeyedItem) {
                    tagSet.add(((KeyedItem)item).key);
                    if (item instanceof ComboMultiSelect) {
                        ComboMultiSelect cms = (ComboMultiSelect)item;
                        if (cms.values_searchable) {
                            tagSet.addAll(cms.getDisplayValues());
                        }
                    }
                    if (!(item instanceof Key) || ((Key)item).value == null) continue;
                    tagSet.add(((Key)item).value);
                    continue;
                }
                if (!(item instanceof Roles)) continue;
                for (Roles.Role role : ((Roles)item).roles) {
                    tagSet.add(role.key);
                }
            }
            this.groups = Utils.toUnmodifiableList(groupSet);
            this.names = Utils.toUnmodifiableList(nameSet);
            this.tags = Utils.toUnmodifiableList(tagSet);
        }

        private static void addLocaleNames(Collection<String> collection, TaggingPreset preset) {
            String locName = preset.getLocaleName();
            if (locName != null) {
                Collections.addAll(collection, locName.toLowerCase(Locale.ENGLISH).split("\\s"));
            }
        }

        private static String simplifyString(String s) {
            return Utils.deAccent(s).toLowerCase(Locale.ENGLISH).replaceAll("\\p{Punct}", "");
        }

        private static int isMatching(Collection<String> values, String ... searchString) {
            int sum = 0;
            List deaccentedValues = values.stream().map(PresetClassification::simplifyString).collect(Collectors.toList());
            for (String word : searchString) {
                boolean found = false;
                boolean foundFirst = false;
                String deaccentedWord = PresetClassification.simplifyString(word);
                for (String value : deaccentedValues) {
                    int index = value.indexOf(deaccentedWord);
                    if (index == 0) {
                        foundFirst = true;
                        break;
                    }
                    if (index <= 0) continue;
                    found = true;
                }
                if (foundFirst) {
                    sum += 2;
                    continue;
                }
                if (found) {
                    ++sum;
                    continue;
                }
                return 0;
            }
            return sum;
        }

        int isMatchingGroup(String ... words) {
            return PresetClassification.isMatching(this.groups, words);
        }

        int isMatchingName(String ... words) {
            return PresetClassification.isMatching(this.names, words);
        }

        int isMatchingTags(String ... words) {
            return PresetClassification.isMatching(this.tags, words);
        }

        @Override
        public int compareTo(PresetClassification o) {
            int result = o.classification - this.classification;
            if (result == 0) {
                return this.preset.getName().compareTo(o.preset.getName());
            }
            return result;
        }

        public String toString() {
            return Integer.toString(this.classification) + ' ' + this.preset;
        }
    }

    private static class ResultListCellRenderer
    implements ListCellRenderer<TaggingPreset> {
        private final DefaultListCellRenderer def = new DefaultListCellRenderer();

        private ResultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TaggingPreset> list, TaggingPreset tp, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel result = (JLabel)this.def.getListCellRendererComponent(list, tp, index, isSelected, cellHasFocus);
            result.setText(tp.getName());
            result.setIcon((Icon)tp.getValue("SmallIcon"));
            return result;
        }
    }
}

