/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class TaginfoAction
extends AbstractAction {
    private static final StringProperty TAGINFO_URL_PROP = new StringProperty("taginfo.url", "https://taginfo.openstreetmap.org/");
    private final Supplier<Tag> tagSupplier;
    private final Supplier<String> relationTypeSupplier;
    private final String taginfoUrl;

    public TaginfoAction(Supplier<Tag> tagSupplier, Supplier<String> relationTypeSupplier) {
        super(I18n.tr("Go to Taginfo", new Object[0]));
        new ImageProvider("dialogs/taginfo").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Launch browser with Taginfo statistics for selected object", new Object[0]));
        this.tagSupplier = Objects.requireNonNull(tagSupplier);
        this.relationTypeSupplier = Objects.requireNonNull(relationTypeSupplier);
        this.taginfoUrl = TaginfoAction.getTaginfoUrl(null);
    }

    public TaginfoAction(String name, JTable tagTable, IntFunction<String> tagKeySupplier, IntFunction<Map<String, Integer>> tagValuesSupplier, JTable membershipTable, IntFunction<IRelation<?>> memberValueSupplier, String taginfoUrl) {
        super(name);
        new ImageProvider("dialogs/taginfo").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Launch browser with Taginfo statistics for selected object", new Object[0]));
        this.taginfoUrl = TaginfoAction.getTaginfoUrl(taginfoUrl);
        Objects.requireNonNull(tagTable);
        Objects.requireNonNull(tagKeySupplier);
        Objects.requireNonNull(tagValuesSupplier);
        this.tagSupplier = () -> {
            if (tagTable.getSelectedRowCount() == 1) {
                int row = tagTable.getSelectedRow();
                String key = Utils.encodeUrl((String)tagKeySupplier.apply(row)).replaceAll("\\+", "%20");
                Map values = (Map)tagValuesSupplier.apply(row);
                String value = values.size() == 1 ? (String)values.keySet().iterator().next() : null;
                return new Tag(key, value);
            }
            return null;
        };
        this.relationTypeSupplier = () -> membershipTable != null && membershipTable.getSelectedRowCount() == 1 ? ((IRelation)memberValueSupplier.apply(membershipTable.getSelectedRow())).get("type") : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Tag tag = this.tagSupplier.get();
        if (tag != null) {
            TaginfoAction.openTaginfoForTag(tag, this.taginfoUrl);
            return;
        }
        String type = this.relationTypeSupplier.get();
        if (type != null) {
            TaginfoAction.openTaginfoForRelationType(type, this.taginfoUrl);
        }
    }

    private static String getTaginfoUrl(String taginfoUrl) {
        if (taginfoUrl == null) {
            taginfoUrl = TAGINFO_URL_PROP.get();
        }
        return taginfoUrl.endsWith("/") ? taginfoUrl : taginfoUrl + '/';
    }

    public static void openTaginfoForTag(Tag tag, String taginfoUrl) {
        taginfoUrl = TaginfoAction.getTaginfoUrl(taginfoUrl);
        if (tag.getValue().isEmpty()) {
            OpenBrowser.displayUrl(taginfoUrl + "keys/" + tag.getKey());
        } else {
            OpenBrowser.displayUrl(taginfoUrl + "tags/" + tag.getKey() + '=' + Utils.encodeUrl(tag.getValue()).replaceAll("\\+", "%20"));
        }
    }

    public static void openTaginfoForRelationType(String type, String taginfoUrl) {
        taginfoUrl = TaginfoAction.getTaginfoUrl(taginfoUrl);
        OpenBrowser.displayUrl(taginfoUrl + "relations/" + type);
    }
}

