/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.jcs3.access.exception.InvalidArgumentException;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.DateFilterPanel;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.preferences.display.GPXSettingsPanel;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ChooseTrackVisibilityAction
extends AbstractAction {
    private final transient GpxLayer layer;
    private DateFilterPanel dateFilter;
    private JTable table;
    private boolean noUpdates;

    public ChooseTrackVisibilityAction(GpxLayer layer) {
        super(I18n.tr("Choose track visibility and colors", new Object[0]));
        new ImageProvider("dialogs/filter").getResource().attachImageIcon(this, true);
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ChooseTrackVisibility"));
    }

    private Object[][] buildTableContents() {
        Object[][] tracks = new Object[this.layer.data.tracks.size()][5];
        int i = 0;
        for (IGpxTrack trk : this.layer.data.tracks) {
            Map<String, Object> attr = trk.getAttributes();
            String name = (String)Optional.ofNullable(attr.get("name")).orElse("");
            String desc = (String)Optional.ofNullable(attr.get("desc")).orElse("");
            String time = GpxLayer.getTimespanForTrack(trk);
            TrackLength length = new TrackLength(trk.length());
            String url = (String)Optional.ofNullable(attr.get("url")).orElse("");
            tracks[i] = new Object[]{name, desc, time, length, url, trk};
            ++i;
        }
        return tracks;
    }

    private void showColorDialog(List<IGpxTrack> tracks) {
        Color cl = tracks.stream().filter(Objects::nonNull).map(IGpxTrack::getColor).filter(Objects::nonNull).findAny().orElse(GpxDrawHelper.DEFAULT_COLOR_PROPERTY.get());
        JColorChooser c = new JColorChooser(cl);
        Object[] options = new Object[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Default", new Object[0])};
        int answer = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), c, I18n.tr("Choose a color", new Object[0]), 2, -1, null, options, options[0]);
        switch (answer) {
            case 0: {
                tracks.forEach(t -> t.setColor(c.getColor()));
                GPXSettingsPanel.putLayerPrefLocal(this.layer, "colormode", "0");
                break;
            }
            case 1: {
                return;
            }
            case 2: {
                tracks.forEach(t -> t.setColor(null));
            }
        }
        this.table.repaint();
    }

    private static JTable buildTable(Object[] ... content) {
        Object[] headers = new String[]{I18n.tr("Name", new Object[0]), I18n.tr("Description", new Object[0]), I18n.tr("Timespan", new Object[0]), I18n.tr("Length", new Object[0]), I18n.tr("URL", new Object[0])};
        DefaultTableModel model = new DefaultTableModel(content, headers);
        GpxTrackTable t = new GpxTrackTable(content, model);
        TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>();
        t.setRowSorter(rowSorter);
        rowSorter.setModel(model);
        rowSorter.setComparator(3, new LengthContentComparator());
        t.getColumnModel().getColumn(0).setPreferredWidth(220);
        t.getColumnModel().getColumn(1).setPreferredWidth(300);
        t.getColumnModel().getColumn(2).setPreferredWidth(200);
        t.getColumnModel().getColumn(3).setPreferredWidth(50);
        t.getColumnModel().getColumn(4).setPreferredWidth(100);
        MouseAdapter urlOpener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int col = t.convertColumnIndexToModel(t.columnAtPoint(e.getPoint()));
                if (col != 4) {
                    return;
                }
                int row = t.rowAtPoint(e.getPoint());
                String url = (String)t.getValueAt(row, col);
                if (url == null || url.isEmpty()) {
                    return;
                }
                OpenBrowser.displayUrl(url);
            }
        };
        t.addMouseListener(urlOpener);
        t.setFillsViewportHeight(true);
        t.putClientProperty("terminateEditOnFocusLost", true);
        return t;
    }

    private void selectVisibleTracksInTable() {
        if (!this.layer.isVisible()) {
            return;
        }
        ListSelectionModel s = this.table.getSelectionModel();
        s.setValueIsAdjusting(true);
        s.clearSelection();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            if (!this.layer.trackVisibility[i]) continue;
            s.addSelectionInterval(i, i);
        }
        s.setValueIsAdjusting(false);
    }

    private void listenToSelectionChanges() {
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (this.noUpdates || !(e.getSource() instanceof ListSelectionModel)) {
                return;
            }
            this.updateVisibilityFromTable();
        });
    }

    private void updateVisibilityFromTable() {
        ListSelectionModel s = this.table.getSelectionModel();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = s.isSelectedIndex(i);
        }
        this.layer.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JPanel msg = new JPanel(new GridBagLayout());
        this.dateFilter = new DateFilterPanel(this.layer, "gpx.traces", false);
        this.dateFilter.setFilterAppliedListener(e -> {
            this.noUpdates = true;
            this.selectVisibleTracksInTable();
            this.noUpdates = false;
            this.layer.invalidate();
        });
        this.dateFilter.loadFromPrefs();
        JToggleButton b = new JToggleButton(new AbstractAction(I18n.tr("Select by date", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JToggleButton)e.getSource()).isSelected()) {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(true);
                    ChooseTrackVisibilityAction.this.dateFilter.applyFilter();
                } else {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(false);
                }
            }
        });
        this.dateFilter.setEnabled(false);
        msg.add((Component)b, GBC.std().insets(0, 0, 5, 0));
        msg.add((Component)this.dateFilter, GBC.eol().insets(0, 0, 10, 0).fill(2));
        msg.add((Component)new JLabel(I18n.tr("<html>Select all tracks that you want to be displayed. You can drag select a range of tracks or use CTRL+Click to select specific ones. The map is updated live in the background. Open the URLs by double clicking them, edit name and description by double clicking the cell.</html>", new Object[0])), GBC.eop().fill(2));
        boolean[] trackVisibilityBackup = (boolean[])this.layer.trackVisibility.clone();
        final Object[][] content = this.buildTableContents();
        this.table = ChooseTrackVisibilityAction.buildTable(content);
        this.selectVisibleTracksInTable();
        this.listenToSelectionChanges();
        JScrollPane scrollPane = new JScrollPane(this.table);
        msg.add((Component)scrollPane, GBC.eol().fill(1));
        int v = 1;
        ExtendedDialog ed = new ExtendedDialog(MainApplication.getMainFrame(), I18n.tr("Set track visibility for {0}", this.layer.getName()), new String[]{I18n.tr("Set color for selected tracks...", new Object[0]), I18n.tr("Show all", new Object[0]), I18n.tr("Show selected only", new Object[0]), I18n.tr("Close", new Object[0])}){

            @Override
            protected void buttonAction(int buttonIndex, ActionEvent evt) {
                if (buttonIndex == 0) {
                    List trks = Arrays.stream(ChooseTrackVisibilityAction.this.table.getSelectedRows()).mapToObj(i -> content[i][5]).filter(trk -> trk instanceof IGpxTrack).map(IGpxTrack.class::cast).collect(Collectors.toList());
                    ChooseTrackVisibilityAction.this.showColorDialog(trks);
                } else {
                    super.buttonAction(buttonIndex, evt);
                }
            }
        };
        ed.setButtonIcons("colorchooser", "eye", "dialogs/filter", "cancel");
        ed.setContent(msg, false);
        ed.setDefaultButton(2);
        ed.setCancelButton(3);
        ed.configureContextsensitiveHelp("/Action/ChooseTrackVisibility", true);
        ed.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(1000, 500)));
        ed.showDialog();
        this.dateFilter.saveInPrefs();
        v = ed.getValue();
        if (v != 2 && v != 3) {
            this.layer.trackVisibility = Arrays.copyOf(trackVisibilityBackup, this.layer.trackVisibility.length);
            MainApplication.getMap().repaint();
            return;
        }
        ListSelectionModel s = this.table.getSelectionModel();
        boolean all = v == 2 || s.isSelectionEmpty();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = all || s.isSelectedIndex(i);
        }
        this.layer.invalidate();
        this.layer.setVisible(v == 2 || !s.isSelectionEmpty());
    }

    private static class GpxTrackTable
    extends JTable {
        final Object[][] content;

        GpxTrackTable(Object[][] content, TableModel model) {
            super(model);
            this.content = content;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
            Component c = super.prepareRenderer(renderer, row, col);
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setToolTipText(this.getValueAt(row, col).toString());
                if (this.content.length > row && this.content[row].length > 5 && this.content[row][5] instanceof IGpxTrack) {
                    Color color = ((IGpxTrack)this.content[row][5]).getColor();
                    if (color != null) {
                        double brightness = Math.sqrt(Math.pow(color.getRed(), 2.0) * 0.241 + Math.pow(color.getGreen(), 2.0) * 0.691 + Math.pow(color.getBlue(), 2.0) * 0.068);
                        if (brightness > 250.0) {
                            color = color.darker();
                        }
                        if (this.isRowSelected(row)) {
                            jc.setBackground(color);
                            if (brightness <= 130.0) {
                                jc.setForeground(Color.WHITE);
                            } else {
                                jc.setForeground(Color.BLACK);
                            }
                        } else {
                            if (brightness > 200.0) {
                                color = color.darker();
                            }
                            jc.setForeground(color);
                            jc.setBackground(Color.WHITE);
                        }
                    } else {
                        jc.setForeground(Color.BLACK);
                        if (this.isRowSelected(row)) {
                            jc.setBackground(new Color(175, 210, 210));
                        } else {
                            jc.setBackground(Color.WHITE);
                        }
                    }
                }
            }
            return c;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex <= 1;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            int col = e.getColumn();
            int row = e.getFirstRow();
            if (row >= 0 && row < this.content.length && col >= 0 && col <= 1) {
                Object t = this.content[row][5];
                String val = (String)this.getValueAt(row, col);
                if (t != null && t instanceof IGpxTrack) {
                    IGpxTrack trk = (IGpxTrack)t;
                    if (col == 0) {
                        trk.put("name", val);
                    } else {
                        trk.put("desc", val);
                    }
                } else {
                    throw new InvalidArgumentException("Invalid object in table, must be IGpxTrack.");
                }
            }
        }
    }

    private static final class LengthContentComparator
    implements Comparator<TrackLength>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LengthContentComparator() {
        }

        @Override
        public int compare(TrackLength l0, TrackLength l1) {
            return Double.compare(l0.value, l1.value);
        }
    }

    private static final class TrackLength {
        private final double value;

        TrackLength(double value) {
            this.value = value;
        }

        public String toString() {
            return SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.value);
        }
    }
}

