/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.text.MessageFormat;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;

public final class UserIdentityManager
implements PreferenceChangedListener {
    private static UserIdentityManager instance;
    private final ListenerList<UserIdentityListener> listeners = ListenerList.create();
    private String userName;
    private UserInfo userInfo;
    private boolean accessTokenKeyChanged;
    private boolean accessTokenSecretChanged;

    public static synchronized UserIdentityManager getInstance() {
        if (instance == null) {
            instance = new UserIdentityManager();
            if (OsmApi.isUsingOAuth() && OAuthAccessTokenHolder.getInstance().containsAccessToken() && !NetworkManager.isOffline(OnlineResource.OSM_API)) {
                try {
                    instance.initFromOAuth();
                }
                catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                    Logging.error(e);
                    instance.initFromPreferences();
                }
            } else {
                instance.initFromPreferences();
            }
            Config.getPref().addPreferenceChangeListener(instance);
        }
        return instance;
    }

    private UserIdentityManager() {
    }

    public void setAnonymous() {
        this.userName = null;
        this.userInfo = null;
        this.fireUserIdentityChanged();
    }

    public void setPartiallyIdentified(String userName) {
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        String trimmedUserName = userName.trim();
        if (trimmedUserName.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", userName));
        }
        this.userName = trimmedUserName;
        this.userInfo = null;
        this.fireUserIdentityChanged();
    }

    public void setFullyIdentified(String userName, UserInfo userInfo) {
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        String trimmedUserName = userName.trim();
        if (trimmedUserName.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", userName));
        }
        CheckParameterUtil.ensureParameterNotNull(userInfo, "userInfo");
        this.userName = trimmedUserName;
        this.userInfo = userInfo;
        this.fireUserIdentityChanged();
    }

    public boolean isAnonymous() {
        return this.userName == null && this.userInfo == null;
    }

    public boolean isPartiallyIdentified() {
        return this.userName != null && this.userInfo == null;
    }

    public boolean isFullyIdentified() {
        return this.userName != null && this.userInfo != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserId() {
        if (this.userInfo == null) {
            return 0;
        }
        return this.userInfo.getId();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public User asUser() {
        return this.isAnonymous() ? User.getAnonymous() : User.createOsmUser(this.userInfo != null ? (long)this.userInfo.getId() : 0L, this.userName);
    }

    public void initFromPreferences() {
        String credentialsUserName = CredentialsManager.getInstance().getUsername();
        if (this.isAnonymous()) {
            if (credentialsUserName != null && !credentialsUserName.trim().isEmpty()) {
                this.setPartiallyIdentified(credentialsUserName);
            }
        } else if (credentialsUserName != null && !credentialsUserName.equals(this.userName)) {
            this.setPartiallyIdentified(credentialsUserName);
        }
    }

    public void initFromOAuth() {
        try {
            UserInfo info = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE);
            this.setFullyIdentified(info.getDisplayName(), info);
        }
        catch (IllegalArgumentException | OsmTransferException e) {
            Logging.error(e);
        }
    }

    public boolean isCurrentUser(String userName) {
        return this.userName != null && this.userName.equals(userName);
    }

    public boolean isCurrentUser(User user) {
        if (user == null) {
            return false;
        }
        if (this.isFullyIdentified()) {
            return (long)this.getUserId() == user.getId();
        }
        return this.isCurrentUser(user.getName());
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent evt) {
        switch (evt.getKey()) {
            case "osm-server.username": {
                String newUserName = null;
                if (evt.getNewValue() instanceof StringSetting) {
                    newUserName = (String)((StringSetting)evt.getNewValue()).getValue();
                }
                if (newUserName == null || newUserName.trim().isEmpty()) {
                    this.setAnonymous();
                } else if (!newUserName.equals(this.userName)) {
                    this.setPartiallyIdentified(newUserName);
                }
                return;
            }
            case "osm-server.url": {
                String newUrl = null;
                if (evt.getNewValue() instanceof StringSetting) {
                    newUrl = (String)((StringSetting)evt.getNewValue()).getValue();
                }
                if (newUrl == null || newUrl.trim().isEmpty()) {
                    this.setAnonymous();
                    break;
                }
                if (!this.isFullyIdentified()) break;
                this.setPartiallyIdentified(this.getUserName());
                break;
            }
            case "oauth.access-token.key": {
                this.accessTokenKeyChanged = true;
                break;
            }
            case "oauth.access-token.secret": {
                this.accessTokenSecretChanged = true;
                break;
            }
        }
        if (this.accessTokenKeyChanged && this.accessTokenSecretChanged) {
            this.accessTokenKeyChanged = false;
            this.accessTokenSecretChanged = false;
            if (OsmApi.isUsingOAuth()) {
                UserIdentityManager.getInstance().initFromOAuth();
            }
        }
    }

    public void addListener(UserIdentityListener listener) {
        this.listeners.addListener(listener);
    }

    private void fireUserIdentityChanged() {
        this.listeners.fireEvent(UserIdentityListener::userIdentityChanged);
    }

    @FunctionalInterface
    public static interface UserIdentityListener {
        public void userIdentityChanged();
    }
}

