/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.DownloadNotesInViewAction;
import org.openstreetmap.josm.actions.UploadNotesAction;
import org.openstreetmap.josm.actions.mapmode.AddNoteAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.NoteSortDialog;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NotesDialog
extends ToggleDialog
implements LayerManager.LayerChangeListener,
NoteData.NoteDataUpdateListener {
    private NoteTableModel model;
    private JList<Note> displayList;
    private final AddCommentAction addCommentAction = new AddCommentAction();
    private final CloseAction closeAction = new CloseAction();
    private final DownloadNotesInViewAction downloadNotesInViewAction = DownloadNotesInViewAction.newActionWithDownloadIcon();
    private final NewAction newAction = new NewAction();
    private final ReopenAction reopenAction = new ReopenAction();
    private final SortAction sortAction = new SortAction();
    private final OpenInBrowserAction openInBrowserAction = new OpenInBrowserAction();
    private final UploadNotesAction uploadAction = new UploadNotesAction();
    private transient NoteData noteData;

    public NotesDialog() {
        super(I18n.tr("Notes", new Object[0]), "notes/note_open", I18n.tr("List of notes", new Object[0]), Shortcut.registerShortcut("subwindow:notes", I18n.tr("Windows: {0}", I18n.tr("Notes", new Object[0])), 65535, 5000), 150);
        this.buildDialog();
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    private void buildDialog() {
        this.model = new NoteTableModel();
        this.displayList = new JList<Note>(this.model);
        this.displayList.setCellRenderer(new NoteRenderer());
        this.displayList.setSelectionMode(0);
        this.displayList.addListSelectionListener(e -> {
            if (this.noteData != null) {
                this.noteData.setSelectedNote(this.displayList.getSelectedValue());
            }
            this.updateButtonStates();
        });
        this.displayList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && NotesDialog.this.noteData != null && NotesDialog.this.noteData.getSelectedNote() != null) {
                    MainApplication.getMap().mapView.zoomTo(NotesDialog.this.noteData.getSelectedNote().getLatLon());
                }
            }
        });
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)new JScrollPane(this.displayList), "Center");
        this.createLayout(pane, false, Arrays.asList(new SideButton((Action)this.downloadNotesInViewAction, false), new SideButton((Action)this.newAction, false), new SideButton((Action)this.addCommentAction, false), new SideButton((Action)this.closeAction, false), new SideButton((Action)this.reopenAction, false), new SideButton((Action)this.sortAction, false), new SideButton((Action)this.openInBrowserAction, false), new SideButton((Action)this.uploadAction, false)));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(false);
        } else if (this.noteData.getSelectedNote().getState() == Note.State.OPEN) {
            this.closeAction.setEnabled(true);
            this.addCommentAction.setEnabled(true);
            this.reopenAction.setEnabled(false);
        } else {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(true);
        }
        this.openInBrowserAction.setEnabled(this.noteData != null && this.noteData.getSelectedNote() != null && this.noteData.getSelectedNote().getId() > 0L);
        this.uploadAction.setEnabled(this.noteData != null && this.noteData.isModified());
        this.sortAction.setEnabled(this.noteData != null && !this.noteData.getNotes().isEmpty());
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() instanceof NoteLayer) {
            this.noteData = ((NoteLayer)e.getAddedLayer()).getNoteData();
            this.model.setData(this.noteData.getNotes());
            this.setNotes(this.noteData.getSortedNotes());
            this.noteData.addNoteDataUpdateListener(this);
        }
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof NoteLayer) {
            NoteData removedNoteData = ((NoteLayer)e.getRemovedLayer()).getNoteData();
            removedNoteData.removeNoteDataUpdateListener(this);
            if (Objects.equals(this.noteData, removedNoteData)) {
                this.noteData = null;
                this.model.clearData();
                MapFrame map = MainApplication.getMap();
                if (map.mapMode instanceof AddNoteAction) {
                    map.selectMapMode(map.mapModeSelect);
                }
            }
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void noteDataUpdated(NoteData data) {
        this.setNotes(data.getSortedNotes());
    }

    @Override
    public void selectedNoteChanged(NoteData noteData) {
        this.selectionChanged();
    }

    public void setNotes(Collection<Note> noteList) {
        this.model.setData(noteList);
        this.updateButtonStates();
        this.repaint();
    }

    public void selectionChanged() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.displayList.clearSelection();
        } else {
            this.displayList.setSelectedValue(this.noteData.getSelectedNote(), true);
        }
        this.updateButtonStates();
        MainApplication.getMenu().infoweb.noteSelectionChanged();
    }

    public Note getSelectedNote() {
        return this.noteData != null ? this.noteData.getSelectedNote() : null;
    }

    @Override
    public void destroy() {
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        super.destroy();
    }

    class OpenInBrowserAction
    extends AbstractAction {
        OpenInBrowserAction() {
            this.putValue("ShortDescription", I18n.tr("Open the note in an external browser", new Object[0]));
            new ImageProvider("help", "internet").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            if (note.getId() > 0L) {
                String url = Config.getUrls().getBaseBrowseUrl() + "/note/" + note.getId();
                OpenBrowser.displayUrl(url);
            }
        }
    }

    class SortAction
    extends AbstractAction {
        SortAction() {
            this.putValue("ShortDescription", I18n.tr("Sort notes", new Object[0]));
            this.putValue("Name", I18n.tr("Sort", new Object[0]));
            new ImageProvider("dialogs", "sort").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteSortDialog sortDialog = new NoteSortDialog((Component)MainApplication.getMainFrame(), I18n.tr("Sort notes", new Object[0]), I18n.tr("Apply", new Object[0]));
            sortDialog.showSortDialog(NotesDialog.this.noteData.getCurrentSortMethod());
            if (sortDialog.getValue() == 1) {
                NotesDialog.this.noteData.setSortMethod(sortDialog.getSelectedComparator());
            }
        }
    }

    class ReopenAction
    extends AbstractAction {
        ReopenAction() {
            this.putValue("ShortDescription", I18n.tr("Reopen note", new Object[0]));
            this.putValue("Name", I18n.tr("Reopen", new Object[0]));
            new ImageProvider("dialogs/notes", "note_open").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteInputDialog dialog = new NoteInputDialog((Component)MainApplication.getMainFrame(), I18n.tr("Reopen note", new Object[0]), I18n.tr("Reopen note", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Reopen note with message:", new Object[0]), ImageProvider.get("dialogs/notes", "note_open"));
            if (dialog.getValue() != 1) {
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.reOpenNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new note", new Object[0]));
            this.putValue("Name", I18n.tr("Create", new Object[0]));
            new ImageProvider("dialogs/notes", "note_new").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NotesDialog.this.noteData == null) {
                MainApplication.getLayerManager().addLayer(new NoteLayer());
            }
            if (NotesDialog.this.noteData != null) {
                MainApplication.getMap().selectMapMode(new AddNoteAction(NotesDialog.this.noteData));
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("ShortDescription", I18n.tr("Close note", new Object[0]));
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            new ImageProvider("dialogs/notes", "note_closed").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteInputDialog dialog = new NoteInputDialog((Component)MainApplication.getMainFrame(), I18n.tr("Close note", new Object[0]), I18n.tr("Close note", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Close note with message:", new Object[0]), ImageProvider.get("dialogs/notes", "note_closed"));
            if (dialog.getValue() != 1) {
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.closeNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class AddCommentAction
    extends AbstractAction {
        AddCommentAction() {
            this.putValue("ShortDescription", I18n.tr("Add comment", new Object[0]));
            this.putValue("Name", I18n.tr("Comment", new Object[0]));
            new ImageProvider("dialogs/notes", "note_comment").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            if (note == null) {
                JOptionPane.showMessageDialog(MainApplication.getMap(), "You must select a note first", "No note selected", 0);
                return;
            }
            NoteInputDialog dialog = new NoteInputDialog((Component)MainApplication.getMainFrame(), I18n.tr("Comment on note", new Object[0]), I18n.tr("Add comment", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Add comment to note:", new Object[0]), ImageProvider.get("dialogs/notes", "note_comment"));
            if (dialog.getValue() != 1) {
                return;
            }
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.addCommentToNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class NoteTableModel
    extends AbstractListModel<Note> {
        private final transient List<Note> data = new ArrayList<Note>();

        NoteTableModel() {
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Note getElementAt(int index) {
            return this.data.get(index);
        }

        public void setData(Collection<Note> noteList) {
            this.data.clear();
            this.data.addAll(noteList);
            this.fireContentsChanged(this, 0, noteList.size());
        }

        public void clearData() {
            NotesDialog.this.displayList.clearSelection();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    static class NoteRenderer
    implements ListCellRenderer<Note> {
        private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        private final DateFormat dateFormat = DateUtils.getDateTimeFormat(2, 3);

        NoteRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Note> list, Note note, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.defaultListCellRenderer.getListCellRendererComponent(list, note, index, isSelected, cellHasFocus);
            if (note != null && comp instanceof JLabel) {
                NoteComment fstComment = note.getFirstComment();
                JLabel jlabel = (JLabel)comp;
                if (fstComment != null) {
                    String text = fstComment.getText();
                    String userName = fstComment.getUser().getName();
                    if (userName == null || userName.isEmpty()) {
                        userName = "<Anonymous>";
                    }
                    String toolTipText = userName + " @ " + this.dateFormat.format(note.getCreatedAt());
                    jlabel.setToolTipText(toolTipText);
                    jlabel.setText(note.getId() + ": " + text.replace("\n\n", "\n").replace("\n", "; ").replace(":; ", ": "));
                } else {
                    jlabel.setToolTipText(null);
                    jlabel.setText(Long.toString(note.getId()));
                }
                ImageIcon icon = note.getId() < 0L ? ImageProvider.get("dialogs/notes", "note_new", ImageProvider.ImageSizes.SMALLICON) : (note.getState() == Note.State.CLOSED ? ImageProvider.get("dialogs/notes", "note_closed", ImageProvider.ImageSizes.SMALLICON) : ImageProvider.get("dialogs/notes", "note_open", ImageProvider.ImageSizes.SMALLICON));
                jlabel.setIcon(icon);
            }
            return comp;
        }
    }
}

