/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;

public final class Categories {
    public static final Categories CASING = Categories.make("CASING", "category_case");
    public static final Categories COMPOUNDING = Categories.make("COMPOUNDING", "category_compounding");
    public static final Categories GRAMMAR = Categories.make("GRAMMAR", "category_grammar");
    public static final Categories TYPOS = Categories.make("TYPOS", "category_typo");
    public static final Categories PUNCTUATION = Categories.make("PUNCTUATION", "category_punctuation");
    public static final Categories TYPOGRAPHY = Categories.make("TYPOGRAPHY", "category_typography");
    public static final Categories CONFUSED_WORDS = Categories.make("CONFUSED_WORDS", "category_confused_words");
    public static final Categories REPETITIONS = Categories.make("REPETITIONS", "category_repetitions");
    public static final Categories REDUNDANCY = Categories.make("REDUNDANCY", "category_redundancy");
    public static final Categories STYLE = Categories.make("STYLE", "category_style");
    public static final Categories PLAIN_ENGLISH = Categories.make("PLAIN_ENGLISH", "category_style");
    public static final Categories GENDER_NEUTRALITY = Categories.make("GENDER_NEUTRALITY", "category_gender_neutrality");
    public static final Categories SEMANTICS = Categories.make("SEMANTICS", "category_semantics");
    public static final Categories COLLOQUIALISMS = Categories.make("COLLOQUIALISMS", "category_colloquialism");
    public static final Categories REGIONALISMS = Categories.make("REGIONALISMS", "category_regionalisms");
    public static final Categories FALSE_FRIENDS = Categories.make("FALSE_FRIENDS", "category_false_friend");
    public static final Categories WIKIPEDIA = Categories.make("WIKIPEDIA", "category_wikipedia");
    public static final Categories MISC = Categories.make("MISC", "category_misc");
    private final String id;
    private final String messageKey;

    private static Categories make(String id, String message) {
        return new Categories(id, message);
    }

    private Categories(String id, String messageKey) {
        this.id = Objects.requireNonNull(id);
        this.messageKey = Objects.requireNonNull(messageKey);
    }

    public CategoryId getId() {
        return new CategoryId(this.id);
    }

    public Category getCategory(ResourceBundle messages) {
        return new Category(new CategoryId(this.id), messages.getString(this.messageKey));
    }
}

