/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbPooledConnection;
import org.mariadb.jdbc.MariaXaConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;
import org.mariadb.jdbc.internal.util.pool.Pool;
import org.mariadb.jdbc.util.DefaultOptions;
import org.mariadb.jdbc.util.Options;

public class MariaDbDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private UrlParser urlParser;
    private Pool pool;
    private String hostname;
    private Integer port = 3306;
    private Integer connectTimeoutInMs;
    private String database;
    private String url;
    private String user;
    private String password;
    private String properties;

    public MariaDbDataSource(String hostname, int port, String database) {
        this.hostname = hostname;
        this.port = port;
        this.database = database;
    }

    public MariaDbDataSource(String url) {
        this.url = url;
    }

    public MariaDbDataSource() {
    }

    public String getDatabaseName() {
        if (this.database != null) {
            return this.database;
        }
        return this.urlParser != null && this.urlParser.getDatabase() != null ? this.urlParser.getDatabase() : "";
    }

    public void setDatabaseName(String database) throws SQLException {
        this.database = database;
        this.reInitializeIfNeeded();
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return this.urlParser != null ? this.urlParser.getUsername() : null;
    }

    public void setUser(String user) throws SQLException {
        this.user = user;
        this.reInitializeIfNeeded();
    }

    public String getUserName() {
        return this.getUser();
    }

    public void setUserName(String userName) throws SQLException {
        this.setUser(userName);
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
        this.reInitializeIfNeeded();
    }

    public int getPort() {
        if (this.port != 0) {
            return this.port;
        }
        return this.urlParser != null ? this.urlParser.getHostAddresses().get((int)0).port : 3306;
    }

    public void setPort(int port) throws SQLException {
        this.port = port;
        this.reInitializeIfNeeded();
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPortNumber(int port) throws SQLException {
        if (port > 0) {
            this.setPort(port);
        }
    }

    @Deprecated
    public void setProperties(String properties) throws SQLException {
        this.properties = properties;
        this.reInitializeIfNeeded();
    }

    public void setUrl(String url) throws SQLException {
        this.url = url;
        this.reInitializeIfNeeded();
    }

    public String getServerName() {
        if (this.hostname != null) {
            return this.hostname;
        }
        boolean hasHost = this.urlParser != null && this.urlParser.getHostAddresses().get((int)0).host != null;
        return hasHost ? this.urlParser.getHostAddresses().get((int)0).host : "localhost";
    }

    public void setServerName(String serverName) throws SQLException {
        this.hostname = serverName;
        this.reInitializeIfNeeded();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.urlParser == null) {
                this.initialize();
            }
            return MariaDbConnection.newConnection(this.urlParser, null);
        }
        catch (SQLException e) {
            throw ExceptionMapper.getException(e, null, null, false);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            if (this.urlParser == null) {
                this.user = username;
                this.password = password;
                this.initialize();
            }
            UrlParser urlParser = (UrlParser)this.urlParser.clone();
            urlParser.setUsername(username);
            urlParser.setPassword(password);
            return MariaDbConnection.newConnection(urlParser, null);
        }
        catch (SQLException e) {
            throw ExceptionMapper.getException(e, null, null, false);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new SQLException("Error in configuration");
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.connectTimeoutInMs != null) {
            return this.connectTimeoutInMs / 1000;
        }
        return this.urlParser != null ? this.urlParser.getOptions().connectTimeout / 1000 : 30;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.connectTimeoutInMs = seconds * 1000;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new MariaXaConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new MariaXaConnection((MariaDbConnection)this.getConnection(user, password));
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    protected UrlParser getUrlParser() {
        return this.urlParser;
    }

    private void reInitializeIfNeeded() throws SQLException {
        if (this.urlParser != null) {
            this.initialize();
        }
    }

    protected synchronized void initialize() throws SQLException {
        if (this.url != null && !this.url.isEmpty()) {
            Properties props = new Properties();
            if (this.user != null) {
                props.setProperty("user", this.user);
            }
            if (this.password != null) {
                props.setProperty("password", this.password);
            }
            if (this.database != null) {
                props.setProperty("database", this.database);
            }
            if (this.connectTimeoutInMs != null) {
                props.setProperty("connectTimeout", String.valueOf(this.connectTimeoutInMs));
            }
            this.urlParser = UrlParser.parse(this.url, props);
        } else {
            Options options = DefaultOptions.defaultValues(HaMode.NONE);
            options.user = this.user;
            options.password = this.password;
            this.urlParser = new UrlParser(this.database, Collections.singletonList(new HostAddress(this.hostname == null || this.hostname.isEmpty() ? "localhost" : this.hostname, this.port == null ? 3306 : this.port)), options, HaMode.NONE);
            if (this.properties != null) {
                this.urlParser.setProperties(this.properties);
            }
            if (this.connectTimeoutInMs != null) {
                this.urlParser.getOptions().connectTimeout = this.connectTimeoutInMs;
            }
        }
    }
}

