/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleId;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleXmlCreator;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RegexPatternRule;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class PatternRule
extends AbstractPatternRule {
    private final String shortMessage;
    private final List<Integer> elementNo;
    private final Set<String> simpleRuleTokens;
    private final Set<String> inflectedRuleTokens;
    private final boolean useList;
    private boolean interpretPosTagsPreDisambiguation;
    private boolean isMemberOfDisjunctiveSet;

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg) {
        super(id, description, language, patternTokens, false);
        this.message = Objects.requireNonNull(message);
        this.shortMessage = Objects.requireNonNull(shortMessage);
        this.elementNo = new ArrayList<Integer>(0);
        Objects.requireNonNull(suggestionsOutMsg);
        this.suggestionsOutMsg = suggestionsOutMsg.isEmpty() ? "" : suggestionsOutMsg;
        String prevName = "";
        int cnt = 0;
        int loopCnt = 0;
        boolean tempUseList = false;
        for (PatternToken pToken : this.patternTokens) {
            if (pToken.isPartOfPhrase()) {
                String curName = pToken.getPhraseName();
                if (StringTools.isEmpty(prevName) || prevName.equals(curName)) {
                    ++cnt;
                    tempUseList = true;
                } else {
                    this.elementNo.add(cnt);
                    curName = "";
                    cnt = 0;
                }
                prevName = curName;
                if (++loopCnt != this.patternTokens.size() || StringTools.isEmpty(prevName)) continue;
                this.elementNo.add(cnt);
                continue;
            }
            if (cnt > 0) {
                this.elementNo.add(cnt);
            }
            this.elementNo.add(1);
            ++loopCnt;
        }
        this.useList = tempUseList;
        this.simpleRuleTokens = this.getSet(false);
        this.inflectedRuleTokens = this.getSet(true);
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage) {
        this(id, language, patternTokens, description, message, shortMessage, "");
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg, isMember, false);
    }

    public PatternRule(String id, Language language, List<PatternToken> patternTokens, String description, String message, String shortMessage, String suggestionsOutMsg, boolean isMember, boolean interpretPosTagsPreDisambiguation) {
        this(id, language, patternTokens, description, message, shortMessage, suggestionsOutMsg);
        this.isMemberOfDisjunctiveSet = isMember;
        this.interpretPosTagsPreDisambiguation = interpretPosTagsPreDisambiguation;
    }

    @Override
    public int estimateContextForSureMatch() {
        int extendAfterMarker = 0;
        boolean markerSeen = false;
        for (PatternToken pToken : this.patternTokens) {
            if (markerSeen && !pToken.isInsideMarker()) {
                ++extendAfterMarker;
            }
            if ("SENT_END".equals(pToken.getPOStag())) {
                ++extendAfterMarker;
            }
            if (pToken.isInsideMarker()) {
                markerSeen = true;
            }
            if (pToken.getSkipNext() == -1) {
                return -1;
            }
            extendAfterMarker += pToken.getSkipNext();
        }
        List antiPatternLengths = this.getAntiPatterns().stream().map(p -> p.patternTokens.size()).collect(Collectors.toList());
        int longestAntiPattern = antiPatternLengths.stream().max(Comparator.comparing(i -> i)).orElse(0);
        int longestSkip = 0;
        for (DisambiguationPatternRule antiPattern : this.getAntiPatterns()) {
            for (PatternToken token : antiPattern.getPatternTokens()) {
                if (token.getSkipNext() == -1) {
                    return -1;
                }
                if (token.getSkipNext() <= longestSkip) continue;
                longestSkip = token.getSkipNext();
            }
        }
        return extendAfterMarker + Math.max(longestAntiPattern, longestAntiPattern + longestSkip);
    }

    boolean isInterpretPosTagsPreDisambiguation() {
        return this.interpretPosTagsPreDisambiguation;
    }

    final boolean isWithComplexPhrase() {
        return this.isMemberOfDisjunctiveSet;
    }

    final void notComplexPhrase() {
        this.isMemberOfDisjunctiveSet = false;
    }

    public final String toPatternString() {
        ArrayList<String> strList = new ArrayList<String>();
        for (PatternToken patternPatternToken : this.patternTokens) {
            strList.add(patternPatternToken.toString());
        }
        return String.join((CharSequence)", ", strList);
    }

    public final String toXML() {
        return new PatternRuleXmlCreator().toXML(new PatternRuleId(this.getId(), this.getSubId()), this.getLanguage());
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        try {
            RuleMatcher matcher;
            if (this.patternTokens != null) {
                matcher = new PatternRuleMatcher(this, this.useList);
            } else if (this.regex != null) {
                matcher = new RegexPatternRule(this.getId(), this.getDescription(), this.getMessage(), this.getShortMessage(), this.getSuggestionsOutMsg(), this.language, this.regex, this.regexMark);
            } else {
                throw new IllegalStateException("Neither pattern tokens nor regex set for rule " + this.getId());
            }
            return matcher.match(this.getSentenceWithImmunization(sentence));
        }
        catch (IOException e) {
            throw new IOException("Error analyzing sentence: '" + sentence + "'", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error analyzing sentence: '" + sentence + "' with rule " + this.getFullId(), e);
        }
    }

    public boolean canBeIgnoredFor(AnalyzedSentence sentence) {
        return !this.simpleRuleTokens.isEmpty() && !sentence.getTokenSet().containsAll(this.simpleRuleTokens) || !this.inflectedRuleTokens.isEmpty() && !sentence.getLemmaSet().containsAll(this.inflectedRuleTokens);
    }

    private Set<String> getSet(boolean isInflected) {
        HashSet<String> set = new HashSet<String>();
        for (PatternToken patternToken : this.patternTokens) {
            String str;
            boolean acceptInflectionValue = isInflected ? patternToken.isInflected() : !patternToken.isInflected();
            if (!acceptInflectionValue || patternToken.getNegation() || patternToken.isRegularExpression() || patternToken.isReferenceElement() || patternToken.getMinOccurrence() <= 0 || StringTools.isEmpty(str = patternToken.getString())) continue;
            set.add(str.toLowerCase());
        }
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    List<Integer> getElementNo() {
        return this.elementNo;
    }

    @Override
    public String getShortMessage() {
        return this.shortMessage;
    }
}

