/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class PatternToken
implements Cloneable {
    public static final String UNKNOWN_TAG = "UNKNOWN";
    private final boolean inflected;
    private List<PatternToken> andGroupList;
    private List<PatternToken> orGroupList;
    private StringMatcher textMatcher;
    private PosToken posToken;
    private ChunkTag chunkTag;
    private boolean negation;
    private boolean testWhitespace;
    private boolean whitespaceBefore;
    private boolean isInsideMarker = true;
    private Exceptions exceptions;
    private boolean exceptionValidNext;
    private byte skip;
    private boolean mayBeOmitted;
    private byte maxOccurrence = 1;
    private Match tokenReference;
    private String phraseName;
    private boolean testString;
    private boolean unificationNeutral;
    private boolean uniNegation;
    private Map<String, List<String>> unificationFeatures;
    private boolean isLastUnified;

    public PatternToken(String token, boolean caseSensitive, boolean regExp, boolean inflected) {
        this(inflected, StringMatcher.create(PatternToken.normalizeTextPattern(token), regExp, caseSensitive));
    }

    PatternToken(boolean inflected, @NotNull StringMatcher textMatcher) {
        this.inflected = inflected;
        this.setTextMatcher(textMatcher);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isMatched(AnalyzedToken token) {
        boolean posNegation;
        if (this.testWhitespace && !this.isWhitespaceBefore(token)) {
            return false;
        }
        boolean bl = posNegation = this.posToken != null && this.posToken.negation;
        if (this.testString) {
            return this.textMatcher.matches(this.getTestToken(token)) ^ this.negation && this.isPosTokenMatched(token) ^ posNegation;
        }
        return !this.negation && this.isPosTokenMatched(token) ^ posNegation;
    }

    public boolean isExceptionMatched(AnalyzedToken token) {
        if (this.exceptions != null && this.exceptions.currentAndNext != null) {
            for (PatternToken testException : this.exceptions.currentAndNext) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAndExceptionGroupMatched(AnalyzedToken token) {
        if (this.andGroupList == null) {
            return false;
        }
        for (PatternToken testAndGroup : this.andGroupList) {
            if (!testAndGroup.isExceptionMatched(token)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.isExceptionMatched(token) || this.isAndExceptionGroupMatched(token);
    }

    public void setAndGroupElement(PatternToken andToken) {
        if (this.andGroupList == null) {
            this.andGroupList = new ArrayList<PatternToken>(0);
        }
        this.andGroupList.add(Objects.requireNonNull(andToken));
    }

    public boolean hasAndGroup() {
        return this.andGroupList != null && this.andGroupList.size() > 0;
    }

    public List<PatternToken> getAndGroup() {
        return this.andGroupList == null ? Collections.emptyList() : Collections.unmodifiableList(this.andGroupList);
    }

    public void setOrGroupElement(PatternToken orToken) {
        if (this.orGroupList == null) {
            this.orGroupList = new ArrayList<PatternToken>(0);
        }
        this.orGroupList.add(Objects.requireNonNull(orToken));
    }

    public boolean hasOrGroup() {
        return this.orGroupList != null && this.orGroupList.size() > 0;
    }

    public List<PatternToken> getOrGroup() {
        return this.orGroupList == null ? Collections.emptyList() : Collections.unmodifiableList(this.orGroupList);
    }

    public boolean isMatchedByScopeNextException(AnalyzedToken token) {
        if (this.exceptions != null && this.exceptions.currentAndNext != null) {
            for (PatternToken testException : this.exceptions.currentAndNext) {
                if (!testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedToken token) {
        if (this.hasPreviousException()) {
            for (PatternToken testException : this.exceptions.previous) {
                if (testException.exceptionValidNext || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedTokenReadings prevToken) {
        for (AnalyzedToken analyzedToken : prevToken) {
            if (!this.isMatchedByPreviousException(analyzedToken)) continue;
            return true;
        }
        return false;
    }

    public boolean isSentenceStart() {
        return this.posToken != null && "SENT_START".equals(this.posToken.posTag) && !this.posToken.negation;
    }

    public void setPosToken(PosToken posToken) {
        this.posToken = posToken;
    }

    public void setChunkTag(ChunkTag chunkTag) {
        this.chunkTag = chunkTag;
    }

    public String getString() {
        return this.textMatcher.pattern;
    }

    public void setStringElement(String token) {
        this.setTextMatcher(StringMatcher.create(PatternToken.normalizeTextPattern(token), this.isRegularExpression(), this.isCaseSensitive()));
    }

    void setTextMatcher(@NotNull StringMatcher matcher) {
        this.textMatcher = matcher;
        this.testString = !StringTools.isEmpty(matcher.pattern);
    }

    static String normalizeTextPattern(String token) {
        return token == null ? "" : StringTools.trimWhitespace(token);
    }

    public void setStringPosException(String token, boolean regExp, boolean inflected, boolean negation, boolean scopeNext, boolean scopePrevious, String posToken, boolean posRegExp, boolean posNegation, Boolean caseSensitivity) {
        PatternToken exception = new PatternToken(token, caseSensitivity == null ? this.isCaseSensitive() : caseSensitivity.booleanValue(), regExp, inflected);
        exception.setNegation(negation);
        exception.setPosToken(new PosToken(posToken, posRegExp, posNegation));
        exception.exceptionValidNext = scopeNext;
        if (this.exceptions == null) {
            this.exceptions = new Exceptions();
        }
        this.exceptions.addException(exception, scopePrevious);
    }

    private boolean isPosTokenMatched(AnalyzedToken token) {
        PosToken pos = this.posToken;
        if (pos == null || pos.posTag == null || pos.posUnknown && token.hasNoTag()) {
            return true;
        }
        String tokenPos = token.getPOSTag();
        if (tokenPos == null) {
            return false;
        }
        return pos.posPattern != null ? pos.posPattern.matches(tokenPos) : pos.posTag.equals(tokenPos);
    }

    private String getTestToken(AnalyzedToken token) {
        if (this.inflected) {
            if (token.getLemma() != null) {
                return token.getLemma();
            }
            return token.getToken();
        }
        return token.getToken();
    }

    public int getSkipNext() {
        return this.skip;
    }

    public int getMinOccurrence() {
        return this.mayBeOmitted ? 0 : 1;
    }

    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public void setSkipNext(int i) {
        if (i < -1 || i > 127) {
            throw new IllegalArgumentException("'skip' should be between -1 and 127");
        }
        this.skip = (byte)i;
    }

    public void setMinOccurrence(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("minOccurrences must be 0 or 1: " + i);
        }
        this.mayBeOmitted = i == 0;
    }

    public void setMaxOccurrence(int i) {
        if (i == 0) {
            throw new IllegalArgumentException("maxOccurrences may not be 0");
        }
        if (i < -1 || i > 127) {
            throw new IllegalArgumentException("maxOccurrences should be between -1 and 127 but was: " + i);
        }
        this.maxOccurrence = (byte)i;
    }

    public boolean hasPreviousException() {
        return this.exceptions != null && this.exceptions.previous != null;
    }

    public boolean hasNextException() {
        return this.exceptionValidNext;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }

    public boolean getNegation() {
        return this.negation;
    }

    public boolean isReferenceElement() {
        return this.tokenReference != null;
    }

    public void setMatch(Match match) {
        this.tokenReference = Objects.requireNonNull(match);
    }

    public Match getMatch() {
        return this.tokenReference;
    }

    public PatternToken compile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        PatternToken compiledPatternToken;
        try {
            compiledPatternToken = (PatternToken)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone element", e);
        }
        compiledPatternToken.doCompile(token, synth);
        return compiledPatternToken;
    }

    private void doCompile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        MatchState matchState = this.tokenReference.createState(synth, token);
        String reference = "\\" + this.tokenReference.getTokenRef();
        if (this.tokenReference.setsPos()) {
            String posReference = matchState.getTargetPosTag();
            if (posReference != null) {
                this.setPosToken(new PosToken(posReference, this.tokenReference.posRegExp(), this.negation));
            }
            this.setStringElement(this.getString().replace(reference, ""));
        } else {
            this.setStringElement(this.getString().replace(reference, matchState.toTokenString()));
        }
    }

    public void setPhraseName(String id) {
        this.phraseName = id;
    }

    public boolean isPartOfPhrase() {
        return this.phraseName != null;
    }

    public boolean isCaseSensitive() {
        return this.textMatcher.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.textMatcher.isRegExp;
    }

    public boolean isPOStagRegularExpression() {
        return this.posToken != null && this.posToken.posPattern != null;
    }

    @Nullable
    public String getPOStag() {
        return this.posToken != null ? this.posToken.posTag : null;
    }

    @Nullable
    public ChunkTag getChunkTag() {
        return this.chunkTag;
    }

    public boolean getPOSNegation() {
        return this.posToken != null && this.posToken.negation;
    }

    public boolean isInflected() {
        return this.inflected;
    }

    @Nullable
    public String getPhraseName() {
        return this.phraseName;
    }

    public boolean isUnified() {
        return this.unificationFeatures != null;
    }

    public void setUnification(Map<String, List<String>> uniFeatures) {
        this.unificationFeatures = Objects.requireNonNull(uniFeatures);
    }

    @Nullable
    public Map<String, List<String>> getUniFeatures() {
        return this.unificationFeatures;
    }

    public void setUniNegation() {
        this.uniNegation = true;
    }

    public boolean isUniNegated() {
        return this.uniNegation;
    }

    public boolean isLastInUnification() {
        return this.isLastUnified;
    }

    public void setLastInUnification() {
        this.isLastUnified = true;
    }

    public boolean isUnificationNeutral() {
        return this.unificationNeutral;
    }

    public void setUnificationNeutral() {
        this.unificationNeutral = true;
    }

    public void setWhitespaceBefore(boolean isWhite) {
        this.whitespaceBefore = isWhite;
        this.testWhitespace = true;
    }

    public boolean isInsideMarker() {
        return this.isInsideMarker;
    }

    public void setInsideMarker(boolean isInsideMarker) {
        this.isInsideMarker = isInsideMarker;
    }

    public void setExceptionSpaceBefore(boolean isWhite) {
        if (this.exceptions != null) {
            List list;
            List list2 = list = this.hasPreviousException() ? this.exceptions.previous : this.exceptions.currentAndNext;
            if (list != null) {
                ((PatternToken)list.get(list.size() - 1)).setWhitespaceBefore(isWhite);
            }
        }
    }

    public boolean isWhitespaceBefore(AnalyzedToken token) {
        return this.whitespaceBefore == token.isWhitespaceBefore();
    }

    @Nullable
    public List<PatternToken> getExceptionList() {
        return this.exceptions == null ? null : this.exceptions.currentAndNext;
    }

    public boolean hasExceptionList() {
        return this.exceptions != null;
    }

    @Nullable
    Set<String> calcFormHints() {
        return this.calcStringHints(false);
    }

    @Nullable
    Set<String> calcLemmaHints() {
        return this.calcStringHints(true);
    }

    private Set<String> calcStringHints(boolean inflected) {
        Set<String> result;
        block5: {
            block4: {
                Set<String> set = result = inflected != this.inflected ? null : this.calcOwnPossibleStringValues();
                if (result == null) {
                    return null;
                }
                if (this.andGroupList == null) break block4;
                result = new HashSet<String>(result);
                for (PatternToken token : this.andGroupList) {
                    Set<String> hints = token.calcStringHints(inflected);
                    if (hints == null) continue;
                    result.retainAll(hints);
                }
                break block5;
            }
            if (this.orGroupList == null) break block5;
            result = new HashSet<String>(result);
            for (PatternToken token : this.orGroupList) {
                Set<String> hints = token.calcStringHints(inflected);
                if (hints == null) {
                    return null;
                }
                result.addAll(hints);
            }
        }
        return result.isEmpty() ? null : result;
    }

    @Nullable
    private Set<String> calcOwnPossibleStringValues() {
        if (this.negation || !this.hasStringThatMustMatch()) {
            return null;
        }
        return this.textMatcher.getPossibleValues();
    }

    boolean hasStringThatMustMatch() {
        return this.tokenReference == null && !this.mayBeOmitted && !this.getString().isEmpty();
    }

    public String toString() {
        List<PatternToken> exceptionList;
        StringBuilder sb = new StringBuilder();
        if (this.negation) {
            sb.append('!');
        }
        sb.append(this.getString());
        if (this.phraseName != null) {
            sb.append(" {");
            sb.append(this.phraseName);
            sb.append('}');
        }
        if (this.posToken != null) {
            sb.append('/');
            sb.append(this.posToken);
        }
        if (this.chunkTag != null) {
            sb.append('/');
            sb.append(this.chunkTag);
        }
        if ((exceptionList = this.getExceptionList()) != null) {
            sb.append("/exceptions=");
            sb.append(exceptionList);
        }
        return sb.toString();
    }

    private static class Exceptions {
        private List<PatternToken> currentAndNext;
        private List<PatternToken> previous;

        private Exceptions() {
        }

        private void addException(PatternToken pToken, boolean scopePrevious) {
            if (scopePrevious) {
                if (this.previous == null) {
                    this.previous = new ArrayList<PatternToken>();
                }
                this.previous.add(pToken);
            } else {
                if (this.currentAndNext == null) {
                    this.currentAndNext = new ArrayList<PatternToken>();
                }
                this.currentAndNext.add(pToken);
            }
        }
    }

    public static class PosToken {
        private final String posTag;
        private final boolean negation;
        private final StringMatcher posPattern;
        private final boolean posUnknown;

        public PosToken(String posTag, boolean regExp, boolean negation) {
            this.posTag = posTag;
            this.negation = negation;
            if (regExp) {
                this.posPattern = StringMatcher.create(posTag, true, true);
                this.posUnknown = this.posPattern.matches(PatternToken.UNKNOWN_TAG);
            } else {
                this.posPattern = null;
                this.posUnknown = PatternToken.UNKNOWN_TAG.equals(posTag);
            }
        }

        public String toString() {
            return this.posTag;
        }
    }
}

