/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.LineExpander;

public class CompoundRuleData {
    private final Set<String> incorrectCompounds = new THashSet();
    private final Set<String> noDashSuggestion = new THashSet();
    private final Set<String> noDashLowerCaseSuggestion = new THashSet();
    private final Set<String> onlyDashSuggestion = new THashSet();
    private final LineExpander expander;

    public CompoundRuleData(String path) {
        this(new String[]{path});
    }

    public CompoundRuleData(String ... paths) {
        this((LineExpander)null, paths);
    }

    public CompoundRuleData(LineExpander expander, String ... paths) {
        this.expander = expander;
        for (String path : paths) {
            try {
                this.loadCompoundFile(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load compound data from " + path, e);
            }
        }
    }

    Set<String> getIncorrectCompounds() {
        return Collections.unmodifiableSet(this.incorrectCompounds);
    }

    Set<String> getNoDashSuggestion() {
        return Collections.unmodifiableSet(this.noDashSuggestion);
    }

    Set<String> getOnlyDashSuggestion() {
        return Collections.unmodifiableSet(this.onlyDashSuggestion);
    }

    Set<String> getNoDashLowerCaseSuggestion() {
        return Collections.unmodifiableSet(this.noDashLowerCaseSuggestion);
    }

    /*
     * WARNING - void declaration
     */
    private void loadCompoundFile(String path) throws IOException {
        List<String> lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            List<Object> expandedLines = new ArrayList<String>();
            if (this.expander != null) {
                expandedLines = this.expander.expandLine(line);
            } else {
                expandedLines.add(line);
            }
            for (String string : expandedLines) {
                void var7_7;
                String string2 = string.replace('-', ' ');
                this.validateLine(path, string2);
                if (string2.endsWith("+")) {
                    String string3 = this.removeLastCharacter(string2);
                    this.noDashSuggestion.add(string3);
                } else if (string2.endsWith("*")) {
                    String string4 = this.removeLastCharacter(string2);
                    this.onlyDashSuggestion.add(string4);
                } else if (string2.endsWith("?")) {
                    String string5 = this.removeLastCharacter(string2);
                    this.noDashSuggestion.add(string5);
                    this.noDashLowerCaseSuggestion.add(string5);
                } else if (string2.endsWith("$")) {
                    String string6 = this.removeLastCharacter(string2);
                    this.noDashLowerCaseSuggestion.add(string6);
                }
                this.incorrectCompounds.add((String)var7_7);
            }
        }
    }

    private void validateLine(String path, String line) {
        String[] parts = line.split(" ");
        if (parts.length == 1) {
            throw new IllegalArgumentException("Not a compound in file " + path + ": " + line);
        }
        if (parts.length > 5) {
            throw new IllegalArgumentException("Too many compound parts in file " + path + ": " + line + ", maximum allowed: " + 5);
        }
        if (this.incorrectCompounds.contains(line.toLowerCase())) {
            throw new IllegalArgumentException("Duplicated word in file " + path + ": " + line);
        }
    }

    private String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

