/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

public class DatabaseAccessLimitLogEntry
extends DatabaseLogEntry {
    private final Calendar date = Calendar.getInstance();
    private final String type;
    private final Long server;
    private final Long client;
    private final Long user;
    private final String reason;
    private final String referrer;
    private final String userAgent;

    DatabaseAccessLimitLogEntry(String type, Long server, Long client, Long user, String reason, String referrer, String userAgent) {
        this.type = type;
        this.server = server;
        this.client = client;
        this.user = user;
        this.referrer = referrer;
        this.userAgent = userAgent;
        this.reason = reason;
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("type", StringUtils.abbreviate(this.type, 64));
        parameters.put("date", ServerTools.getSQLDatetimeString(this.date));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("referrer", StringUtils.abbreviate(this.referrer, 128));
        parameters.put("user_agent", StringUtils.abbreviate(this.userAgent, 512));
        parameters.put("reason", StringUtils.abbreviate(this.reason, 512));
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.accessLimit";
    }
}

