/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.RetryMetricNames;
import io.github.resilience4j.retry.Retry;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractRetryMetrics
extends AbstractMetrics {
    protected final RetryMetricNames names;

    protected AbstractRetryMetrics(RetryMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractRetryMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, Retry retry) {
        List<Tag> customTags = this.mapToTagsList(retry.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, retry, customTags);
    }

    private void registerMetrics(MeterRegistry meterRegistry, Retry retry, List<Tag> customTags) {
        this.removeMetrics(meterRegistry, retry.getName());
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(FunctionCounter.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()).description("The number of successful calls without a retry attempt").tag("name", retry.getName()).tag("kind", "successful_without_retry").tags(customTags).register(meterRegistry).getId());
        idSet.add(FunctionCounter.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()).description("The number of successful calls after a retry attempt").tag("name", retry.getName()).tag("kind", "successful_with_retry").tags(customTags).register(meterRegistry).getId());
        idSet.add(FunctionCounter.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()).description("The number of failed calls without a retry attempt").tag("name", retry.getName()).tag("kind", "failed_without_retry").tags(customTags).register(meterRegistry).getId());
        idSet.add(FunctionCounter.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithRetryAttempt()).description("The number of failed calls after a retry attempt").tag("name", retry.getName()).tag("kind", "failed_with_retry").tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(retry.getName(), idSet);
    }

    @Deprecated
    public static class MetricNames
    extends RetryMetricNames {
    }
}

