/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.rules.ml.ProcessingServerGrpc;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.Pipeline;
import org.languagetool.server.PipelinePool;
import org.languagetool.server.PipelineSettings;
import org.languagetool.server.TextChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GRPCServer
extends ProcessingServerGrpc.ProcessingServerImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRPCServer.class);
    private PipelinePool pool;
    private UserConfig userConfig;
    private GlobalConfig globalConfig;

    public GRPCServer(HTTPServerConfig serverConfig) {
        this.pool = new PipelinePool(serverConfig, null, false);
        this.userConfig = new UserConfig();
        this.globalConfig = new GlobalConfig();
    }

    private PipelineSettings buildSettings(MLServerProto.ProcessingOptions options) {
        Language lang = Languages.getLanguageForShortCode(options.getLanguage());
        JLanguageTool.Level level = GRPCUtils.fromGRPC(options.getLevel());
        List<String> enabled = options.getEnabledRulesList().stream().collect(Collectors.toList());
        List<String> disabled = options.getDisabledRulesList().stream().collect(Collectors.toList());
        TextChecker.QueryParams params = new TextChecker.QueryParams(Collections.emptyList(), enabled, disabled, Collections.emptyList(), Collections.emptyList(), options.getEnabledOnly(), true, false, false, options.getPremium(), options.getTempOff(), JLanguageTool.Mode.ALL, level, null);
        return new PipelineSettings(lang, null, params, this.globalConfig, this.userConfig);
    }

    @Override
    public void analyze(MLServerProto.AnalyzeRequest request, StreamObserver<MLServerProto.AnalyzeResponse> responseObserver) {
        try {
            log.info("Handling analyze request");
            MLServerProto.AnalyzeResponse response = MLServerProto.AnalyzeResponse.newBuilder().build();
            responseObserver.onNext(response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.warn("Analyze request failed", e);
            responseObserver.onError(e);
        }
    }

    @Override
    public void process(MLServerProto.ProcessRequest request, StreamObserver<MLServerProto.ProcessResponse> responseObserver) {
        try {
            log.info("Handling process request: {}", (Object)request);
            PipelineSettings settings = this.buildSettings(request.getOptions());
            Pipeline pipeline = this.pool.getPipeline(settings);
            ArrayList rawMatches = new ArrayList();
            String text = request.getSentencesList().stream().map(s -> s.getText()).collect(Collectors.joining());
            List<RuleMatch> matches = pipeline.check(text, m -> rawMatches.add(m));
            MLServerProto.ProcessResponse response = MLServerProto.ProcessResponse.newBuilder().addAllRawMatches(rawMatches.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).addAllMatches(matches.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).build();
            responseObserver.onNext(response);
            log.info("Sending response: {}", (Object)response);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            log.warn("Process request failed", e);
            responseObserver.onError(e);
        }
    }

    public static void main(String[] args) throws Exception {
        HTTPServerConfig config = new HTTPServerConfig(args);
        GRPCServer instance = new GRPCServer(config);
        ExecutorService executor = Executors.newCachedThreadPool();
        Server server = ((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(config.getPort()).addService(instance)).executor(executor)).build();
        server.start();
        System.out.println("port=" + server.getPort());
        server.awaitTermination();
    }
}

