/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import morfologik.fsa.CFSA;
import morfologik.fsa.CFSA2;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;
import morfologik.tools.CliTool;
import morfologik.tools.ExitStatus;
import morfologik.tools.ValidateFileExists;

@Parameters(commandNames={"fsa_info"}, commandDescription="Print extra information about a compiled automaton file.")
public class FSAInfo
extends CliTool {
    @Parameter(names={"-i", "--input"}, description="The input automaton.", required=true, validateValueWith={ValidateFileExists.class})
    private Path input;

    FSAInfo() {
    }

    public FSAInfo(Path input) {
        this.input = FSAInfo.checkNotNull(input);
    }

    @Override
    public ExitStatus call() throws Exception {
        FSA fsa;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(this.input, new OpenOption[0]));){
            fsa = FSA.read((InputStream)is);
        }
        FSAInfo.printf("%-25s : %s", "FSA implementation", fsa.getClass().getName());
        FSAInfo.printf("%-25s : %s", "Compiled with flags", fsa.getFlags().toString());
        morfologik.fsa.builders.FSAInfo info = new morfologik.fsa.builders.FSAInfo(fsa);
        FSAInfo.printf("%-25s : %,d", "Number of arcs (merged)", info.arcsCount);
        FSAInfo.printf("%-25s : %,d", "Number of arcs (total)", info.arcsCountTotal);
        FSAInfo.printf("%-25s : %,d", "Number of nodes", info.nodeCount);
        FSAInfo.printf("%-25s : %,d", "Number of final states", info.finalStatesCount);
        FSAInfo.printf("", new Object[0]);
        if (fsa instanceof FSA5) {
            FSA5 fsa5 = (FSA5)fsa;
            FSAInfo.printf("%-25s : %d", "Goto length (GTL)", fsa5.gtl);
            FSAInfo.printf("%-25s : %d", "Node extra data", fsa5.nodeDataLength);
            FSAInfo.printf("%-25s : %s", "Annotation separator", FSAInfo.byteAsChar(fsa5.annotation));
            FSAInfo.printf("%-25s : %s", "Filler character", FSAInfo.byteAsChar(fsa5.filler));
        }
        if (fsa instanceof CFSA) {
            CFSA cfsa = (CFSA)fsa;
            FSAInfo.printf("%-25s : %d", "Goto length (GTL)", cfsa.gtl);
            FSAInfo.printf("%-25s : %d", "Node extra data", cfsa.nodeDataLength);
        }
        if (fsa instanceof CFSA2) {
            CFSA2 cfsa2 = (CFSA2)fsa;
            byte[] labelMapping = cfsa2.labelMapping;
            if (labelMapping != null && labelMapping.length > 0) {
                FSAInfo.printf("%-25s :", "Label mapping");
                for (int i = 0; i < labelMapping.length; ++i) {
                    FSAInfo.printf("%-25s   %2d -> %s", "", i, FSAInfo.byteAsChar(labelMapping[i]));
                }
            }
        }
        return ExitStatus.SUCCESS;
    }

    static String byteAsChar(byte v) {
        int chr = v & 0xFF;
        return String.format(Locale.ROOT, "%s (0x%02x)", Character.isWhitespace(chr) || chr > 127 ? "[non-printable]" : Character.toString((char)chr), v & 0xFF);
    }

    public static void main(String[] args) {
        FSAInfo.main(args, (CliTool)new FSAInfo());
    }
}

