/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.HighlightPainter;
import org.languagetool.gui.LanguageToolEvent;
import org.languagetool.gui.LanguageToolListener;
import org.languagetool.gui.Tools;
import org.languagetool.gui.UndoRedoSupport;
import org.languagetool.language.identifier.LanguageIdentifier;
import org.languagetool.language.identifier.LanguageIdentifierService;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

class LanguageToolSupport {
    static final String CONFIG_FILE = ".languagetool.cfg";
    private static final int MAX_RULES_NO_CATEGORY_MENU = 12;
    private static final int MAX_RULES_PER_MENU = 12;
    private static final int MAX_CATEGORIES_PER_MENU = 12;
    private final UndoRedoSupport undo;
    private final LanguageIdentifier langIdentifier;
    private final JFrame frame;
    private final JTextComponent textComponent;
    private final EventListenerList listenerList = new EventListenerList();
    private final ResourceBundle messages;
    private final List<RuleMatch> ruleMatches;
    private final List<Span> documentSpans;
    private MultiThreadedJLanguageTool languageTool;
    private ScheduledExecutorService checkExecutor;
    private MouseListener mouseListener;
    private ActionListener actionListener;
    private int millisecondDelay = 1500;
    private AtomicInteger check;
    private boolean popupMenuEnabled = true;
    private boolean backgroundCheckEnabled = true;
    private Configuration config;
    private boolean mustDetectLanguage = false;

    LanguageToolSupport(JFrame frame, JTextComponent textComponent) {
        this(frame, textComponent, null);
    }

    LanguageToolSupport(JFrame frame, JTextComponent textComponent, UndoRedoSupport support) {
        this.frame = frame;
        this.textComponent = textComponent;
        this.messages = JLanguageTool.getMessageBundle();
        this.ruleMatches = new ArrayList<RuleMatch>();
        this.documentSpans = new ArrayList<Span>();
        this.undo = support;
        this.langIdentifier = LanguageIdentifierService.INSTANCE.getDefaultLanguageIdentifier(0, null, null, null);
        this.init();
    }

    void addLanguageToolListener(LanguageToolListener ltListener) {
        this.listenerList.add(LanguageToolListener.class, ltListener);
    }

    void removeLanguageToolListener(LanguageToolListener ltListener) {
        this.listenerList.remove(LanguageToolListener.class, ltListener);
    }

    private void fireEvent(LanguageToolEvent.Type type, Object caller, long elapsedTime) {
        LanguageToolEvent event = new LanguageToolEvent(this, type, caller, elapsedTime);
        this.fireEvent(event);
    }

    private void fireEvent(LanguageToolEvent.Type type, Object caller) {
        LanguageToolEvent event = new LanguageToolEvent(this, type, caller);
        this.fireEvent(event);
    }

    private void fireEvent(LanguageToolEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LanguageToolListener.class) continue;
            ((LanguageToolListener)listeners[i + 1]).languageToolEventOccurred(event);
        }
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    List<RuleMatch> getMatches() {
        return this.ruleMatches;
    }

    void reloadConfig() {
        Set<String> enabledRules;
        boolean update = false;
        Language language = this.languageTool.getLanguage();
        this.languageTool = new MultiThreadedJLanguageTool(language, this.config.getMotherTongue(), new UserConfig(this.config.getConfigurableValues()));
        this.config.initStyleCategories(this.languageTool.getAllRules());
        Set<String> disabledRules = this.config.getDisabledRuleIds();
        if (disabledRules == null) {
            disabledRules = Collections.emptySet();
        }
        HashSet<String> common = new HashSet<String>(disabledRules);
        common.retainAll(this.languageTool.getDisabledRules());
        HashSet<String> toDisable = new HashSet<String>(disabledRules);
        toDisable.removeAll(common);
        HashSet<String> toEnable = new HashSet<String>(this.languageTool.getDisabledRules());
        toEnable.removeAll(common);
        for (String ruleId : toDisable) {
            this.languageTool.disableRule(ruleId);
            update = true;
        }
        for (String ruleId : toEnable) {
            this.languageTool.enableRule(ruleId);
            update = true;
        }
        Set<String> disabledCategoryNames = this.config.getDisabledCategoryNames();
        if (disabledCategoryNames == null) {
            disabledCategoryNames = Collections.emptySet();
        }
        HashSet<CategoryId> disabledCategories = new HashSet<CategoryId>();
        Map<CategoryId, Category> langCategories = this.languageTool.getCategories();
        for (CategoryId categoryId : langCategories.keySet()) {
            String categoryName = langCategories.get(categoryId).getName();
            if (!disabledCategoryNames.contains(categoryName)) continue;
            disabledCategories.add(categoryId);
        }
        HashSet<CategoryId> ltDisabledCategories = new HashSet<CategoryId>();
        for (CategoryId id : langCategories.keySet()) {
            if (!this.languageTool.isCategoryDisabled(id)) continue;
            ltDisabledCategories.add(id);
        }
        HashSet hashSet = new HashSet(disabledCategories);
        hashSet.retainAll(ltDisabledCategories);
        HashSet toDisableCat = new HashSet(disabledCategories);
        toDisableCat.removeAll(hashSet);
        HashSet toEnableCat = new HashSet(ltDisabledCategories);
        toEnableCat.removeAll(hashSet);
        for (CategoryId id : toDisableCat) {
            this.languageTool.disableCategory(id);
        }
        for (CategoryId id : toEnableCat) {
            this.languageTool.enableRuleCategory(id);
        }
        if (!toDisableCat.isEmpty() || !toEnableCat.isEmpty()) {
            update = true;
        }
        if ((enabledRules = this.config.getEnabledRuleIds()) == null) {
            enabledRules = Collections.emptySet();
        }
        for (String ruleName : enabledRules) {
            this.languageTool.enableRule(ruleName);
            update = true;
        }
        if (update) {
            this.checkImmediately(null);
            this.fireEvent(LanguageToolEvent.Type.RULE_ENABLED, null);
        }
    }

    private void reloadLanguageTool(Language language) {
        try {
            this.config = new Configuration(new File(System.getProperty("user.home")), CONFIG_FILE, language);
            this.config.setLanguage(language);
            this.languageTool = new MultiThreadedJLanguageTool(language, this.config.getMotherTongue(), new UserConfig(this.config.getConfigurableValues()));
            this.config.initStyleCategories(this.languageTool.getAllRules());
            this.languageTool.setCleanOverlappingMatches(false);
            Tools.configureFromRules(this.languageTool, this.config);
            this.activateLanguageModelRules(language);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void activateLanguageModelRules(Language language) {
        if (this.config.getNgramDirectory() != null) {
            File ngramLangDir = new File(this.config.getNgramDirectory(), language.getShortCode());
            if (ngramLangDir.exists()) {
                try {
                    this.languageTool.activateLanguageModelRules(this.config.getNgramDirectory());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error while loading ngram database.\n" + e.getMessage());
                }
            } else {
                System.err.println("Not loading ngram data, directory does not exist: " + ngramLangDir);
            }
        }
    }

    private void init() {
        try {
            this.config = new Configuration(new File(System.getProperty("user.home")), CONFIG_FILE, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load configuration", ex);
        }
        Language defaultLanguage = this.config.getLanguage();
        if (defaultLanguage == null) {
            defaultLanguage = Languages.getLanguageForLocale(Locale.getDefault());
        }
        this.reloadLanguageTool(defaultLanguage);
        this.checkExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setPriority(1);
                t.setName(t.getName() + "-lt-background");
                return t;
            }
        });
        this.check = new AtomicInteger(0);
        this.textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LanguageToolSupport.this.mustDetectLanguage = LanguageToolSupport.this.config.getAutoDetect();
                LanguageToolSupport.this.recalculateSpans(e.getOffset(), e.getLength(), false);
                if (LanguageToolSupport.this.backgroundCheckEnabled) {
                    LanguageToolSupport.this.checkDelayed(null);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LanguageToolSupport.this.mustDetectLanguage = LanguageToolSupport.this.config.getAutoDetect();
                LanguageToolSupport.this.recalculateSpans(e.getOffset(), e.getLength(), true);
                if (LanguageToolSupport.this.backgroundCheckEnabled) {
                    LanguageToolSupport.this.checkDelayed(null);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LanguageToolSupport.this.mustDetectLanguage = LanguageToolSupport.this.config.getAutoDetect();
                if (LanguageToolSupport.this.backgroundCheckEnabled) {
                    LanguageToolSupport.this.checkDelayed(null);
                }
            }
        });
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    LanguageToolSupport.this.showPopup(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    LanguageToolSupport.this.showPopup(me);
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        };
        this.textComponent.addMouseListener(this.mouseListener);
        this.actionListener = e -> this._actionPerformed(e);
        this.mustDetectLanguage = this.config.getAutoDetect();
        if (!this.textComponent.getText().isEmpty() && this.backgroundCheckEnabled) {
            this.checkImmediately(null);
        }
    }

    public int getMillisecondDelay() {
        return this.millisecondDelay;
    }

    public void setMillisecondDelay(int millisecondDelay) {
        this.millisecondDelay = millisecondDelay;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean popupMenuEnabled) {
        if (this.popupMenuEnabled == popupMenuEnabled) {
            return;
        }
        this.popupMenuEnabled = popupMenuEnabled;
        if (popupMenuEnabled) {
            this.textComponent.addMouseListener(this.mouseListener);
        } else {
            this.textComponent.removeMouseListener(this.mouseListener);
        }
    }

    public boolean isBackgroundCheckEnabled() {
        return this.backgroundCheckEnabled;
    }

    public void setBackgroundCheckEnabled(boolean backgroundCheckEnabled) {
        if (this.backgroundCheckEnabled == backgroundCheckEnabled) {
            return;
        }
        this.backgroundCheckEnabled = backgroundCheckEnabled;
        if (backgroundCheckEnabled) {
            this.checkImmediately(null);
        }
    }

    public void setLanguage(Language language) {
        this.reloadLanguageTool(language);
        if (this.backgroundCheckEnabled) {
            this.checkImmediately(null);
        }
    }

    Language getLanguage() {
        return this.languageTool.getLanguage();
    }

    public Configuration getConfig() {
        return this.config;
    }

    JLanguageTool getLanguageTool() {
        return this.languageTool;
    }

    void disableRule(String ruleId) {
        Rule rule = this.getRuleForId(ruleId);
        if (rule == null) {
            return;
        }
        if (rule.isDefaultOff()) {
            this.config.getEnabledRuleIds().remove(ruleId);
        } else {
            this.config.getDisabledRuleIds().add(ruleId);
        }
        this.languageTool.disableRule(ruleId);
        this.updateHighlights(ruleId);
        this.fireEvent(LanguageToolEvent.Type.RULE_DISABLED, null);
    }

    void enableRule(String ruleId) {
        Rule rule = this.getRuleForId(ruleId);
        if (rule == null) {
            return;
        }
        if (rule.isDefaultOff()) {
            this.config.getEnabledRuleIds().add(ruleId);
        } else {
            this.config.getDisabledRuleIds().remove(ruleId);
        }
        this.languageTool.enableRule(ruleId);
        this.fireEvent(LanguageToolEvent.Type.RULE_ENABLED, null);
        this.checkImmediately(null);
    }

    @Nullable
    private Span getSpan(int offset) {
        for (Span cur : this.documentSpans) {
            if (cur.end <= cur.start || cur.start > offset || offset >= cur.end) continue;
            return cur;
        }
        return null;
    }

    private void showPopup(MouseEvent event) {
        List<Rule> disabledRules;
        if (this.documentSpans.isEmpty() && this.languageTool.getDisabledRules().isEmpty()) {
            return;
        }
        int offset = this.textComponent.viewToModel(event.getPoint());
        final Span span = this.getSpan(offset);
        JPopupMenu popup = new JPopupMenu("Grammar Menu");
        if (span != null) {
            JLabel msgItem = new JLabel("<html>" + span.msg.replace("<suggestion>", "<b>").replace("</suggestion>", "</b>") + "</html>");
            msgItem.setToolTipText(span.desc.replace("<suggestion>", "").replace("</suggestion>", ""));
            msgItem.setBorder(new JMenuItem().getBorder());
            popup.add(msgItem);
            popup.add(new JSeparator());
            for (String r : span.replacement) {
                ReplaceMenuItem item = new ReplaceMenuItem(r, span);
                popup.add(item);
                item.addActionListener(this.actionListener);
            }
            popup.add(new JSeparator());
            JMenuItem moreItem = new JMenuItem(this.messages.getString("guiMore"));
            moreItem.addActionListener(e -> this.showDialog(this.textComponent, span.msg, span.desc, span.rule, span.url));
            popup.add(moreItem);
            JMenuItem ignoreItem = new JMenuItem(this.messages.getString("guiTurnOffRule"));
            ignoreItem.addActionListener(e -> this.disableRule(span.rule.getId()));
            popup.add(ignoreItem);
            popup.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
        if (!(disabledRules = this.getDisabledRules()).isEmpty()) {
            JMenu activateRuleMenu = new JMenu(this.messages.getString("guiActivateRule"));
            this.addDisabledRulesToMenu(disabledRules, activateRuleMenu);
            popup.add(activateRuleMenu);
        }
        if (span != null) {
            this.textComponent.setCaretPosition(span.start);
            this.textComponent.moveCaretPosition(span.end);
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (span != null) {
                    LanguageToolSupport.this.textComponent.setCaretPosition(span.start);
                }
            }
        });
        popup.show(this.textComponent, event.getPoint().x, event.getPoint().y);
    }

    private List<Rule> getDisabledRules() {
        ArrayList<Rule> disabledRules = new ArrayList<Rule>();
        for (String ruleId : this.languageTool.getDisabledRules()) {
            Rule rule = this.getRuleForId(ruleId);
            if (rule == null || rule.isDefaultOff()) continue;
            disabledRules.add(rule);
        }
        Collections.sort(disabledRules, (r1, r2) -> r1.getDescription().compareTo(r2.getDescription()));
        return disabledRules;
    }

    private void addDisabledRulesToMenu(List<Rule> disabledRules, JMenu menu) {
        if (disabledRules.size() <= 12) {
            this.createRulesMenu(menu, disabledRules);
            return;
        }
        TreeMap categories = new TreeMap();
        for (Rule rule : disabledRules) {
            if (!categories.containsKey(rule.getCategory().getName())) {
                categories.put(rule.getCategory().getName(), new ArrayList());
            }
            ((ArrayList)categories.get(rule.getCategory().getName())).add(rule);
        }
        JMenu parent = menu;
        int count = 0;
        for (String category : categories.keySet()) {
            JMenu submenu = new JMenu(category);
            parent.add(submenu);
            this.createRulesMenu(submenu, (List)categories.get(category));
            if (categories.keySet().size() <= 12 || ++count % 11 != 0 || categories.keySet().size() - count <= 1) continue;
            JMenu more = new JMenu(this.messages.getString("guiActivateRuleMoreCategories"));
            parent.add(more);
            parent = more;
        }
    }

    private void createRulesMenu(JMenu parent, List<Rule> rules) {
        JMenu menu = parent;
        int count = 0;
        for (Rule rule : rules) {
            ++count;
            String id = rule.getId();
            JMenuItem ruleItem = new JMenuItem(rule.getDescription());
            ruleItem.addActionListener(e -> this.enableRule(id));
            menu.add(ruleItem);
            if (rules.size() <= 12 || count % 11 != 0 || rules.size() - count <= 1) continue;
            JMenu more = new JMenu(this.messages.getString("guiActivateRuleMoreRules"));
            menu.add(more);
            menu = more;
        }
    }

    @Nullable
    Rule getRuleForId(String ruleId) {
        List<Rule> allRules = this.languageTool.getAllRules();
        for (Rule rule : allRules) {
            if (!rule.getId().equals(ruleId)) continue;
            return rule;
        }
        return null;
    }

    private void _actionPerformed(ActionEvent e) {
        ReplaceMenuItem src = (ReplaceMenuItem)e.getSource();
        this.documentSpans.remove(src.span);
        this.applySuggestion(e.getActionCommand(), src.span.start, src.span.end);
    }

    private void applySuggestion(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start: " + end + " < " + start);
        }
        Document doc = this.textComponent.getDocument();
        if (doc != null) {
            try {
                if (this.undo != null) {
                    this.undo.startCompoundEdit();
                }
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (this.undo != null) {
                    this.undo.endCompoundEdit();
                }
            }
        }
    }

    public void checkDelayed() {
        this.checkDelayed(null);
    }

    public void checkDelayed(Object caller) {
        this.check.getAndIncrement();
        this.checkExecutor.schedule(new RunnableImpl(caller), (long)this.millisecondDelay, TimeUnit.MILLISECONDS);
    }

    public void checkImmediately() {
        this.checkImmediately(null);
    }

    public void checkImmediately(Object caller) {
        this.check.getAndIncrement();
        this.checkExecutor.schedule(new RunnableImpl(caller), 0L, TimeUnit.MILLISECONDS);
    }

    Language autoDetectLanguage(String text) {
        Language lang = this.langIdentifier.detectLanguage(text);
        if (lang == null) {
            lang = Languages.getLanguageForLocale(Locale.getDefault());
        }
        if (lang.hasVariant()) {
            lang = lang.getDefaultLanguageVariant();
        }
        return lang;
    }

    private synchronized List<RuleMatch> checkText(Object caller) throws IOException {
        if (this.mustDetectLanguage) {
            Language detectedLanguage;
            this.mustDetectLanguage = false;
            if (!this.textComponent.getText().isEmpty() && !(detectedLanguage = this.autoDetectLanguage(this.textComponent.getText())).equals(this.languageTool.getLanguage())) {
                this.reloadLanguageTool(detectedLanguage);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.fireEvent(LanguageToolEvent.Type.LANGUAGE_CHANGED, caller);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(() -> this.fireEvent(LanguageToolEvent.Type.LANGUAGE_CHANGED, caller));
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireEvent(LanguageToolEvent.Type.CHECKING_STARTED, caller);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.fireEvent(LanguageToolEvent.Type.CHECKING_STARTED, caller));
            }
            catch (InterruptedException detectedLanguage) {
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        long startTime = System.currentTimeMillis();
        List<RuleMatch> matches = this.languageTool.check(this.textComponent.getText());
        long elapsedTime = System.currentTimeMillis() - startTime;
        int v = this.check.get();
        if (v == 0) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> {
                    this.updateHighlights(matches);
                    this.fireEvent(LanguageToolEvent.Type.CHECKING_FINISHED, caller, elapsedTime);
                });
            } else {
                this.updateHighlights(matches);
                this.fireEvent(LanguageToolEvent.Type.CHECKING_FINISHED, caller, elapsedTime);
            }
        }
        return matches;
    }

    private void removeHighlights() {
        for (Highlighter.Highlight hl : this.textComponent.getHighlighter().getHighlights()) {
            if (!(hl.getPainter() instanceof HighlightPainter)) continue;
            this.textComponent.getHighlighter().removeHighlight(hl);
        }
    }

    private void recalculateSpans(int offset, int length, boolean remove) {
        if (length == 0) {
            return;
        }
        for (Span span : this.documentSpans) {
            Span span2;
            if (offset >= span.end) continue;
            if (!remove) {
                if (offset <= span.start) {
                    span2 = span;
                    span2.start = span2.start + length;
                }
                span2 = span;
                span2.end = span2.end + length;
                continue;
            }
            if (offset + length <= span.end) {
                if (offset <= span.start) {
                    if (offset + length <= span.start) {
                        span2 = span;
                        span2.start = span2.start - length;
                    } else {
                        span.start = offset;
                    }
                }
                span2 = span;
                span2.end = span2.end - length;
                continue;
            }
            span2 = span;
            span2.end = span2.end - Math.min(length, span.end - offset);
        }
        this.updateHighlights();
    }

    private void updateHighlights(String disabledRule) {
        ArrayList<Span> spans = new ArrayList<Span>();
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        for (RuleMatch match : this.ruleMatches) {
            if (match.getRule().getId().equals(disabledRule)) continue;
            matches.add(match);
            spans.add(new Span(match));
        }
        this.prepareUpdateHighlights(matches, spans);
    }

    private void updateHighlights(List<RuleMatch> matches) {
        ArrayList<Span> spans = new ArrayList<Span>();
        for (RuleMatch match : matches) {
            spans.add(new Span(match));
        }
        this.prepareUpdateHighlights(matches, spans);
    }

    private void prepareUpdateHighlights(List<RuleMatch> matches, List<Span> spans) {
        this.ruleMatches.clear();
        this.documentSpans.clear();
        this.ruleMatches.addAll(matches);
        this.documentSpans.addAll(spans);
        this.updateHighlights();
    }

    private void updateHighlights() {
        this.removeHighlights();
        Highlighter h = this.textComponent.getHighlighter();
        for (Span span : this.documentSpans) {
            if (span.start == span.end) continue;
            try {
                if (span.start >= span.end) continue;
                ITSIssueType issueType = span.rule.getLocQualityIssueType();
                Color ulColor = this.config.getUnderlineColor(span.rule.getCategory().getName(), span.rule.getId());
                Color colorForIssueType = this.getConfig().getErrorColors().get((Object)issueType);
                Color underlineColor = ITSIssueType.Misspelling == span.rule.getLocQualityIssueType() ? Color.red : ulColor;
                HighlightPainter painter = new HighlightPainter(colorForIssueType, underlineColor);
                h.addHighlight(span.start, span.end, painter);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void showDialog(Component parent, String title, String message, Rule rule, URL url) {
        Tools.showRuleInfoDialog(parent, title, message, rule, url, this.messages, this.languageTool.getLanguage().getShortCodeWithCountryAndVariant());
    }

    private class RunnableImpl
    implements Runnable {
        private final Object caller;

        private RunnableImpl(Object caller) {
            this.caller = caller;
        }

        @Override
        public void run() {
            int v = LanguageToolSupport.this.check.decrementAndGet();
            if (v != 0) {
                return;
            }
            try {
                LanguageToolSupport.this.checkText(this.caller);
            }
            catch (Exception ex) {
                Tools.showError(ex);
            }
        }
    }

    private static class Span {
        private static final int MAX_SUGGESTIONS = 5;
        private int start;
        private int end;
        private final String msg;
        private final String desc;
        private final List<String> replacement;
        private final Rule rule;
        private final URL url;

        private Span(RuleMatch match) {
            this.start = match.getFromPos();
            this.end = match.getToPos();
            String tmp = match.getShortMessage();
            if (StringUtils.isEmpty(tmp)) {
                tmp = match.getMessage();
            }
            this.msg = Tools.shortenComment(tmp);
            this.desc = match.getMessage();
            this.replacement = new ArrayList<String>();
            List<String> repl = match.getSuggestedReplacements();
            this.replacement.addAll(repl.subList(0, Math.min(5, repl.size())));
            this.rule = match.getRule();
            this.url = match.getUrl() != null ? match.getUrl() : this.rule.getUrl();
        }
    }

    private static class ReplaceMenuItem
    extends JMenuItem {
        private final Span span;

        private ReplaceMenuItem(String name, Span span) {
            super(name);
            this.span = span;
        }
    }
}

