/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.SaxWriter;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamMarshaller
extends AbstractMarshaller
implements InitializingBean,
BeanClassLoaderAware {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final XStream xstream = new XStream();
    private HierarchicalStreamDriver streamDriver;
    private String encoding = "UTF-8";
    private Class<?>[] supportedClasses;
    private ClassLoader beanClassLoader;

    public XStream getXStream() {
        return this.xstream;
    }

    public void setMode(int mode) {
        this.getXStream().setMode(mode);
    }

    public void setConverters(ConverterMatcher ... converters) {
        for (int i = 0; i < converters.length; ++i) {
            if (converters[i] instanceof Converter) {
                this.getXStream().registerConverter((Converter)converters[i], i);
                continue;
            }
            if (converters[i] instanceof SingleValueConverter) {
                this.getXStream().registerConverter((SingleValueConverter)converters[i], i);
                continue;
            }
            throw new IllegalArgumentException("Invalid ConverterMatcher [" + converters[i] + "]");
        }
    }

    public void setAliases(Map<String, ?> aliases) throws ClassNotFoundException {
        Map<String, Class<?>> classMap = this.toClassMap(aliases);
        for (Map.Entry<String, Class<?>> entry : classMap.entrySet()) {
            this.getXStream().alias(entry.getKey(), entry.getValue());
        }
    }

    public void setAliasesByType(Map<String, ?> aliases) throws ClassNotFoundException {
        Map<String, Class<?>> classMap = this.toClassMap(aliases);
        for (Map.Entry<String, Class<?>> entry : classMap.entrySet()) {
            this.getXStream().aliasType(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Class<?>> toClassMap(Map<String, ?> map) throws ClassNotFoundException {
        LinkedHashMap result = new LinkedHashMap(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Class type;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Class) {
                type = (Class)value;
            } else if (value instanceof String) {
                String className = (String)value;
                type = ClassUtils.forName((String)className, (ClassLoader)this.beanClassLoader);
            } else {
                throw new IllegalArgumentException("Unknown value [" + value + "] - expected String or Class");
            }
            result.put(key, type);
        }
        return result;
    }

    public void setFieldAliases(Map<String, String> aliases) throws ClassNotFoundException, NoSuchFieldException {
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            String alias = entry.getValue();
            String field = entry.getKey();
            int idx = field.lastIndexOf(46);
            if (idx != -1) {
                String className = field.substring(0, idx);
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)this.beanClassLoader);
                String fieldName = field.substring(idx + 1);
                this.getXStream().aliasField(alias, clazz, fieldName);
                continue;
            }
            throw new IllegalArgumentException("Field name [" + field + "] does not contain '.'");
        }
    }

    public void setUseAttributeForTypes(Class<?> ... types) {
        for (Class<?> type : types) {
            this.getXStream().useAttributeFor(type);
        }
    }

    public void setUseAttributeFor(Map<?, ?> attributes) {
        for (Map.Entry<?, ?> entry : attributes.entrySet()) {
            if (entry.getKey() instanceof String) {
                if (entry.getValue() instanceof Class) {
                    this.getXStream().useAttributeFor((String)entry.getKey(), (Class)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("'useAttributesFor' takes Map<String, Class> when using a map key of type String");
            }
            if (entry.getKey() instanceof Class) {
                Class key = (Class)entry.getKey();
                if (entry.getValue() instanceof String) {
                    this.getXStream().useAttributeFor(key, (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List listValue = (List)entry.getValue();
                    for (Object element : listValue) {
                        if (!(element instanceof String)) continue;
                        this.getXStream().useAttributeFor(key, (String)element);
                    }
                    continue;
                }
                throw new IllegalArgumentException("'useAttributesFor' property takes either Map<Class, String> or Map<Class, List<String>> when using a map key of type Class");
            }
            throw new IllegalArgumentException("'useAttributesFor' property takes either a map key of type String or Class");
        }
    }

    public void setImplicitCollections(Map<Class<?>, String> implicitCollections) {
        for (Map.Entry<Class<?>, String> entry : implicitCollections.entrySet()) {
            String[] collectionFields;
            for (String collectionField : collectionFields = StringUtils.commaDelimitedListToStringArray((String)entry.getValue())) {
                this.getXStream().addImplicitCollection(entry.getKey(), collectionField);
            }
        }
    }

    public void setOmittedFields(Map<Class<?>, String> omittedFields) {
        for (Map.Entry<Class<?>, String> entry : omittedFields.entrySet()) {
            String[] fields;
            for (String field : fields = StringUtils.commaDelimitedListToStringArray((String)entry.getValue())) {
                this.getXStream().omitField(entry.getKey(), field);
            }
        }
    }

    @Deprecated
    public void setAnnotatedClass(Class<?> annotatedClass) {
        Assert.notNull(annotatedClass, (String)"'annotatedClass' must not be null");
        this.getXStream().processAnnotations(annotatedClass);
    }

    public void setAnnotatedClasses(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"'annotatedClasses' must not be empty");
        this.getXStream().processAnnotations((Class[])annotatedClasses);
    }

    public void setAutodetectAnnotations(boolean autodetectAnnotations) {
        this.getXStream().autodetectAnnotations(autodetectAnnotations);
    }

    public void setStreamDriver(HierarchicalStreamDriver streamDriver) {
        this.streamDriver = streamDriver;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSupportedClasses(Class<?> ... supportedClasses) {
        this.supportedClasses = supportedClasses;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
        this.getXStream().setClassLoader(classLoader);
    }

    public final void afterPropertiesSet() throws Exception {
        this.customizeXStream(this.getXStream());
    }

    protected void customizeXStream(XStream xstream) {
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (ObjectUtils.isEmpty((Object[])this.supportedClasses)) {
            return true;
        }
        for (Class<?> supportedClass : this.supportedClasses) {
            if (!supportedClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        DomWriter streamWriter;
        if (node instanceof Document) {
            streamWriter = new DomWriter((Document)node);
        } else if (node instanceof Element) {
            streamWriter = new DomWriter((Element)node, node.getOwnerDocument(), new XmlFriendlyReplacer());
        } else {
            throw new IllegalArgumentException("DOMResult contains neither Document nor Element");
        }
        this.marshal(graph, (HierarchicalStreamWriter)streamWriter);
    }

    @Override
    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLEventWriter)eventWriter);
        this.marshalSaxHandlers(graph, contentHandler, null);
    }

    @Override
    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        try {
            this.marshal(graph, (HierarchicalStreamWriter)new StaxWriter(new QNameMap(), streamWriter));
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, true);
        }
    }

    @Override
    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            this.marshal(graph, this.streamDriver.createWriter(outputStream));
        } else {
            this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.encoding));
        }
    }

    @Override
    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        SaxWriter saxWriter = new SaxWriter();
        saxWriter.setContentHandler(contentHandler);
        this.marshal(graph, (HierarchicalStreamWriter)saxWriter);
    }

    @Override
    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            this.marshal(graph, this.streamDriver.createWriter(writer));
        } else {
            this.marshal(graph, (HierarchicalStreamWriter)new CompactWriter(writer));
        }
    }

    private void marshal(Object graph, HierarchicalStreamWriter streamWriter) {
        try {
            this.getXStream().marshal(graph, streamWriter);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, true);
        }
        finally {
            try {
                streamWriter.flush();
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Could not flush HierarchicalStreamWriter", (Throwable)ex);
            }
        }
    }

    @Override
    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        DomReader streamReader;
        if (node instanceof Document) {
            streamReader = new DomReader((Document)node);
        } else if (node instanceof Element) {
            streamReader = new DomReader((Element)node);
        } else {
            throw new IllegalArgumentException("DOMSource contains neither Document nor Element");
        }
        return this.unmarshal((HierarchicalStreamReader)streamReader);
    }

    @Override
    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        try {
            XMLStreamReader streamReader = StaxUtils.createEventStreamReader((XMLEventReader)eventReader);
            return this.unmarshalXmlStreamReader(streamReader);
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    @Override
    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        return this.unmarshal((HierarchicalStreamReader)new StaxReader(new QNameMap(), streamReader));
    }

    @Override
    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            return this.unmarshal(this.streamDriver.createReader(inputStream));
        }
        return this.unmarshalReader(new InputStreamReader(inputStream, this.encoding));
    }

    @Override
    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            return this.unmarshal(this.streamDriver.createReader(reader));
        }
        return this.unmarshal((HierarchicalStreamReader)new XppReader(reader));
    }

    @Override
    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        throw new UnsupportedOperationException("XStreamMarshaller does not support unmarshalling using SAX XMLReaders");
    }

    private Object unmarshal(HierarchicalStreamReader streamReader) {
        try {
            return this.getXStream().unmarshal(streamReader);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    protected XmlMappingException convertXStreamException(Exception ex, boolean marshalling) {
        if (ex instanceof StreamException || ex instanceof CannotResolveClassException || ex instanceof ConversionException) {
            if (marshalling) {
                return new MarshallingFailureException("XStream marshalling exception", ex);
            }
            return new UnmarshallingFailureException("XStream unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown XStream exception", ex);
    }
}

