/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.CancelableProgressMonitor;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.internal.Accessor;

public class GetRepositoryTasksCommand
extends BugtrackingCommand {
    private String stringValue;
    private final TaskRepository taskRepository;
    private final Set<String> taskIds;
    private final CancelableProgressMonitor monitor;
    private final TaskDataManager taskDataManager;
    private final AbstractRepositoryConnector connector;
    private final List<NbTask> tasks = new ArrayList<NbTask>();

    GetRepositoryTasksCommand(AbstractRepositoryConnector connector, TaskRepository taskRepository, Set<String> taskIds, TaskDataManager taskDataManager) {
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.taskIds = taskIds;
        this.taskDataManager = taskDataManager;
        this.monitor = new CancelableProgressMonitor();
    }

    @Override
    public void execute() throws CoreException, IOException, MalformedURLException {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing GetRepositoryTasksCommand for task ids {0}:{1}", new Object[]{this.taskRepository.getUrl(), this.taskIds});
        }
        if (this.taskIds.size() == 1 || !this.connector.getTaskDataHandler().canGetMultiTaskData(this.taskRepository)) {
            for (String taskId : this.taskIds) {
                TaskData taskData = this.connector.getTaskData(this.taskRepository, taskId, (IProgressMonitor)this.monitor);
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (taskData == null) continue;
                Accessor acc = Accessor.getInstance();
                NbTask task = acc.getOrCreateTask(this.taskRepository, taskData.getTaskId(), true);
                this.taskDataManager.putUpdatedTaskData(acc.getDelegate(task), taskData, true);
                this.tasks.add(task);
            }
        } else {
            this.connector.getTaskDataHandler().getMultiTaskData(this.taskRepository, this.taskIds, (TaskDataCollector)new Collector(), (IProgressMonitor)this.monitor);
        }
    }

    @Override
    public void cancel() {
        this.monitor.setCanceled(true);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder().append("Getting tasks ").append(this.taskIds).append(",repository=").append(this.taskRepository.getUrl()).append("]");
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public List<NbTask> getTasks() {
        return this.tasks;
    }

    private class Collector
    extends TaskDataCollector {
        private Collector() {
        }

        public void accept(TaskData taskData) {
            try {
                Accessor acc = Accessor.getInstance();
                NbTask task = acc.getOrCreateTask(GetRepositoryTasksCommand.this.taskRepository, taskData.getTaskId(), true);
                GetRepositoryTasksCommand.this.taskDataManager.putUpdatedTaskData(acc.getDelegate(task), taskData, true);
                GetRepositoryTasksCommand.this.tasks.add(task);
            }
            catch (CoreException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, null, ex);
            }
        }
    }
}

