/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.impl.webservices.WebServicesProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private Map ddMap = new HashMap(5);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public synchronized Webservices getDDRoot(FileObject fo) throws IOException {
        WebServicesProxy webSvcProxy;
        block5: {
            if (fo == null) {
                return null;
            }
            webSvcProxy = this.getFromCache(fo);
            if (webSvcProxy != null) {
                return webSvcProxy;
            }
            fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent evt) {
                    block9: {
                        FileObject fo = evt.getFile();
                        try {
                            WebServicesProxy webSvcProxy = DDProvider.this.getFromCache(fo);
                            String version = null;
                            if (webSvcProxy == null) break block9;
                            try {
                                DDParse parseResult = DDProvider.this.parseDD(fo);
                                version = parseResult.getVersion();
                                DDProvider.setProxyErrorStatus(webSvcProxy, parseResult);
                                Webservices newValue = DDProvider.createWebSvcJar(parseResult);
                                if (!version.equals(webSvcProxy.getVersion().toString())) {
                                    webSvcProxy.setOriginal(newValue);
                                    break block9;
                                }
                                if (webSvcProxy.getOriginal() == null) {
                                    webSvcProxy.setOriginal(newValue);
                                    break block9;
                                }
                                webSvcProxy.getOriginal().merge(newValue, 3);
                            }
                            catch (SAXException ex) {
                                if (ex instanceof SAXParseException) {
                                    webSvcProxy.setError((SAXParseException)ex);
                                } else if (ex.getException() instanceof SAXParseException) {
                                    webSvcProxy.setError((SAXParseException)ex.getException());
                                }
                                webSvcProxy.setStatus(2);
                                webSvcProxy.setProxyVersion("1.1");
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            try {
                DDParse parseResult = this.parseDD(fo);
                Webservices original = DDProvider.createWebSvcJar(parseResult);
                webSvcProxy = new WebServicesProxy(original, parseResult.getVersion());
                DDProvider.setProxyErrorStatus(webSvcProxy, parseResult);
            }
            catch (SAXException ex) {
                webSvcProxy = new WebServicesProxy(org.netbeans.modules.j2ee.dd.impl.webservices.model_1_2.Webservices.createGraph(), "1.2");
                webSvcProxy.setStatus(2);
                if (ex instanceof SAXParseException) {
                    webSvcProxy.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block5;
                webSvcProxy.setError((SAXParseException)ex.getException());
            }
        }
        this.ddMap.put(fo, webSvcProxy);
        return webSvcProxy;
    }

    public Webservices getDDRootCopy(FileObject fo) throws IOException {
        return (Webservices)this.getDDRoot(fo).clone();
    }

    private WebServicesProxy getFromCache(FileObject fo) {
        return (WebServicesProxy)this.ddMap.get(fo);
    }

    public Webservices getDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        Webservices webSvcJar = DDProvider.createWebSvcJar(parse);
        WebServicesProxy proxy = new WebServicesProxy(webSvcJar, webSvcJar.getVersion().toString());
        DDProvider.setProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof WebServicesProxy) {
            return (BaseBean)((WebServicesProxy)bean).getOriginal();
        }
        return null;
    }

    private static void setProxyErrorStatus(WebServicesProxy webSvcProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        webSvcProxy.setError(error);
        if (error != null) {
            webSvcProxy.setStatus(1);
        } else {
            webSvcProxy.setStatus(0);
        }
    }

    private static Webservices createWebSvcJar(DDParse parse) throws SAXException {
        Webservices jar = null;
        String version = parse.getVersion();
        if ("1.1".equals(version)) {
            try {
                return new org.netbeans.modules.j2ee.dd.impl.webservices.model_1_1.Webservices(parse.getDocument(), 1);
            }
            catch (RuntimeException ex) {
                throw new SAXException(ex.getMessage());
            }
        }
        if ("1.2".equals(version)) {
            try {
                return new org.netbeans.modules.j2ee.dd.impl.webservices.model_1_2.Webservices(parse.getDocument(), 1);
            }
            catch (RuntimeException ex) {
                throw new SAXException(ex.getMessage());
            }
        }
        return jar;
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        DDParse parseResult = this.parseDD(fo);
        return parseResult.getWarning();
    }

    private DDParse parseDD(FileObject fo) throws SAXException, IOException {
        return this.parseDD(fo.getInputStream());
    }

    private DDParse parseDD(InputStream is) throws SAXException, IOException {
        return this.parseDD(new InputSource(is));
    }

    private DDParse parseDD(InputSource is) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document d = parser.parse(is);
        SAXParseException error = errorHandler.getError();
        return new DDParse(d, error);
    }

    private static class DDParse {
        private Document document;
        private SAXParseException saxException;
        private String version;

        public DDParse(Document d, SAXParseException saxEx) {
            this.document = d;
            this.saxException = saxEx;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            String ver = this.document.getDocumentElement().getAttribute("version");
            this.version = "1.1".equals(ver) ? "1.1" : "1.2";
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if ("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/j2ee_web_services_1_1.xsd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/j2ee_web_services_1_1.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/j2ee_web_services_1_1.xsd");
            }
            if ("http://www.ibm.com/webservices/xsd/javaee_web_services_1_2.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/javaee_web_services_1_2.xsd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/javaee_web_services_1_2.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/javaee_web_services_1_2.xsd");
            }
            return null;
        }
    }
}

