/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpointUtils;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.BreakpointException;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Breakpoint;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.modules.web.webkit.debugging.api.dom.NodeAnnotator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

abstract class WebKitBreakpointManager
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(WebKitBreakpointManager.class.getName());
    protected final Debugger d;
    private final org.netbeans.api.debugger.Breakpoint b;
    private static final RequestProcessor rp = new RequestProcessor(WebKitBreakpointManager.class);
    private static final Image DOM_BREAKPOINT_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/javascript/debugger/resources/DOMBreakpoint.png", (boolean)false);

    protected WebKitBreakpointManager(Debugger d, org.netbeans.api.debugger.Breakpoint b) {
        this.d = d;
        this.b = b;
        b.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static WebKitBreakpointManager create(Debugger d, ProjectContext pc, JSLineBreakpoint lb) {
        return new WebKitLineBreakpointManager(d, pc, lb);
    }

    public static WebKitBreakpointManager create(WebKitDebugging wd, ProjectContext pc, DOMBreakpoint db) {
        return new WebKitDOMBreakpointManager(wd, pc, db);
    }

    public static WebKitBreakpointManager create(Debugger d, EventsBreakpoint eb) {
        return new WebKitEventsBreakpointManager(d, eb);
    }

    public static WebKitBreakpointManager create(Debugger d, XHRBreakpoint xb) {
        return new WebKitXHRBreakpointManager(d, xb);
    }

    public boolean canAdd() {
        return this.b.isEnabled();
    }

    public abstract void add();

    public abstract void remove();

    public void notifySourceMap() {
    }

    public void destroy() {
        this.remove();
        this.b.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent event) {
        if (!"enabled".equals(event.getPropertyName())) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            rp.post(new Runnable(){

                @Override
                public void run() {
                    WebKitBreakpointManager.this.propertyChange(event);
                }
            });
            return;
        }
        org.netbeans.api.debugger.Breakpoint b = (org.netbeans.api.debugger.Breakpoint)event.getSource();
        if (b.isEnabled()) {
            this.add();
        } else {
            this.remove();
        }
    }

    private static List<org.netbeans.api.debugger.Breakpoint> checkDuplicateBreakpoints(JSLineBreakpoint lb, long lineNumber) {
        FileObject fo = lb.getFileObject();
        if (fo == null) {
            return null;
        }
        ArrayList<org.netbeans.api.debugger.Breakpoint> breakpointsToRemove = null;
        for (org.netbeans.api.debugger.Breakpoint b : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            FileObject tfo;
            JSLineBreakpoint tlb;
            if (!(b instanceof JSLineBreakpoint) || b == lb || (long)(tlb = (JSLineBreakpoint)b).getLineNumber() != lineNumber || !fo.equals(tfo = tlb.getFileObject()) || !WebKitBreakpointManager.compareBreakpointProperties(lb, tlb)) continue;
            if (breakpointsToRemove == null) {
                breakpointsToRemove = new ArrayList<org.netbeans.api.debugger.Breakpoint>();
            }
            breakpointsToRemove.add(b);
        }
        if (breakpointsToRemove != null) {
            for (int i = 0; i < breakpointsToRemove.size(); ++i) {
                org.netbeans.api.debugger.Breakpoint b = (org.netbeans.api.debugger.Breakpoint)breakpointsToRemove.get(i);
                if (Breakpoint.VALIDITY.INVALID != b.getValidity()) continue;
                DebuggerManager.getDebuggerManager().removeBreakpoint(b);
                breakpointsToRemove.remove(b);
                --i;
            }
            if (breakpointsToRemove.isEmpty()) {
                breakpointsToRemove = null;
            }
        }
        return breakpointsToRemove;
    }

    private static boolean compareBreakpointProperties(JSLineBreakpoint lb1, JSLineBreakpoint lb2) {
        String gn1 = lb1.getGroupName();
        String gn2 = lb2.getGroupName();
        return !(gn1 != null && !gn1.equals(gn2) || gn1 == null && gn2 != null || lb1.getHitCountFilter() != lb2.getHitCountFilter()) && lb1.getHitCountFilteringStyle() == lb2.getHitCountFilteringStyle();
    }

    private static final class WebKitXHRBreakpointManager
    extends WebKitBreakpointManager {
        private final XHRBreakpoint xb;
        private Breakpoint b;
        private String lastUrlSubstring;

        public WebKitXHRBreakpointManager(Debugger d, XHRBreakpoint xb) {
            super(d, xb);
            this.xb = xb;
        }

        @Override
        public void add() {
            if (this.b != null) {
                return;
            }
            String urlSubstring = this.xb.getUrlSubstring();
            this.b = this.d.addXHRBreakpoint(urlSubstring);
            this.lastUrlSubstring = urlSubstring;
        }

        @Override
        public void remove() {
            if (this.b == null) {
                return;
            }
            if (this.d.isEnabled()) {
                if (this.b.getBreakpointID() != null) {
                    this.d.removeLineBreakpoint(this.b);
                } else {
                    this.d.removeXHRBreakpoint(this.lastUrlSubstring);
                }
            }
            this.b = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("urlSubstring".equals(event.getPropertyName())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    rp.post(new Runnable(){

                        @Override
                        public void run() {
                            this.remove();
                            this.add();
                        }
                    });
                    return;
                }
                this.remove();
                this.add();
            } else {
                super.propertyChange(event);
            }
        }
    }

    private static final class WebKitEventsBreakpointManager
    extends WebKitBreakpointManager {
        private EventsBreakpoint eb;
        private Map<String, Breakpoint> bps;

        public WebKitEventsBreakpointManager(Debugger d, EventsBreakpoint eb) {
            super(d, eb);
            this.eb = eb;
        }

        @Override
        public void add() {
            Set<String> events = this.eb.getEvents();
            this.bps = new HashMap<String, Breakpoint>(events.size());
            for (String event : events) {
                Breakpoint b = this.eb.isInstrumentationEvent(event) ? this.d.addInstrumentationBreakpoint(event) : this.d.addEventBreakpoint(event);
                if (b == null) continue;
                this.bps.put(event, b);
            }
        }

        @Override
        public void remove() {
            if (this.bps == null) {
                return;
            }
            if (this.d.isEnabled()) {
                boolean removed = true;
                for (Breakpoint b : this.bps.values()) {
                    if (b.getBreakpointID() != null) {
                        this.d.removeLineBreakpoint(b);
                        continue;
                    }
                    removed = false;
                }
                if (!removed) {
                    Set<String> events = this.eb.getEvents();
                    for (String event : events) {
                        if (this.eb.isInstrumentationEvent(event)) {
                            this.d.removeInstrumentationBreakpoint(event);
                            continue;
                        }
                        this.d.removeEventBreakpoint(event);
                    }
                }
            }
            this.bps = null;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            if (!this.eb.isEnabled()) {
                super.propertyChange(event);
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.propertyChange(event);
                    }
                });
                return;
            }
            String propertyName = event.getPropertyName();
            if ("events".equals(propertyName) && this.bps != null) {
                Object newValue = event.getNewValue();
                Object oldValue = event.getOldValue();
                if (newValue != null) {
                    String newEvent = (String)newValue;
                    Breakpoint b = this.eb.isInstrumentationEvent(newEvent) ? this.d.addInstrumentationBreakpoint(newEvent) : this.d.addEventBreakpoint(newEvent);
                    if (b != null) {
                        this.bps.put(newEvent, b);
                    }
                } else if (oldValue != null) {
                    String oldEvent = (String)oldValue;
                    Breakpoint b = this.bps.remove(oldEvent);
                    if (b != null) {
                        if (this.eb.isInstrumentationEvent(oldEvent)) {
                            this.d.removeInstrumentationBreakpoint(oldEvent);
                        } else {
                            this.d.removeEventBreakpoint(oldEvent);
                        }
                    }
                } else {
                    this.remove();
                    this.add();
                }
            } else {
                super.propertyChange(event);
            }
        }
    }

    private static final class WebKitDOMBreakpointManager
    extends WebKitBreakpointManager
    implements ChangeListener {
        private final WebKitDebugging wd;
        private final ProjectContext pc;
        private final DOMBreakpoint db;
        private Node node;
        private Map<Breakpoint, DOMBreakpoint.Type> bps;

        public WebKitDOMBreakpointManager(WebKitDebugging wd, ProjectContext pc, DOMBreakpoint db) {
            super(wd.getDebugger(), db);
            this.wd = wd;
            this.pc = pc;
            this.db = db;
            pc.addChangeSupport(this);
        }

        @Override
        public void add() {
            FileObject projectDirectory;
            URL urlBP;
            FileObject fo;
            if (this.bps != null) {
                return;
            }
            Project project = this.pc.getProject();
            if (project != null && (fo = URLMapper.findFileObject((URL)(urlBP = this.db.getURL()))) != null && !FileUtil.isParentOf((FileObject)(projectDirectory = project.getProjectDirectory()), (FileObject)fo)) {
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("WebKitDOMBreakpointManager.add(): breakpoint URL = '" + this.db.getURL() + "'");
            }
            DOMNode dn = this.db.getNode();
            dn.addPropertyChangeListener(this);
            try {
                dn.bindTo(this.wd.getDOM());
            }
            catch (DOMNode.PathNotFoundException pex) {
                this.db.setValidity(pex);
                return;
            }
            Node n = dn.getNode();
            if (n != null) {
                this.addTo(n);
            }
        }

        private void addTo(Node node) {
            this.node = node;
            Set<DOMBreakpoint.Type> types = this.db.getTypes();
            if (types.isEmpty()) {
                return;
            }
            this.bps = new HashMap<Breakpoint, DOMBreakpoint.Type>(types.size());
            boolean added = false;
            for (DOMBreakpoint.Type type : types) {
                Breakpoint b = this.d.addDOMBreakpoint(node, type.getTypeString());
                if (b == null) continue;
                added = true;
                this.bps.put(b, type);
            }
            if (added) {
                this.db.setValid(Bundle.MSG_DOM_BRKP_Resolved());
            } else {
                this.db.setInvalid(Bundle.MSG_DOM_BRKP_Unresolved());
            }
            NodeAnnotator.getDefault().annotate(node, DOM_BREAKPOINT_BADGE);
        }

        @Override
        public void remove() {
            DOMNode dn = this.db.getNode();
            dn.unbind();
            dn.removePropertyChangeListener(this);
            this.removeBreakpoints();
        }

        private void removeBreakpoints() {
            Node theNode = this.node;
            this.node = null;
            if (theNode != null) {
                this.removeBreakpoints(theNode);
            }
        }

        private void removeBreakpoints(Node theNode) {
            if (this.bps == null) {
                return;
            }
            if (this.d.isEnabled()) {
                for (Breakpoint b : this.bps.keySet()) {
                    if (b.getBreakpointID() != null) {
                        this.d.removeLineBreakpoint(b);
                        continue;
                    }
                    this.d.removeDOMBreakpoint(theNode, this.bps.get(b).getTypeString());
                }
                this.db.resetValidity();
            }
            this.bps = null;
            NodeAnnotator.getDefault().annotate(theNode, null);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent event) {
            if (SwingUtilities.isEventDispatchThread()) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.propertyChange(event);
                    }
                });
                return;
            }
            String propertyName = event.getPropertyName();
            if ("nodeChanged".equals(propertyName)) {
                Node newNode;
                Node oldNode = (Node)event.getOldValue();
                if (oldNode != null) {
                    this.removeBreakpoints();
                }
                if ((newNode = (Node)event.getNewValue()) != null) {
                    this.addTo(newNode);
                }
            } else if ("nodePathRequestFailed".equals(propertyName)) {
                this.removeBreakpoints();
                this.db.setValidity((DOMNode.PathNotFoundException)event.getNewValue());
            } else if ("types".equals(propertyName)) {
                Node theNode = this.node;
                if (theNode != null) {
                    this.removeBreakpoints(theNode);
                    this.addTo(theNode);
                }
            } else if ("node".equals(propertyName)) {
                DOMNode oldNode = (DOMNode)event.getOldValue();
                oldNode.unbind();
                oldNode.removePropertyChangeListener(this);
                this.removeBreakpoints();
                this.add();
            } else {
                super.propertyChange(event);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.remove();
            this.add();
        }
    }

    private static final class WebKitLineBreakpointManager
    extends WebKitBreakpointManager
    implements Debugger.Listener,
    ChangeListener {
        private final JSLineBreakpoint lb;
        private Breakpoint b;
        private SourceMapsTranslator.Location bCompiledLocation;
        private final Object brkptLock = new Object();
        private final AtomicBoolean lineChanged = new AtomicBoolean(false);
        private final AtomicBoolean resubmitting = new AtomicBoolean(false);
        private final ThreadLocal<Boolean> ignoreLineUpdate = new ThreadLocal();
        private ProjectContext pc;

        public WebKitLineBreakpointManager(Debugger d, ProjectContext pc, JSLineBreakpoint lb) {
            super(d, (org.netbeans.api.debugger.Breakpoint)lb);
            this.lb = lb;
            this.pc = pc;
            pc.addChangeSupport(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add() {
            Object object = this.brkptLock;
            synchronized (object) {
                if (this.b != null) {
                    return;
                }
            }
            SourceMapsTranslator.Location[] compiledLocPtr = new SourceMapsTranslator.Location[]{null};
            Breakpoint br = this.doAdd(compiledLocPtr);
            if (br != null) {
                br.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkBPValidity(br, compiledLocPtr[0]);
                Object object2 = this.brkptLock;
                synchronized (object2) {
                    this.b = br;
                    this.bCompiledLocation = compiledLocPtr[0];
                }
                this.d.addListener((Debugger.Listener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkBPValidity(Breakpoint br, SourceMapsTranslator.Location compiledLocation) {
            long brLine = br.getLineNumber();
            if (brLine >= 0L) {
                List duplicateBreakpoints;
                if (compiledLocation != null) {
                    SourceMapsTranslator.Location cLoc = new SourceMapsTranslator.Location(compiledLocation.getFile(), (int)brLine, (int)br.getColumnNumber());
                    SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(this.d);
                    SourceMapsTranslator.Location sLoc = smt.getSourceLocation(cLoc);
                    brLine = sLoc.getLine();
                }
                if ((duplicateBreakpoints = WebKitBreakpointManager.checkDuplicateBreakpoints(this.lb, brLine)) != null) {
                    for (int i = 1; i < duplicateBreakpoints.size(); ++i) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((org.netbeans.api.debugger.Breakpoint)duplicateBreakpoints.get(i));
                    }
                    Object object = this.brkptLock;
                    synchronized (object) {
                        this.b = br;
                        this.bCompiledLocation = compiledLocation;
                    }
                    DebuggerManager.getDebuggerManager().removeBreakpoint((org.netbeans.api.debugger.Breakpoint)this.lb);
                    return;
                }
                this.ignoreLineUpdate.set(Boolean.TRUE);
                try {
                    this.lb.setLine((int)brLine + 1);
                }
                finally {
                    this.ignoreLineUpdate.remove();
                }
                JSBreakpointStatus.setValid((JSLineBreakpoint)this.lb, (String)Bundle.MSG_BRKP_Resolved());
            } else {
                JSBreakpointStatus.setInvalid((JSLineBreakpoint)this.lb, (String)Bundle.MSG_BRKP_Unresolved());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Breakpoint brkpt;
            Object object = this.brkptLock;
            synchronized (object) {
                brkpt = this.b;
                if (brkpt == null) {
                    return;
                }
            }
            brkpt.removePropertyChangeListener((PropertyChangeListener)this);
            this.d.removeListener((Debugger.Listener)this);
            if (this.d.isEnabled()) {
                this.d.removeLineBreakpoint(brkpt);
            }
            object = this.brkptLock;
            synchronized (object) {
                this.b = null;
                this.bCompiledLocation = null;
            }
            JSBreakpointStatus.resetValidity((JSLineBreakpoint)this.lb);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resubmit() {
            Breakpoint brkpt;
            if (SwingUtilities.isEventDispatchThread()) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.resubmit();
                    }
                });
                return;
            }
            Object object = this.brkptLock;
            synchronized (object) {
                brkpt = this.b;
            }
            if (brkpt != null) {
                brkpt.removePropertyChangeListener((PropertyChangeListener)this);
                this.d.removeLineBreakpoint(brkpt);
                this.resubmitting.set(false);
                SourceMapsTranslator.Location[] compiledLocPtr = new SourceMapsTranslator.Location[]{null};
                brkpt = this.doAdd(compiledLocPtr);
                if (brkpt != null) {
                    brkpt.addPropertyChangeListener((PropertyChangeListener)this);
                    this.checkBPValidity(brkpt, compiledLocPtr[0]);
                }
                Object object2 = this.brkptLock;
                synchronized (object2) {
                    this.b = brkpt;
                    this.bCompiledLocation = compiledLocPtr[0];
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifySourceMap() {
            boolean hasCompiledLocation = false;
            Object object = this.brkptLock;
            synchronized (object) {
                hasCompiledLocation = this.bCompiledLocation != null;
            }
            if (!hasCompiledLocation) {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.resubmit();
                    }
                });
            }
        }

        private Breakpoint doAdd(SourceMapsTranslator.Location[] compiledLocPtr) {
            URL curl = this.d.getConnectionURL();
            if (curl != null && this.lb.getFileObject() != null) {
                SourceMapsTranslator.Location loc;
                SourceMapsTranslator.Location cloc;
                SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(this.d);
                if (smt != null && (cloc = smt.getCompiledLocation(loc = new SourceMapsTranslator.Location(this.lb.getFileObject(), this.lb.getLineNumber() - 1, 0))) != loc) {
                    if (compiledLocPtr != null) {
                        compiledLocPtr[0] = cloc;
                    }
                    String url = LineBreakpointUtils.getURLString(cloc.getFile(), this.pc.getProject(), curl);
                    url = WebKitLineBreakpointManager.reformatFileURL(url);
                    try {
                        return this.d.addLineBreakpoint(url, cloc.getLine(), Integer.valueOf(cloc.getColumn()), this.lb.getCondition());
                    }
                    catch (BreakpointException bex) {
                        JSBreakpointStatus.setInvalid((JSLineBreakpoint)this.lb, (String)bex.getLocalizedMessage());
                        return null;
                    }
                }
                String url = LineBreakpointUtils.getURLString(this.lb, this.pc.getProject(), curl);
                url = WebKitLineBreakpointManager.reformatFileURL(url);
                Object br = null;
                try {
                    return this.d.addLineBreakpoint(url, this.lb.getLineNumber() - 1, null, this.lb.getCondition());
                }
                catch (BreakpointException bex) {
                    JSBreakpointStatus.setInvalid((JSLineBreakpoint)this.lb, (String)bex.getLocalizedMessage());
                }
            }
            return null;
        }

        private static String reformatFileURL(String tabToDebug) {
            if (!tabToDebug.startsWith("file:")) {
                return tabToDebug;
            }
            tabToDebug = tabToDebug.substring(5);
            while (tabToDebug.length() > 0 && tabToDebug.startsWith("/")) {
                tabToDebug = tabToDebug.substring(1);
            }
            return "file:///" + tabToDebug;
        }

        public void paused(List<CallFrame> callStack, String reason) {
        }

        public void resumed() {
        }

        public void reset() {
            if (this.lineChanged.getAndSet(false)) {
                this.resubmitting.set(true);
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.resubmit();
                        resubmitting.set(false);
                    }
                });
            }
        }

        public void enabled(boolean enabled) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("lineNumber".equals(propertyName)) {
                Boolean ignore = this.ignoreLineUpdate.get();
                if (ignore != null && ignore.booleanValue()) {
                    return;
                }
                this.resubmit();
            } else if ("condition".equals(propertyName)) {
                this.resubmit();
            } else if ("fileChanged".equals(propertyName)) {
                this.lineChanged.set(true);
            } else if ("location".equals(propertyName)) {
                List duplicateBreakpoints;
                SourceMapsTranslator.Location compiledLocation;
                Breakpoint brkpt;
                Object object = this.brkptLock;
                synchronized (object) {
                    brkpt = this.b;
                    compiledLocation = this.bCompiledLocation;
                }
                if (brkpt == null) {
                    return;
                }
                int lineNumber = (int)brkpt.getLineNumber();
                SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(this.d);
                if (smt != null && compiledLocation != null) {
                    SourceMapsTranslator.Location sLoc = smt.getSourceLocation(new SourceMapsTranslator.Location(compiledLocation.getFile(), lineNumber, (int)brkpt.getColumnNumber()));
                    lineNumber = sLoc.getLine();
                }
                if ((duplicateBreakpoints = WebKitBreakpointManager.checkDuplicateBreakpoints(this.lb, lineNumber)) != null) {
                    for (int i = 1; i < duplicateBreakpoints.size(); ++i) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((org.netbeans.api.debugger.Breakpoint)duplicateBreakpoints.get(i));
                    }
                    DebuggerManager.getDebuggerManager().removeBreakpoint((org.netbeans.api.debugger.Breakpoint)this.lb);
                    return;
                }
                if (this.resubmitting.get()) {
                    return;
                }
                this.ignoreLineUpdate.set(Boolean.TRUE);
                try {
                    this.lb.setLine(lineNumber + 1);
                }
                finally {
                    this.ignoreLineUpdate.remove();
                }
                if (lineNumber >= 0) {
                    JSBreakpointStatus.setValid((JSLineBreakpoint)this.lb, (String)Bundle.MSG_BRKP_Resolved());
                } else {
                    JSBreakpointStatus.setInvalid((JSLineBreakpoint)this.lb, (String)Bundle.MSG_BRKP_Unresolved());
                }
            } else {
                super.propertyChange(event);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.resubmit();
        }
    }
}

