/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.ast.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ASTViewManager
extends DebuggerManagerAdapter {
    private volatile boolean shouldOpenView = TruffleOptions.isLanguageDeveloperMode();
    private volatile boolean isAtTruffleLocation;
    private final PropertyChangeListener propListenerHolder = propEvent -> {
        boolean develMode;
        this.shouldOpenView = develMode = TruffleOptions.isLanguageDeveloperMode();
        if (develMode) {
            this.openIfCan();
        } else {
            this.closeView();
        }
    };

    public ASTViewManager() {
        TruffleOptions.onLanguageDeveloperModeChange(this.propListenerHolder);
    }

    public void sessionAdded(Session session) {
        JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        debugger.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)((Object)this));
    }

    public void sessionRemoved(Session session) {
        JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            return;
        }
        debugger.removePropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)((Object)this));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentCallStackFrame".equals(evt.getPropertyName())) {
            CallStackFrame frame = (CallStackFrame)evt.getNewValue();
            if (frame != null) {
                CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(frame.getThread());
                this.isAtTruffleLocation = currentPCInfo != null;
                this.openIfCan();
            } else {
                this.isAtTruffleLocation = false;
            }
        }
    }

    private void openIfCan() {
        if (this.shouldOpenView && this.isAtTruffleLocation) {
            SwingUtilities.invokeLater(() -> {
                TopComponent tc = WindowManager.getDefault().findTopComponent("TruffleASTDebugView");
                tc.open();
                tc.requestVisible();
            });
            this.shouldOpenView = false;
        }
    }

    private void closeView() {
        SwingUtilities.invokeLater(() -> {
            TopComponent tc = WindowManager.getDefault().findTopComponent("TruffleASTDebugView");
            tc.close();
        });
    }
}

