/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.graalsdk.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.graalvm.polyglot.Context;
import org.netbeans.libs.graalsdk.impl.WriterOutputStream;
import org.openide.util.io.ReaderInputStream;

final class GraalContext
implements ScriptContext {
    private Context ctx;
    private final WriterOutputStream writer = new WriterOutputStream(new OutputStreamWriter(System.out));
    private final WriterOutputStream errorWriter = new WriterOutputStream(new OutputStreamWriter(System.err));
    private Reader reader;
    private SimpleBindings bindings;
    private boolean allowAllAccess;

    GraalContext() {
    }

    final synchronized Context ctx() {
        if (this.ctx == null) {
            Context.Builder b = Context.newBuilder(new String[0]);
            b.out(this.writer);
            b.err(this.errorWriter);
            if (this.reader != null) {
                try {
                    b.in((InputStream)new ReaderInputStream(this.reader, "UTF-8"));
                }
                catch (IOException ex) {
                    throw GraalContext.raise(RuntimeException.class, ex);
                }
            }
            if (this.allowAllAccess) {
                b.allowAllAccess(true);
            }
            this.ctx = b.build();
        }
        return this.ctx;
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Bindings getBindings(int scope) {
        this.assertGlobalScope(scope);
        if (this.bindings == null) {
            Map map = this.ctx().getPolyglotBindings().as(Map.class);
            this.bindings = new SimpleBindings(map);
        }
        return this.bindings;
    }

    private void assertGlobalScope(int scope) throws IllegalArgumentException {
        if (scope != 200) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.assertGlobalScope(scope);
        if ("allowAllAccess".equals(name)) {
            if (this.ctx == null) {
                this.allowAllAccess = Boolean.TRUE.equals(value);
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getAttribute(String name, int scope) {
        this.assertGlobalScope(scope);
        if ("allowAllAccess".equals(name)) {
            return this.allowAllAccess;
        }
        return null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public int getAttributesScope(String name) {
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer.getWriter();
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter.getWriter();
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer.setWriter(writer);
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter.setWriter(writer);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        if (this.ctx != null) {
            throw new IllegalStateException("Too late. Context has already been created!");
        }
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return Collections.nCopies(1, 200);
    }

    private static <T extends Exception> T raise(Class<T> aClass, Throwable ex) throws T {
        throw (Exception)ex;
    }
}

