/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.CLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnixUser {
    private final String userName;
    private final int uid;
    private final int gid;
    private final Set<String> groups;

    UnixUser(String userName, CLibrary.passwd pwd) throws PAMException {
        this.userName = userName;
        this.uid = pwd.pw_uid;
        this.gid = pwd.pw_gid;
        int sz = 4;
        int ngroups = 64;
        Memory m = new Memory((long)(ngroups * sz));
        IntByReference pngroups = new IntByReference(ngroups);
        if (CLibrary.libc.getgrouplist(userName, pwd.pw_gid, m, pngroups) < 0 && CLibrary.libc.getgrouplist(userName, pwd.pw_gid, m = new Memory((long)(pngroups.getValue() * sz)), pngroups) < 0) {
            throw new PAMException("getgrouplist failed");
        }
        ngroups = pngroups.getValue();
        this.groups = new HashSet<String>();
        for (int i = 0; i < ngroups; ++i) {
            int gid = m.getInt((long)(i * sz));
            CLibrary.group grp = CLibrary.libc.getgrgid(gid);
            this.groups.add(grp.gr_name);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUID() {
        return this.uid;
    }

    public int getGID() {
        return this.gid;
    }

    public Set<String> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    public static boolean exists(String name) {
        return CLibrary.libc.getpwnam(name) != null;
    }
}

