/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaFlagMapper {
    private String requestee;
    private String setter;
    private String state;
    private String flagId;
    private int number;
    private final BugzillaRepositoryConnector connector;
    private String description;

    public BugzillaFlagMapper(BugzillaRepositoryConnector connector) {
        this.connector = connector;
    }

    public String getRequestee() {
        return this.requestee;
    }

    public void setRequestee(String requestee) {
        this.requestee = requestee;
    }

    public String getSetter() {
        return this.setter;
    }

    public void setSetter(String setter) {
        this.setter = setter;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getFlagId() {
        return this.flagId;
    }

    public void setFlagId(String flagId) {
        this.flagId = flagId;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        TaskAttribute child;
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        TaskAttributeMetaData meta = taskAttribute.getMetaData().defaults();
        meta.setType("bugzilla.editor.flag");
        meta.setLabel(this.description);
        BugzillaVersion bugzillaVersion = null;
        try {
            RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(mapper.getTaskRepository(), false, (IProgressMonitor)new NullProgressMonitor());
            bugzillaVersion = repositoryConfiguration.getInstallVersion();
        }
        catch (CoreException coreException) {
            bugzillaVersion = BugzillaVersion.MIN_VERSION;
        }
        if (bugzillaVersion.compareTo(BugzillaVersion.BUGZILLA_3_2) >= 0) {
            meta.setKind("task.common.kind.flag");
        }
        meta.setReadOnly(false);
        if (this.getNumber() != 0) {
            child = taskAttribute.createMappedAttribute("number");
            child.getMetaData().defaults().setType("integer");
            mapper.setIntegerValue(child, Integer.valueOf(this.getNumber()));
        }
        if (this.getRequestee() != null) {
            child = taskAttribute.createMappedAttribute("requestee");
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getRequestee());
        }
        if (this.getSetter() != null) {
            child = taskAttribute.createMappedAttribute("setter");
            child.getMetaData().defaults().setType("shortText");
            mapper.setValue(child, this.getSetter());
        }
        if (this.getState() != null) {
            child = taskAttribute.createMappedAttribute("state");
            child.getMetaData().defaults().setType("singleSelect");
            child.getMetaData().setLabel(this.flagId);
            child.getMetaData().setReadOnly(false);
            mapper.setValue(child, this.getState());
            taskAttribute.getMetaData().putValue("task.meta.associated.attribute", "state");
        }
    }
}

