/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.analysis.commands.Bundle;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.parsers.MessDetectorReportParser;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.queries.Queries;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class MessDetector {
    static final Logger LOGGER = Logger.getLogger(MessDetector.class.getName());
    public static final String NAME = "phpmd";
    public static final String LONG_NAME = "phpmd" + FileUtils.getScriptExtension((boolean)true);
    static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-php-phpmd-log.xml");
    private static final String REPORT_FORMAT_PARAM = "xml";
    private static final String EXCLUDE_PARAM = "--exclude";
    private static final String SUFFIXES_PARAM = "--suffixes";
    @SuppressWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="It is immutable")
    public static final List<String> RULE_SETS = Arrays.asList("codesize", "controversial", "design", "naming", "unusedcode");
    private final String messDetectorPath;
    private volatile int analyzeGroupCounter = 1;

    private MessDetector(String messDetectorPath) {
        this.messDetectorPath = messDetectorPath;
    }

    public static MessDetector getDefault() throws InvalidPhpExecutableException {
        String messDetectorPath = AnalysisOptions.getInstance().getMessDetectorPath();
        String error = MessDetector.validate(messDetectorPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new MessDetector(messDetectorPath);
    }

    public static String validate(String messDetectorPath) {
        return PhpExecutableValidator.validateCommand((String)messDetectorPath, (String)Bundle.MessDetector_script_label());
    }

    public void startAnalyzeGroup() {
        this.analyzeGroupCounter = 1;
    }

    @CheckForNull
    public List<Result> analyze(List<String> ruleSets, FileObject ... files) {
        return this.analyze(ruleSets, Arrays.asList(files));
    }

    @CheckForNull
    public List<Result> analyze(List<String> ruleSets, List<FileObject> files) {
        assert (this.assertValidFiles(files));
        try {
            Integer result = this.getExecutable(Bundle.MessDetector_analyze(this.analyzeGroupCounter++)).additionalParameters(this.getParameters(ruleSets, files)).runAndWait(this.getDescriptor(), "Running mess detector...");
            if (result == null) {
                return null;
            }
            return MessDetectorReportParser.parse(XML_LOG);
        }
        catch (CancellationException ex) {
            return Collections.emptyList();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"CodeAnalysis");
            return null;
        }
    }

    private PhpExecutable getExecutable(String title) {
        return new PhpExecutable(this.messDetectorPath).optionsSubcategory("CodeAnalysis").fileOutput(XML_LOG, "UTF-8", false).displayName(title);
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis").frontWindowOnError(false).inputVisible(false).preExecution(new Runnable(){

            @Override
            public void run() {
                if (XML_LOG.isFile() && !XML_LOG.delete()) {
                    LOGGER.log(Level.INFO, "Cannot delete log file {0}", XML_LOG.getAbsolutePath());
                }
            }
        });
    }

    private List<String> getParameters(List<String> ruleSets, List<FileObject> files) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.joinFilePaths(files));
        params.add(REPORT_FORMAT_PARAM);
        params.add(StringUtils.implode(ruleSets, (String)","));
        params.add(SUFFIXES_PARAM);
        params.add(StringUtils.implode((Collection)FileUtil.getMIMETypeExtensions((String)"text/x-php5"), (String)","));
        this.addIgnoredFiles(params, files);
        return params;
    }

    private boolean assertValidFiles(List<FileObject> files) {
        for (FileObject file : files) {
            assert (file.isValid()) : "Invalid file given: " + file;
        }
        return true;
    }

    private String joinFilePaths(List<FileObject> files) {
        StringBuilder paths = new StringBuilder(200);
        for (FileObject file : files) {
            if (paths.length() > 0) {
                paths.append(",");
            }
            paths.append(FileUtil.toFile((FileObject)file).getAbsolutePath());
        }
        return paths.toString();
    }

    private void addIgnoredFiles(List<String> params, List<FileObject> files) {
        HashSet<String> ignoredFiles = new HashSet<String>();
        for (FileObject file : files) {
            for (FileObject fileObject : Queries.getVisibilityQuery((PhpModule)PhpModule.Factory.forFileObject((FileObject)file)).getCodeAnalysisExcludeFiles()) {
                String ignoredName = FileUtil.getFileDisplayName((FileObject)fileObject);
                ignoredFiles.add(ignoredName + File.separator + "*");
            }
        }
        if (ignoredFiles.isEmpty()) {
            return;
        }
        params.add(EXCLUDE_PARAM);
        params.add(StringUtils.implode(ignoredFiles, (String)","));
    }
}

