/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.ActionProviderImpl;
import org.netbeans.modules.gradle.GradleArtifactStore;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.nodes.SubProjectsNode;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class ConfigurationsNode
extends AbstractNode {
    private final NbGradleProjectImpl project;
    private static final String REQUESTED_COMPONENT = "requestedComponent";
    private static final String LIBRARIES_ICON = "org/netbeans/modules/gradle/resources/libraries.png";
    private static final String WARNING_BADGE = "org/netbeans/modules/gradle/resources/warning-badge.png";
    private static final String SOURCES_BADGE = "org/netbeans/modules/gradle/resources/sources-badge.png";
    private static final String JAVADOC_BADGE = "org/netbeans/modules/gradle/resources/javadoc-badge.png";
    private static final String UNRESOLVED_ICON = "org/netbeans/modules/gradle/resources/empty.png";
    private static final String ARTIFACT_ICON = "org/netbeans/modules/gradle/resources/module-artifact.png";
    private final Action downloadSourcesAction;
    private final Action downloadJavadocAction;

    public ConfigurationsNode(NbGradleProjectImpl project) {
        super(Children.create((ChildFactory)new ConfigurationsChildren(project), (boolean)true), Lookups.singleton((Object)project));
        this.project = project;
        this.setName("configurations");
        this.setDisplayName(Bundle.LBL_ConfigurationsNode());
        this.downloadSourcesAction = ActionProviderImpl.createCustomGradleAction(project, "Download Sources", "download.sources", Lookups.singleton((Object)RunUtils.simpleReplaceTokenProvider(REQUESTED_COMPONENT, "ALL")));
        this.downloadJavadocAction = ActionProviderImpl.createCustomGradleAction(project, "Download Javadoc", "download.javadoc", Lookups.singleton((Object)RunUtils.simpleReplaceTokenProvider(REQUESTED_COMPONENT, "ALL")));
    }

    public Image getIcon(int type) {
        GradleProject gp = this.project.getGradleProject();
        Image ret = ImageUtilities.loadImage((String)LIBRARIES_ICON);
        if (gp.getQuality().worseThan(NbGradleProject.Quality.FULL) || !gp.getBaseProject().isResolved()) {
            Image warn = ImageUtilities.loadImage((String)WARNING_BADGE);
            ret = ImageUtilities.mergeImages((Image)ret, (Image)warn, (int)8, (int)0);
        }
        return ret;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.downloadSourcesAction, this.downloadJavadocAction};
    }

    public String getShortDescription() {
        GradleProject gp = this.project.getGradleProject();
        return gp.getBaseProject().isResolved() ? Bundle.HINT_ConfigurationsNode() : Bundle.HINT_ConfigurationsNodeUnresolved();
    }

    private static class OpenJavadocAction
    extends AbstractAction {
        private final FileObject mainJar;

        public OpenJavadocAction(FileObject mainJar) {
            super(Bundle.LBL_OpenJavadocAction());
            this.mainJar = mainJar;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject index;
            FileObject arch;
            File javadoc = GradleArtifactStore.getDefault().getJavadoc(FileUtil.toFile((FileObject)this.mainJar));
            FileObject fo = FileUtil.toFileObject((File)javadoc);
            if (fo != null && (arch = FileUtil.getArchiveRoot((FileObject)fo)) != null && (index = arch.getFileObject("index.html")) != null) {
                URL indexUrl = index.toURL();
                HtmlBrowser.URLDisplayer.getDefault().showURL(indexUrl);
            }
        }

        @Override
        public boolean isEnabled() {
            File javadoc = GradleArtifactStore.getDefault().getJavadoc(FileUtil.toFile((FileObject)this.mainJar));
            return javadoc != null;
        }
    }

    private static class LocalFileFilterNode
    extends FilterNode {
        private final FileObject mainJar;

        public LocalFileFilterNode(FileObject mainJar, Node original) {
            super(original);
            this.mainJar = mainJar;
        }

        public Action[] getActions(boolean context) {
            ArrayList<OpenJavadocAction> actions = new ArrayList<OpenJavadocAction>(3);
            actions.add(new OpenJavadocAction(this.mainJar));
            return actions.toArray(new Action[actions.size()]);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getShortDescription() {
            return this.mainJar.getPath();
        }

        public Image getIcon(int type) {
            GradleArtifactStore store = GradleArtifactStore.getDefault();
            Image ret = super.getIcon(type);
            if (store.getJavadoc(FileUtil.toFile((FileObject)this.mainJar)) != null) {
                Image javadoc = ImageUtilities.loadImage((String)ConfigurationsNode.JAVADOC_BADGE);
                ret = ImageUtilities.mergeImages((Image)ret, (Image)javadoc, (int)0, (int)8);
            }
            if (store.getSources(FileUtil.toFile((FileObject)this.mainJar)) != null) {
                Image sources = ImageUtilities.loadImage((String)ConfigurationsNode.SOURCES_BADGE);
                ret = ImageUtilities.mergeImages((Image)ret, (Image)sources, (int)8, (int)8);
            }
            return ret;
        }
    }

    private static class FileDependencyChildren
    extends ChildFactory<FileObject> {
        final GradleDependency.FileCollectionDependency dep;

        public FileDependencyChildren(GradleDependency.FileCollectionDependency dep) {
            this.dep = dep;
        }

        protected boolean createKeys(List<FileObject> keys) {
            ArrayList<FileObject> ret = new ArrayList<FileObject>(this.dep.getFiles().size());
            for (File file : this.dep.getFiles()) {
                FileObject fo = FileUtil.toFileObject((File)file);
                if (fo == null) continue;
                ret.add(fo);
            }
            ret.sort(new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    return o1.getNameExt().compareTo(o2.getNameExt());
                }
            });
            keys.addAll(ret);
            return true;
        }

        protected Node createNodeForKey(FileObject key) {
            try {
                DataObject dataObject = DataObject.find((FileObject)key);
                return new LocalFileFilterNode(key, dataObject.getNodeDelegate().cloneNode());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }
    }

    private static class ModuleFilterNode
    extends FilterNode
    implements ChangeListener {
        private final NbGradleProjectImpl project;
        private final GradleDependency.ModuleDependency module;
        private final File mainJar;

        public ModuleFilterNode(NbGradleProjectImpl project, GradleDependency.ModuleDependency module, File mainJar, Node original) {
            super(original);
            this.project = project;
            this.module = module;
            this.mainJar = mainJar;
            GradleArtifactStore.getDefault().addChangeListener(this);
        }

        public Action[] getActions(boolean context) {
            Action download;
            GradleArtifactStore store = GradleArtifactStore.getDefault();
            ArrayList<Action> actions = new ArrayList<Action>(3);
            actions.add(new OpenJavadocAction(FileUtil.toFileObject((File)this.mainJar)));
            if (store.getSources(this.mainJar) == null) {
                download = ActionProviderImpl.createCustomGradleAction(this.project, "Download Sources", "download.sources", Lookups.singleton((Object)RunUtils.simpleReplaceTokenProvider(ConfigurationsNode.REQUESTED_COMPONENT, this.module.getId())));
                actions.add(download);
            }
            if (store.getJavadoc(this.mainJar) == null) {
                download = ActionProviderImpl.createCustomGradleAction(this.project, "Download Javadoc", "download.javadoc", Lookups.singleton((Object)RunUtils.simpleReplaceTokenProvider(ConfigurationsNode.REQUESTED_COMPONENT, this.module.getId())));
                actions.add(download);
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getShortDescription() {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("Artifact Id: <b>").append(this.module.getId()).append("</b><br/>");
            sb.append("File: ").append(this.mainJar.getAbsolutePath());
            return sb.toString();
        }

        public String getDisplayName() {
            return this.module.getName() + ":" + this.module.getVersion();
        }

        public Image getIcon(int type) {
            GradleArtifactStore store = GradleArtifactStore.getDefault();
            Image ret = ImageUtilities.loadImage((String)ConfigurationsNode.ARTIFACT_ICON);
            if (store.getJavadoc(this.mainJar) != null) {
                Image javadoc = ImageUtilities.loadImage((String)ConfigurationsNode.JAVADOC_BADGE);
                ret = ImageUtilities.mergeImages((Image)ret, (Image)javadoc, (int)0, (int)8);
            }
            if (store.getSources(this.mainJar) != null) {
                Image sources = ImageUtilities.loadImage((String)ConfigurationsNode.SOURCES_BADGE);
                ret = ImageUtilities.mergeImages((Image)ret, (Image)sources, (int)8, (int)8);
            }
            return ret;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireIconChange();
        }

        public void destroy() throws IOException {
            GradleArtifactStore.getDefault().removeChangeListener(this);
            super.destroy();
        }
    }

    private static class ConfigurationChildren
    extends ChildFactory.Detachable<GradleDependency>
    implements PropertyChangeListener {
        private final NbGradleProjectImpl project;
        private final String configuration;

        public ConfigurationChildren(NbGradleProjectImpl project, String configuration) {
            this.project = project;
            this.configuration = configuration;
        }

        protected Node[] createNodesForKey(GradleDependency key) {
            GradleProject gp = this.project.getGradleProject();
            ArrayList<Object> ret = new ArrayList<Object>(1);
            switch (key.getType()) {
                case MODULE: {
                    GradleDependency.ModuleDependency dep = (GradleDependency.ModuleDependency)key;
                    for (File artifact : dep.getArtifacts()) {
                        FileObject fo = FileUtil.toFileObject((File)artifact);
                        if (fo == null) continue;
                        try {
                            DataObject dataObject = DataObject.find((FileObject)fo);
                            ret.add(new ModuleFilterNode(this.project, dep, artifact, dataObject.getNodeDelegate().cloneNode()));
                        }
                        catch (DataObjectNotFoundException dataObject) {}
                    }
                    break;
                }
                case PROJECT: {
                    GradleDependency.ProjectDependency dep = (GradleDependency.ProjectDependency)key;
                    File projDir = dep.getPath();
                    FileObject fo = FileUtil.toFileObject((File)projDir);
                    if (fo == null) break;
                    try {
                        Project prj = ProjectManager.getDefault().findProject(fo);
                        if (prj == null || prj.getLookup().lookup(NbGradleProjectImpl.class) == null) break;
                        NbGradleProjectImpl proj = (NbGradleProjectImpl)prj;
                        assert (prj.getLookup().lookup(LogicalViewProvider.class) != null);
                        Node original = ((LogicalViewProvider)proj.getLookup().lookup(LogicalViewProvider.class)).createLogicalView();
                        ret.add((Object)new SubProjectsNode.ProjectFilterNode(proj, original));
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                case FILE: {
                    GradleDependency.FileCollectionDependency dep = (GradleDependency.FileCollectionDependency)key;
                    AbstractNode node = new AbstractNode(Children.create((ChildFactory)new FileDependencyChildren(dep), (boolean)true));
                    node.setDisplayName(Bundle.LBL_LocalDependenciesNode());
                    node.setIconBaseWithExtension(ConfigurationsNode.LIBRARIES_ICON);
                    ret.add(node);
                    break;
                }
                case UNRESOLVED: {
                    GradleDependency.UnresolvedDependency dep = (GradleDependency.UnresolvedDependency)key;
                    AbstractNode node = new AbstractNode(Children.LEAF);
                    node.setName(dep.getId());
                    node.setIconBaseWithExtension(ConfigurationsNode.UNRESOLVED_ICON);
                    ret.add(node);
                    break;
                }
            }
            return ret.toArray(new Node[ret.size()]);
        }

        protected boolean createKeys(List<GradleDependency> list) {
            GradleProject gp = this.project.getGradleProject();
            ArrayList<GradleDependency> ret = new ArrayList<GradleDependency>();
            GradleConfiguration conf = gp.getBaseProject().getConfigurations().get(this.configuration);
            if (conf != null) {
                ret.addAll(conf.getUnresolved());
                ret.addAll(conf.getProjects());
                ret.addAll(conf.getModules());
                GradleDependency.FileCollectionDependency fileDeps = conf.getFiles();
                if (fileDeps != null && !fileDeps.getFiles().isEmpty()) {
                    ret.add(fileDeps);
                }
                Collections.sort(ret);
                list.addAll(ret);
            }
            return true;
        }

        protected void removeNotify() {
            NbGradleProject.removePropertyChangeListener(this.project, this);
        }

        protected void addNotify() {
            NbGradleProject.addPropertyChangeListener(this.project, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh(false);
        }
    }

    private static class ConfigurationsChildren
    extends ChildFactory.Detachable<GradleConfiguration>
    implements PreferenceChangeListener,
    PropertyChangeListener {
        private final NbGradleProjectImpl project;

        public ConfigurationsChildren(NbGradleProjectImpl project) {
            this.project = project;
        }

        protected Node createNodeForKey(GradleConfiguration conf) {
            AbstractNode ret = new AbstractNode(Children.create((ChildFactory)new ConfigurationChildren(this.project, conf.getName()), (boolean)true));
            ret.setName(conf.getName());
            ret.setShortDescription(conf.getDescription());
            StringBuilder displayName = new StringBuilder(conf.getName());
            if (!conf.getExtendsFrom().isEmpty()) {
                displayName.append(" [");
                String separator = "";
                for (GradleConfiguration ext : conf.getExtendsFrom()) {
                    displayName.append(separator);
                    displayName.append(ext.getName());
                    separator = ", ";
                }
                displayName.append(']');
            }
            ret.setDisplayName(displayName.toString());
            ret.setIconBaseWithExtension(ConfigurationsNode.LIBRARIES_ICON);
            return ret;
        }

        protected boolean createKeys(List<GradleConfiguration> list) {
            boolean hideEmpty = GradleSettings.getDefault().isHideEmptyConfigurations();
            ArrayList<GradleConfiguration> ret = new ArrayList<GradleConfiguration>();
            for (GradleConfiguration conf : this.project.getGradleProject().getBaseProject().getConfigurations().values()) {
                if (hideEmpty && conf.isEmpty()) continue;
                ret.add(conf);
            }
            Collections.sort(ret);
            list.addAll(ret);
            return true;
        }

        protected void removeNotify() {
            NbGradleProject.removePropertyChangeListener(this.project, this);
            GradleSettings.getDefault().getPreferences().removePreferenceChangeListener(this);
        }

        protected void addNotify() {
            GradleSettings.getDefault().getPreferences().addPreferenceChangeListener(this);
            NbGradleProject.addPropertyChangeListener(this.project, this);
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("hideEmptyConfiguration".equals(evt.getKey())) {
                this.refresh(false);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh(false);
        }
    }
}

