/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SubProjectsNode
extends AbstractNode {
    private static final String SP_BADGE = "org/netbeans/modules/gradle/resources/gradle-badge.png";
    private final NbGradleProjectImpl proj;

    public SubProjectsNode(NbGradleProjectImpl proj) {
        super(FilterNode.Children.create((ChildFactory)new SubProjectsChildFactory(proj), (boolean)true));
        this.proj = proj;
        this.setName("SubProjects");
        this.setDisplayName(Bundle.LBL_SubProjects());
    }

    public Action[] getActions(boolean bool) {
        return new Action[0];
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)SP_BADGE, (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(Bundle.BTN_Open_Project()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection projects = context.lookupAll(NbGradleProjectImpl.class);
                    Project[] projectsArray = projects.toArray(new NbGradleProjectImpl[0]);
                    OpenProjects.getDefault().open(projectsArray, false, true);
                    if (projectsArray.length > 0) {
                        RequestProcessor.getDefault().post(new Runnable((NbGradleProjectImpl[])projectsArray){
                            final /* synthetic */ NbGradleProjectImpl[] val$projectsArray;
                            {
                                this.val$projectsArray = nbGradleProjectImplArray;
                            }

                            @Override
                            public void run() {
                                OpenProjects.getDefault().open((Project[])this.val$projectsArray, false, true);
                            }
                        }, 500);
                    }
                }
            };
        }
    }

    public static class ProjectFilterNode
    extends FilterNode {
        private final NbGradleProjectImpl project;

        ProjectFilterNode(NbGradleProjectImpl proj, Node original) {
            super(original, FilterNode.Children.LEAF);
            this.project = proj;
        }

        public Action[] getActions(boolean b) {
            ArrayList<OpenProjectAction> lst = new ArrayList<OpenProjectAction>();
            lst.add(OpenProjectAction.SINGLETON);
            return lst.toArray(new Action[lst.size()]);
        }

        public Action getPreferredAction() {
            return OpenProjectAction.SINGLETON;
        }
    }

    private static class SubProjectsChildFactory
    extends ChildFactory<NbGradleProjectImpl> {
        private final NbGradleProjectImpl project;
        private final PropertyChangeListener listener;

        SubProjectsChildFactory(NbGradleProjectImpl proj) {
            this.project = proj;
            NbGradleProject watcher = this.project.getProjectWatcher();
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("ProjectInfo".equals(evt.getPropertyName())) {
                        this.refresh(false);
                    }
                }
            };
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)watcher));
        }

        protected boolean createKeys(List<NbGradleProjectImpl> modules) {
            Map<String, File> subProjects = this.project.getGradleProject().getBaseProject().getSubProjects();
            for (String path : subProjects.keySet()) {
                File projDir = subProjects.get(path);
                FileObject fo = FileUtil.toFileObject((File)projDir);
                if (fo == null) continue;
                try {
                    Project prj = ProjectManager.getDefault().findProject(fo);
                    if (prj == null || prj.getLookup().lookup(NbGradleProjectImpl.class) == null) continue;
                    NbGradleProjectImpl proj = (NbGradleProjectImpl)prj;
                    assert (prj.getLookup().lookup(LogicalViewProvider.class) != null);
                    modules.add(proj);
                }
                catch (IOException | IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }

        protected Node createNodeForKey(NbGradleProjectImpl proj) {
            Node original = ((LogicalViewProvider)proj.getLookup().lookup(LogicalViewProvider.class)).createLogicalView();
            return new ProjectFilterNode(proj, original);
        }
    }
}

