/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.filtering.SecurityHelper;
import org.glassfish.jersey.message.filtering.ServerScopeProvider;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, ServiceLocator serviceLocator) {
        super(config, serviceLocator);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        HashSet filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = Sets.newHashSet();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

