/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import com.sun.xml.ws.transport.tcp.server.TCPServiceChannelWSAdapter;
import com.sun.xml.ws.transport.tcp.server.WSTCPAdapterRegistry;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelCreator;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelWSImpl;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import com.sun.xml.ws.util.exception.JAXWSExceptionBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WSTCPDelegate
implements WSTCPAdapterRegistry,
TCPMessageListener {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    private final Map<String, TCPAdapter> fixedUrlPatternEndpoints = new HashMap<String, TCPAdapter>();
    private final List<TCPAdapter> pathUrlPatternEndpoints = new ArrayList<TCPAdapter>();
    private volatile TCPAdapter serviceChannelWSAdapter;
    private WSTCPAdapterRegistry customWSRegistry;

    public void setCustomWSRegistry(@NotNull WSTCPAdapterRegistry customWSRegistry) {
        this.customWSRegistry = customWSRegistry;
    }

    public void registerAdapters(@NotNull String contextPath, @NotNull List<TCPAdapter> adapters) {
        for (TCPAdapter adapter : adapters) {
            this.registerEndpointUrlPattern(contextPath, adapter);
        }
    }

    public void freeAdapters(@NotNull String contextPath, @NotNull List<TCPAdapter> adapters) {
        for (TCPAdapter adapter : adapters) {
            String urlPattern = contextPath + adapter.urlPattern;
            logger.log(Level.FINE, MessagesMessages.WSTCP_1100_WSTCP_DELEGATE_DEREGISTER_ADAPTER(urlPattern));
            if (this.fixedUrlPatternEndpoints.remove(urlPattern) != null) continue;
            this.pathUrlPatternEndpoints.remove(adapter);
        }
    }

    private void registerEndpointUrlPattern(@NotNull String contextPath, @NotNull TCPAdapter adapter) {
        String urlPattern = contextPath + adapter.urlPattern;
        logger.log(Level.FINE, MessagesMessages.WSTCP_1101_WSTCP_DELEGATE_REGISTER_ADAPTER(urlPattern));
        if (urlPattern.endsWith("/*")) {
            this.pathUrlPatternEndpoints.add(adapter);
        } else if (!this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
            this.fixedUrlPatternEndpoints.put(urlPattern, adapter);
        }
    }

    @Override
    @Nullable
    public TCPAdapter getTarget(@NotNull WSTCPURI tcpURI) {
        TCPAdapter result = null;
        String path = tcpURI.path;
        if (path != null && (result = this.fixedUrlPatternEndpoints.get(path)) == null) {
            for (TCPAdapter candidate : this.pathUrlPatternEndpoints) {
                if (!path.startsWith(candidate.getValidPath())) continue;
                result = candidate;
                break;
            }
        }
        if (result == null && this.customWSRegistry != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1102_WSTCP_DELEGATE_GOING_TO_CUSTOM_REG(tcpURI));
            }
            return this.customWSRegistry.getTarget(tcpURI);
        }
        return result;
    }

    @Override
    public void onError(ChannelContext channelContext, WSTCPError error) throws IOException {
        this.sendErrorResponse(channelContext, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(@NotNull ChannelContext channelContext) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            Connection connection = channelContext.getConnection();
            logger.log(Level.FINE, MessagesMessages.WSTCP_1103_WSTCP_DELEGATE_ON_MESSAGE(connection.getHost(), connection.getPort(), connection.getLocalHost(), connection.getLocalPort()));
        }
        try {
            TCPAdapter target = null;
            if (channelContext.getChannelId() > 0) {
                WSTCPURI tcpURI = channelContext.getTargetWSURI();
                target = this.getTarget(tcpURI);
            } else {
                target = this.getServiceChannelWSAdapter();
            }
            if (target != null) {
                target.handle(channelContext);
            } else {
                TCPAdapter.sendErrorResponse(channelContext, WSTCPError.createNonCriticalError(1, MessagesMessages.WSTCP_0026_UNKNOWN_CHANNEL_ID(channelContext.getChannelId())));
            }
        }
        catch (WSTCPException e) {
            Connection connection = channelContext.getConnection();
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0023_TARGET_EXEC_ERROR(connection.getHost(), connection.getPort()), e);
            this.sendErrorResponse(channelContext, e.getError());
            if (e.getError().isCritical()) {
                channelContext.getConnectionSession().close();
            }
        }
        catch (JAXWSExceptionBase e) {
            Connection connection = channelContext.getConnection();
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0023_TARGET_EXEC_ERROR(connection.getHost(), connection.getPort()), e);
            this.sendErrorResponse(channelContext, WSTCPError.createNonCriticalError(0, MessagesMessages.WSTCP_0025_GENERAL_CHANNEL_ERROR(MessagesMessages.WSTCP_0004_CHECK_SERVER_LOG())));
        }
        catch (IOException e) {
            Connection connection = channelContext.getConnection();
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0023_TARGET_EXEC_ERROR(connection.getHost(), connection.getPort()), e);
            throw e;
        }
        catch (Exception e) {
            Connection connection = channelContext.getConnection();
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0023_TARGET_EXEC_ERROR(connection.getHost(), connection.getPort()), e);
            this.sendErrorResponse(channelContext, WSTCPError.createNonCriticalError(0, MessagesMessages.WSTCP_0025_GENERAL_CHANNEL_ERROR(MessagesMessages.WSTCP_0004_CHECK_SERVER_LOG())));
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, MessagesMessages.WSTCP_1104_WSTCP_DELEGATE_ON_MESSAGE_COMPLETED());
            }
        }
    }

    public void destroy() {
        logger.log(Level.FINE, MessagesMessages.WSTCP_1105_WSTCP_DELEGATE_DESTROY());
    }

    @NotNull
    private TCPAdapter getServiceChannelWSAdapter() throws Exception {
        if (this.serviceChannelWSAdapter == null) {
            this.registerServiceChannelWSAdapter();
        }
        return this.serviceChannelWSAdapter;
    }

    private void sendErrorResponse(ChannelContext channelContext, WSTCPError error) throws IOException {
        try {
            TCPAdapter.sendErrorResponse(channelContext, error);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, MessagesMessages.WSTCP_0002_SERVER_ERROR_MESSAGE_SENDING_FAILED(), e);
            throw new IOException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private synchronized void registerServiceChannelWSAdapter() throws Exception {
        if (this.serviceChannelWSAdapter == null) {
            WSEndpoint<ServiceChannelWSImpl> endpoint = ServiceChannelCreator.getServiceChannelEndpointInstance();
            String serviceNameLocal = endpoint.getServiceName().getLocalPart();
            this.serviceChannelWSAdapter = new TCPServiceChannelWSAdapter(serviceNameLocal, "/servicechannel", endpoint, this);
            this.registerEndpointUrlPattern("/service", this.serviceChannelWSAdapter);
        }
    }
}

