/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.jaxwsmodelapi.wsdlmodel.WsdlModelProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JaxwsWsdlModelProvider
implements WsdlModelProvider {
    private String packageName;
    private Throwable creationException;

    public WsdlModel getWsdlModel(URL url, String packageName, URL catalog, boolean forceReload) {
        Throwable ce;
        this.packageName = packageName;
        WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(url);
        modeler.setCatalog(catalog);
        WsdlModel model = modeler.getAndWaitForWsdlModel(forceReload);
        if (model != null && (this.packageName == null || this.packageName.trim().length() == 0)) {
            this.packageName = model.getServices().size() > 0 ? model.getServices().get(0).getJavaName() : "defaultPackage";
        }
        this.creationException = (ce = modeler.getCreationException()) != null ? ce : null;
        return model;
    }

    public boolean canAccept(URL url) {
        return !this.isRPCEncoded(url);
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    public String getEffectivePackageName() {
        return this.packageName;
    }

    private boolean isRPCEncoded(URL url) {
        try {
            FileObject wsdlFO = FileUtil.toFileObject((File)new File(url.toURI()));
            WSDLModel model = WSDLModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)wsdlFO, (boolean)false));
            return JaxwsWsdlModelProvider.isRPCEncoded(model);
        }
        catch (Exception ex) {
            Logger.getLogger(JaxwsWsdlModelProvider.class.getName()).log(Level.INFO, "", ex);
            return false;
        }
    }

    public static boolean isRPCEncoded(WSDLModel wsdlModel) {
        Definitions definitions = wsdlModel.getDefinitions();
        Collection bindings = definitions.getBindings();
        for (Binding binding : bindings) {
            List soapBindings = binding.getExtensibilityElements(SOAPBinding.class);
            for (SOAPBinding soapBinding : soapBindings) {
                if (soapBinding.getStyle() != SOAPBinding.Style.RPC) continue;
                Collection bindingOperations = binding.getBindingOperations();
                for (BindingOperation bindingOperation : bindingOperations) {
                    SOAPBody soapBody;
                    List soapBodies;
                    BindingInput bindingInput = bindingOperation.getBindingInput();
                    if (bindingInput == null || (soapBodies = bindingInput.getExtensibilityElements(SOAPBody.class)) == null || soapBodies.size() <= 0 || (soapBody = (SOAPBody)soapBodies.get(0)).getUse() != SOAPMessageBase.Use.ENCODED) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

