/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModelFactory;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ConfigurationUtils {
    private static WeakHashMap<FileObject, WeakReference<JSFConfigModel>> configModelsEditable = new WeakHashMap();
    private static WeakHashMap<FileObject, WeakReference<JSFConfigModel>> configModelsNonEditable = new WeakHashMap();

    public static synchronized JSFConfigModel getConfigModel(FileObject confFile, boolean editable) {
        JSFConfigModel configModel = null;
        if (confFile != null && confFile.isValid()) {
            WeakHashMap<FileObject, WeakReference<JSFConfigModel>> configModelsRef = editable ? configModelsEditable : configModelsNonEditable;
            WeakReference configModelRef = (WeakReference)configModelsRef.get(confFile);
            if (configModelRef != null) {
                configModel = (JSFConfigModel)configModelRef.get();
                if (configModel != null) {
                    return configModel;
                }
                configModelsRef.remove(confFile);
            }
            try {
                ModelSource modelSource = Utilities.createModelSource((FileObject)confFile, (boolean)editable);
                configModel = JSFConfigModelFactory.getInstance().getModel(modelSource);
                configModelsRef.put(confFile, new WeakReference<JSFConfigModel>(configModel));
            }
            catch (CatalogModelException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return configModel;
    }

    public static Servlet getFacesServlet(WebModule webModule) {
        FileObject deploymentDescriptor = webModule.getDeploymentDescriptor();
        if (deploymentDescriptor == null) {
            return null;
        }
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            return (Servlet)webApp.findBeanByName("Servlet", "ServletClass", "javax.faces.webapp.FacesServlet");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getFacesServletMapping(WebModule webModule) {
        FileObject deploymentDescriptor = webModule.getDeploymentDescriptor();
        Servlet servlet = ConfigurationUtils.getFacesServlet(webModule);
        if (servlet != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(deploymentDescriptor);
                ServletMapping[] mappings = webApp.getServletMapping();
                for (int i = 0; i < mappings.length; ++i) {
                    if (!mappings[i].getServletName().equals(servlet.getServletName())) continue;
                    return ((ServletMapping25)mappings[i]).getUrlPatterns()[0];
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    public static FileObject[] getFacesConfigFiles(WebModule webModule) {
        String[] sFiles = JSFConfigUtilities.getConfigFiles(webModule);
        if (sFiles.length > 0) {
            FileObject documentBase = webModule.getDocumentBase();
            if (documentBase == null) {
                return new FileObject[0];
            }
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (int i = 0; i < sFiles.length; ++i) {
                FileObject file = documentBase.getFileObject(sFiles[i]);
                if (file == null) continue;
                files.add(file);
            }
            return files.toArray(new FileObject[files.size()]);
        }
        return new FileObject[0];
    }

    public static String translateURI(String mapping, String uri) {
        String resource = "";
        if (mapping != null && mapping.length() > 0) {
            if (mapping.startsWith("*.")) {
                resource = uri.indexOf(46) > 0 ? uri.substring(0, uri.lastIndexOf(46)) + mapping.substring(1) : uri + mapping.substring(1);
            } else if (mapping.endsWith("/*")) {
                resource = mapping.substring(1, mapping.length() - 1) + uri;
            }
        }
        return resource;
    }

    public static FileObject findFacesConfigForManagedBean(WebModule webModule, String name) {
        FileObject[] configs = ConfigurationUtils.getFacesConfigFiles(webModule);
        for (int i = 0; i < configs.length; ++i) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(configs[i], true).getRootComponent();
            List<ManagedBean> beans = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : beans) {
                if (!name.equals(managedBean.getManagedBeanName())) continue;
                return configs[i];
            }
        }
        return null;
    }
}

