/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final List<HttpMessageConverter<?>> messageConverters;
    protected final List<MediaType> allSupportedMediaTypes;

    public AbstractMessageConverterMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
        this.allSupportedMediaTypes = AbstractMessageConverterMethodArgumentResolver.getAllSupportedMediaTypes(messageConverters);
    }

    private static List<MediaType> getAllSupportedMediaTypes(List<HttpMessageConverter<?>> messageConverters) {
        LinkedHashSet allSupportedMediaTypes = new LinkedHashSet();
        for (HttpMessageConverter<?> messageConverter : messageConverters) {
            allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
        }
        ArrayList result = new ArrayList(allSupportedMediaTypes);
        MediaType.sortBySpecificity(result);
        return Collections.unmodifiableList(result);
    }

    protected <T> Object readWithMessageConverters(NativeWebRequest webRequest, MethodParameter methodParam, Type paramType) throws IOException, HttpMediaTypeNotSupportedException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        return this.readWithMessageConverters((HttpInputMessage)inputMessage, methodParam, paramType);
    }

    protected <T> Object readWithMessageConverters(HttpInputMessage inputMessage, MethodParameter methodParam, Type targetType) throws IOException, HttpMediaTypeNotSupportedException {
        MediaType contentType;
        try {
            contentType = inputMessage.getHeaders().getContentType();
        }
        catch (InvalidMediaTypeException ex) {
            throw new HttpMediaTypeNotSupportedException(ex.getMessage());
        }
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        Class contextClass = methodParam.getDeclaringClass();
        Map map = GenericTypeResolver.getTypeVariableMap((Class)contextClass);
        Class targetClass = GenericTypeResolver.resolveType((Type)targetType, (Map)map);
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            GenericHttpMessageConverter genericConverter;
            if (converter instanceof GenericHttpMessageConverter && (genericConverter = (GenericHttpMessageConverter)converter).canRead(targetType, contextClass, contentType)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Reading [" + targetType + "] as \"" + contentType + "\" using [" + converter + "]"));
                }
                return genericConverter.read(targetType, contextClass, inputMessage);
            }
            if (targetClass == null || !converter.canRead(targetClass, contentType)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading [" + targetClass.getName() + "] as \"" + contentType + "\" using [" + converter + "]"));
            }
            return converter.read(targetClass, inputMessage);
        }
        throw new HttpMediaTypeNotSupportedException(contentType, this.allSupportedMediaTypes);
    }

    protected ServletServerHttpRequest createInputMessage(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }
}

