/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.util.WeakListeners;

public abstract class AbstractBootPathImpl
implements ClassPathImplementation,
PropertyChangeListener {
    @NonNull
    protected final NbMavenProjectImpl project;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean activePlatformValid = true;
    final Object LOCK = new Object();
    private JavaPlatformManager platformManager;
    private List<? extends PathResourceImplementation> resourcesCache;
    protected String lastHintValue = null;

    public AbstractBootPathImpl(NbMavenProjectImpl project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                this.resourcesCache = Collections.unmodifiableList(this.createResources());
            }
            return this.resourcesCache;
        }
    }

    protected abstract List<PathResourceImplementation> createResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCache() {
        Object object = this.LOCK;
        synchronized (object) {
            this.resourcesCache = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    public static JavaPlatform getActivePlatform(String activePlatformId) {
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            return pm.getDefaultPlatform();
        }
        JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String antName = (String)installedPlatforms[i].getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return installedPlatforms[i];
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String newVal = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true);
        if (evt.getSource() == this.platformManager && "installedPlatforms".equals(evt.getPropertyName()) && this.lastHintValue != null) {
            this.lastHintValue = newVal;
            if (this.activePlatformValid) {
                if (AbstractBootPathImpl.getActivePlatform(this.lastHintValue) == null) {
                    this.resetCache();
                }
            } else if (AbstractBootPathImpl.getActivePlatform(this.lastHintValue) != null) {
                this.resetCache();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    JavaPlatform findActivePlatform() {
        Object object = this.LOCK;
        synchronized (object) {
            String val;
            JavaPlatform plat;
            this.activePlatformValid = true;
            if (this.platformManager == null) {
                this.platformManager = JavaPlatformManager.getDefault();
                this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
                NbMavenProject watch = this.project.getProjectWatcher();
                watch.addPropertyChangeListener(this);
            }
            if ((plat = AbstractBootPathImpl.getActivePlatform(val = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true))) == null) {
                Logger.getLogger(BootClassPathImpl.class.getName()).log(Level.FINE, "Cannot find java platform with id of ''{0}''", val);
                plat = this.platformManager.getDefaultPlatform();
                this.activePlatformValid = false;
            }
            return plat;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BootClassPathImpl && this.project.equals(((BootClassPathImpl)obj).project);
    }

    public int hashCode() {
        return this.project.hashCode() ^ 0xBF;
    }
}

